/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.apitef;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.Apitef;
import com.csi.ctfclient.apitef.ApitefStringUtil;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.SerializadorEntradaApitef;
import com.csi.ctfclient.apitef.annotation.FormatoBigDecimal;
import com.csi.ctfclient.apitef.annotation.FormatoData;
import com.csi.ctfclient.apitef.annotation.SubCampo;
import com.csi.ctfclient.apitef.annotation.Tipo;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.servicos.CTFClientCore;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;

public abstract class ApitefDefault
extends Apitef {
    protected static int MAX_OUTPUT_BUFFER = 40000;
    private final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Apitef.class);
    protected ApitefStringUtil stringUtil = new ApitefStringUtil();
    protected SerializadorEntradaApitef serializadorEntradaApitef = new SerializadorEntradaApitef();
    protected byte[] oper8;
    protected byte[] subcampos;
    protected byte[] output;

    public ApitefDefault(String versoesCTFClient, int timeOutDefault, boolean habilitaLog, int diasLog, String path) {
        super(versoesCTFClient, timeOutDefault, habilitaLog, diasLog, path);
    }

    private boolean isCriptografiaDesabilitada() {
        try {
            return Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig().getDesabilitaCriptografiaCTF();
        }
        catch (Exception erro) {
            this.logger.error(erro);
            return false;
        }
    }

    protected byte[] prepararOper8(IdentApiTefC identApiTefC, EntradaApiTefC entradaApiTefC) {
        String strIdent = entradaApiTefC.getOperacao() + identApiTefC.getNumeroEstabelecimento() + identApiTefC.getNumeroLoja() + identApiTefC.getNumeroPdv() + this.stringUtil.completaString(entradaApiTefC.getTimeout() + "", 4, '0', true) + this.stringUtil.completaString(entradaApiTefC.getNumeroTransacao() + "", 2, '0', true) + this.stringUtil.completaString(identApiTefC.getNumeroSites(), 2, '0', true) + this.stringUtil.completaString("", 42, ' ', true) + identApiTefC.getQuantidadeVias() + "\u0000\u0000\u0000\u0000" + (this.isCriptografiaDesabilitada() ? "1" : "0") + "\u0000";
        return strIdent.getBytes();
    }

    protected SaidaApiTefC preparaSaidaApiteC(String operacao, byte[] retorno, byte[] erro, byte[] output) {
        SaidaApiTefC saidaApiTefC = new SaidaApiTefC();
        try {
            Class<?> clazz = saidaApiTefC.getClass();
            Field[] fields = clazz.getDeclaredFields();
            HashMap<String, Field> maps = new HashMap<String, Field>();
            for (Field field : fields) {
                if (!field.isAnnotationPresent(SubCampo.class)) continue;
                SubCampo subCampo = field.getAnnotation(SubCampo.class);
                field.setAccessible(true);
                maps.put(subCampo.codigo(), field);
            }
            String strOutput = new String(output);
            int tamBuffer = strOutput.length();
            int pos = 0;
            byte[] sc80 = null;
            byte[] sc29 = null;
            this.logger.debug("preparaSaidaApiteC ->");
            byte[] campoZerado = new byte[]{0, 0, 0, 0};
            String stringZerada = new String(campoZerado);
            while (pos < tamBuffer && !strOutput.substring(pos, pos + 4).equals(stringZerada)) {
                String codigo = strOutput.substring(pos, pos + 4);
                String tamStr = strOutput.substring(pos += 4, pos + 4);
                int tamInt = Integer.parseInt(tamStr);
                String valor = strOutput.substring(pos += 4, pos + tamInt);
                pos += tamInt;
                Field field = (Field)maps.get(codigo);
                if (field == null) continue;
                SubCampo subCampo = field.getAnnotation(SubCampo.class);
                this.logger.debug(String.format("subcampo: %s -> OK = %s", subCampo.codigo(), subCampo.canPrint() ? valor : "[omitido]"));
                if (codigo.equals("0029")) {
                    sc29 = new byte[pos - (pos - tamInt)];
                    System.arraycopy(output, pos - tamInt, sc29, 0, sc29.length);
                    continue;
                }
                if (codigo.equals("0080")) {
                    sc80 = new byte[pos - (pos - tamInt)];
                    System.arraycopy(output, pos - tamInt, sc80, 0, sc80.length);
                    continue;
                }
                if (subCampo.tipo() == Tipo.INTEIRO) {
                    try {
                        if (field.getType().equals(Integer.TYPE)) {
                            field.setInt(saidaApiTefC, Integer.parseInt(valor.trim()));
                            continue;
                        }
                        if (field.getType().equals(Long.TYPE)) {
                            field.setLong(saidaApiTefC, Long.parseLong(valor.trim()));
                            continue;
                        }
                        if (field.getType().equals(Integer.class)) {
                            field.set(saidaApiTefC, new Integer(valor.trim()));
                            continue;
                        }
                        if (!field.getType().equals(Long.class)) continue;
                        field.set(saidaApiTefC, new Long(valor.trim()));
                    }
                    catch (Exception e) {
                        this.logger.info("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
                    }
                    continue;
                }
                if (subCampo.tipo() == Tipo.ALFANUMERICO) {
                    try {
                        if (subCampo.lista()) {
                            Object obj = field.get(saidaApiTefC);
                            if (obj != null) {
                                String strObj = (String)obj;
                                strObj = strObj + tamStr + valor;
                                field.set(saidaApiTefC, strObj);
                                continue;
                            }
                            field.set(saidaApiTefC, tamStr + valor);
                            continue;
                        }
                        field.set(saidaApiTefC, valor);
                    }
                    catch (Exception e) {
                        this.logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
                    }
                    continue;
                }
                if (subCampo.tipo() == Tipo.DATA) {
                    try {
                        if (!field.isAnnotationPresent(FormatoData.class)) continue;
                        FormatoData formatoData = field.getAnnotation(FormatoData.class);
                        SimpleDateFormat dateFormat = new SimpleDateFormat(formatoData.valor());
                        Date data = dateFormat.parse(valor);
                        field.set(saidaApiTefC, data);
                    }
                    catch (Exception e) {
                        this.logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
                    }
                    continue;
                }
                if (subCampo.tipo() == Tipo.MONETARIO) {
                    try {
                        int casasDecimais = 2;
                        if (field.isAnnotationPresent(FormatoBigDecimal.class)) {
                            FormatoBigDecimal formatoBigDecimal = field.getAnnotation(FormatoBigDecimal.class);
                            casasDecimais = formatoBigDecimal.casasDecimais();
                        }
                        BigDecimal bigValor = new BigDecimal(valor.trim());
                        bigValor = bigValor.movePointLeft(casasDecimais);
                        field.set(saidaApiTefC, bigValor);
                    }
                    catch (Exception e) {
                        this.logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
                    }
                    continue;
                }
                if (subCampo.tipo() == Tipo.BOOLEANO) {
                    try {
                        boolean retornoBoolean = !"0".equals(valor.trim());
                        field.set(saidaApiTefC, retornoBoolean);
                    }
                    catch (Exception e) {
                        this.logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
                    }
                    continue;
                }
                if (subCampo.tipo() != Tipo.ENUM) continue;
                try {
                    Class<?> enumClass = field.getType();
                    Method method = enumClass.getMethod("fromValue", String.class);
                    Object parsedValue = method.invoke(null, valor);
                    field.set(saidaApiTefC, parsedValue);
                }
                catch (Exception e) {
                    this.logger.warn("Erro ao definir valor de enumerado: " + e.getMessage());
                    this.logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
                }
            }
            if (sc29 != null) {
                int pos29 = 0;
                String strSC29 = new String(sc29);
                if ("1F".equals(operacao) && strSC29.length() >= 17) {
                    saidaApiTefC.setDadosAdicionais(strSC29);
                    pos29 = 2;
                    String valor = this.recuperaBuffer(strSC29, pos29, 2);
                    pos29 += 2;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setQtdMinimaParcelaSemJuros(this.convertINT(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 2);
                    pos29 += 2;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setQtdMaximaParcelaSemJuros(this.convertINT(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 2);
                    pos29 += 2;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setQtdMinimoParcelaComJuros(this.convertINT(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 2);
                    pos29 += 2;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setQtdMaximaParcelaComJuros(this.convertINT(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 2);
                    pos29 += 2;
                    try {
                        if (valor.trim().length() == 0) {
                            valor = "00";
                        }
                        saidaApiTefC.setTaxaServico(new BigDecimal(valor));
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 1);
                    ++pos29;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setCompraSaque(this.convertBoolean(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 2);
                    pos29 += 2;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setMaximoMesesAgendamento(this.convertINT(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 2);
                    pos29 += 2;
                    try {
                        if (valor.trim().length() == 0) {
                            valor = "00";
                        }
                        saidaApiTefC.setTaxaEmbarque(new BigDecimal(valor));
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                } else {
                    saidaApiTefC.setDadosAdicionais(strSC29);
                }
                if ("1F".equals(operacao) && strSC29.length() >= 21) {
                    String valor = this.recuperaBuffer(strSC29, pos29, 1);
                    ++pos29;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setConsultaFinanciamento(this.convertINT(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 1);
                    ++pos29;
                    try {
                        if (valor.trim().length() == 0) {
                            valor = "0";
                        }
                        saidaApiTefC.setCapturaCiclos(this.convertINT(valor));
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 1);
                    ++pos29;
                    try {
                        if (valor.trim().length() == 0) {
                            valor = "0";
                        }
                        saidaApiTefC.setFlagCodAutDig(valor);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 1);
                    try {
                        if (valor.trim().length() == 0) {
                            valor = "0";
                        }
                        saidaApiTefC.setFlagCodAutMag(valor);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                }
                if ("F4".equals(operacao) && strSC29.length() >= 224) {
                    pos29 = 0;
                    String valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValorMinimoCD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValorMaximoCD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 2);
                    pos29 += 2;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setQtdeValoresCD(this.convertINT(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValor1CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValor2CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValor3CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValor4CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValor5CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValor6CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValor7CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValor8CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValor9CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setValor10CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 2);
                    pos29 += 2;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setQtdeBonusCD(this.convertINT(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setBonus1CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setBonus2CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setBonus3CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setBonus4CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setBonus5CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setBonus6CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setBonus7CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setBonus8CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    pos29 += 10;
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setBonus9CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                    valor = this.recuperaBuffer(strSC29, pos29, 10);
                    try {
                        if (valor.trim().length() > 0) {
                            saidaApiTefC.setBonus10CD(this.convertBigDecimal(valor));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                }
            }
            if (sc80 != null) {
                int pos80 = 0;
                String strSC80 = new String(sc80);
                try {
                    String valor = this.recuperaBuffer(strSC80, pos80, 2);
                    pos80 += 2;
                    if ((saidaApiTefC.getCodigoAutorizadora() == null || "00".equals(saidaApiTefC.getCodigoAutorizadora())) && valor.trim().length() > 0) {
                        saidaApiTefC.setCodigoAutorizadora(valor);
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                try {
                    String valor = this.recuperaBuffer(strSC80, pos80, 12);
                    pos80 += 12;
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setNomeAutorizadora(valor);
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                try {
                    String valor = this.recuperaBuffer(strSC80, pos80, 2);
                    pos80 += 2;
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setCodigoVan(valor);
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                try {
                    String valor = this.recuperaBuffer(strSC80, pos80, 12);
                    pos80 += 12;
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setNomeVan(valor);
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                try {
                    String valor = this.recuperaBuffer(strSC80, pos80, 6);
                    pos80 += 6;
                    if (saidaApiTefC.getCodigoAprovacao() == null && valor.trim().length() > 0) {
                        saidaApiTefC.setCodigoAprovacao(valor);
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                try {
                    String valor = this.recuperaBuffer(strSC80, pos80, 4);
                    pos80 += 4;
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setCodigoInstituicaoFinanceira(this.convertINT(valor));
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                try {
                    String valor = this.recuperaBuffer(strSC80, pos80, 12);
                    pos80 += 12;
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setNomeInstituicaoFinanceira(valor);
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                String valor = this.recuperaBuffer(strSC80, pos80, 6);
                pos80 += 6;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setNsuCTF(this.convertINT(valor));
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 12);
                pos80 += 12;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setValorParcela(this.convertBigDecimal(valor));
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 12);
                pos80 += 12;
                try {
                    if (saidaApiTefC.getValorTotal() == null && valor.trim().length() > 0) {
                        saidaApiTefC.setValorTotal(this.convertBigDecimal(valor));
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 5);
                pos80 += 5;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setTaxaJuros(this.convertBigDecimal(valor));
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 1);
                ++pos80;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setValidaCartao(valor);
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                byte sol_senha = sc80[pos80];
                ++pos80;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setFlagTrataSenha((char)sol_senha);
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 9);
                pos80 += 9;
                try {
                    if ((saidaApiTefC.getNsuAutorizacao() == null || "0".equals(saidaApiTefC.getNsuAutorizacao())) && valor.trim().length() > 0) {
                        saidaApiTefC.setNsuAutorizacao(valor);
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 1);
                ++pos80;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setHabilitaCDC_PRE(this.convertINT(valor));
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 15);
                pos80 += 15;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setCodigoEstabelecimento(valor);
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 14);
                pos80 += 14;
                try {
                    if (valor.trim().length() > 0) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyyHHmmss");
                        saidaApiTefC.setDataAutorizadora(dateFormat.parse(valor));
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 12);
                pos80 += 12;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setValorTransacao_SC80(this.convertBigDecimal(valor));
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 1);
                ++pos80;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setNumeroViasCartao(this.convertINT(valor));
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 50);
                pos80 += 50;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setLogomarca(valor);
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 12);
                pos80 += 12;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setSaldoCliente(this.convertBigDecimal(valor));
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 4);
                pos80 += 4;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setVencimentoCartao(valor);
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 1);
                ++pos80;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setTipoAprovacao(this.convertINT(valor));
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 6);
                pos80 += 6;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setCodigoProcesso(this.convertINT(valor));
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 4);
                pos80 += 4;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setMac(this.convertINT(valor));
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                valor = this.recuperaBuffer(strSC80, pos80, 1);
                ++pos80;
                try {
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setTipoCartao(this.convertINT(valor));
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                try {
                    valor = this.recuperaBuffer(strSC80, pos80, 16);
                    if (valor.trim().length() > 0) {
                        saidaApiTefC.setWK80(valor);
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
            }
            saidaApiTefC.setRetorno(Integer.parseInt(new String(retorno)));
            saidaApiTefC.setCodigoErro(Integer.parseInt(new String(erro)));
        }
        catch (Exception e) {
            this.logger.fatal("Erro durante a interpreta\u00e7\u00e3o dos dados do CTF: " + e.getMessage(), e);
            saidaApiTefC.setRetorno(20);
            saidaApiTefC.setCodigoErro(5331);
            saidaApiTefC.setDisplayCTF("0015TENTE NOVAMENTE");
        }
        return saidaApiTefC;
    }

    private String recuperaBuffer(String buffer, int pos, int tam) {
        try {
            return buffer.substring(pos, pos + tam);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return "";
        }
    }

    private int convertINT(String valor) {
        if (valor == null || valor.trim().length() == 0) {
            return 0;
        }
        return Integer.parseInt(valor.trim());
    }

    private BigDecimal convertBigDecimal(String valor) {
        if (valor == null || valor.trim().length() == 0) {
            return null;
        }
        return new BigDecimal(valor.trim()).movePointLeft(2);
    }

    private boolean convertBoolean(String valor) {
        if (valor == null || valor.trim().length() == 0) {
            return false;
        }
        int b = Integer.parseInt(valor);
        return b == 1;
    }

    @Override
    public void insereSubcampoSaida(int numeroSubcampo, String s) {
        String oldOutput = new String(this.output);
        int pZero = oldOutput.indexOf("\u0000");
        if (pZero >= 0) {
            oldOutput = oldOutput.substring(0, pZero);
        }
        StringBuilder builder = new StringBuilder(oldOutput);
        builder.append(new String(this.output).trim());
        builder.append(String.format("%04d%04d%s", numeroSubcampo, s.length(), s));
        builder.append("\u0000");
        builder.ensureCapacity(oldOutput.length() + 100);
        this.output = builder.toString().getBytes();
    }

    static class FieldObject {
        public Field field;
        public Object object;

        FieldObject() {
        }
    }
}

