/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.apitef;

import com.csi.ctfclient.apitef.ApitefDefault;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.LibApitefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.sun.jna.Native;
import java.util.Arrays;

public class ApitefJNA
extends ApitefDefault {
    private LibApitefC libApitefC = (LibApitefC)Native.loadLibrary((String)"apiwebctf", LibApitefC.class);

    public ApitefJNA(String versoesCTFClient, int timeOutDefault, boolean habilitaLog, int diasLog, String path) {
        super(versoesCTFClient, timeOutDefault, habilitaLog, diasLog, path);
    }

    @Override
    protected int getCupomTEF(IdentApiTefC identApiTefC, EntradaApiTefC entradaApiTefC, SaidaApiTefC saidaApiTefC) {
        byte[] retorno = new byte[3];
        byte[] erro = new byte[5];
        this.libApitefC.getCupomTEF(new byte[256], this.oper8, retorno, erro, this.subcampos, this.output);
        retorno = Arrays.copyOfRange(retorno, 0, 2);
        return Integer.parseInt(new String(retorno));
    }

    @Override
    protected SaidaApiTefC solicitacaoTEF(IdentApiTefC identApiTefC, EntradaApiTefC entradaApiTefC) {
        byte[] retorno = new byte[3];
        byte[] erro = new byte[5];
        this.oper8 = this.prepararOper8(identApiTefC, entradaApiTefC);
        this.subcampos = this.serializadorEntradaApitef.prepararSubCampo(entradaApiTefC);
        this.output = new byte[MAX_OUTPUT_BUFFER];
        byte[] diretorio = new byte[256];
        this.libApitefC.solicitacaoTEF(diretorio, this.oper8, retorno, erro, this.subcampos, this.output);
        retorno = Arrays.copyOfRange(retorno, 0, 2);
        erro = Arrays.copyOfRange(erro, 0, 4);
        SaidaApiTefC saidaApiTefC = this.preparaSaidaApiteC(entradaApiTefC.getOperacao(), retorno, erro, this.output);
        if (saidaApiTefC.getFlagBaixaTecnica() == '0') {
            entradaApiTefC.setFlagBaixaTecnicaVisanet('0');
        }
        return saidaApiTefC;
    }

    @Override
    protected SaidaApiTefC confirmacaoTEF(IdentApiTefC identApiTefC, EntradaApiTefC entradaApiTefC) {
        byte[] retorno = new byte[3];
        byte[] erro = new byte[5];
        this.oper8 = this.prepararOper8(this.getIdentApiTefC(), entradaApiTefC);
        this.subcampos = this.serializadorEntradaApitef.prepararSubCampo(entradaApiTefC);
        this.output = new byte[MAX_OUTPUT_BUFFER];
        this.libApitefC.confirmacaoTEF(new byte[256], this.oper8, retorno, erro, this.subcampos, this.output);
        retorno = Arrays.copyOfRange(retorno, 0, 2);
        erro = Arrays.copyOfRange(erro, 0, 4);
        SaidaApiTefC saidaApiTefC = this.preparaSaidaApiteC(entradaApiTefC.getOperacao(), retorno, erro, this.output);
        return saidaApiTefC;
    }

    @Override
    protected SaidaApiTefC desfazimentoTEF(IdentApiTefC identApiTefC, EntradaApiTefC entradaApiTefC) {
        byte[] retorno = new byte[3];
        byte[] erro = new byte[5];
        this.oper8 = this.prepararOper8(identApiTefC, entradaApiTefC);
        this.subcampos = this.serializadorEntradaApitef.prepararSubCampo(entradaApiTefC);
        this.output = new byte[MAX_OUTPUT_BUFFER];
        this.libApitefC.desfazimentoTEF(new byte[256], this.oper8, retorno, erro, this.subcampos, this.output);
        retorno = Arrays.copyOfRange(retorno, 0, 2);
        erro = Arrays.copyOfRange(erro, 0, 4);
        SaidaApiTefC saidaApiTefC = this.preparaSaidaApiteC(entradaApiTefC.getOperacao(), retorno, erro, this.output);
        return saidaApiTefC;
    }

    @Override
    protected SaidaApiTefC getTransactionNumberTEF(IdentApiTefC identApiTefC, EntradaApiTefC entradaApiTefC) {
        this.oper8 = this.prepararOper8(identApiTefC, entradaApiTefC);
        this.subcampos = this.serializadorEntradaApitef.prepararSubCampo(entradaApiTefC);
        byte[] errorCode = new byte[5];
        int numTrans = this.libApitefC.getTransactionNumberTEF(new byte[256], this.oper8, errorCode, this.subcampos);
        SaidaApiTefC out = new SaidaApiTefC();
        out.num_trans(numTrans);
        out.setCodigoErro(Integer.parseInt(new String(Arrays.copyOfRange(errorCode, 0, 4))));
        if (!out.getCodigoErro().equals("0000")) {
            out.setRetorno(1);
        } else {
            out.setRetorno(0);
        }
        return out;
    }
}

