/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.apitef;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.Apitef;
import com.csi.ctfclient.apitef.ApitefDefault;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.Request;
import com.csi.ctfclient.apitef.Response;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.annotation.SubCampo;
import com.csi.ctfclient.servicos.CTFClientCore;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;

public class ApitefJNI
extends ApitefDefault {
    private AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Apitef.class);

    public ApitefJNI(String versoesCTFClient, int timeOutDefault, boolean habilitaLog, int diasLog, String path) {
        super(versoesCTFClient, timeOutDefault, habilitaLog, diasLog, path);
    }

    private native Response solicitacaoTEF2(Request var1);

    private native Response confirmacaoTEF2(Request var1);

    private native Response desfazimentoTEF2(Request var1);

    private native int getCupomTEF2(Request var1);

    private native Response getTransactionNumberTEF2();

    @Override
    protected int getCupomTEF(IdentApiTefC identApiTefC, EntradaApiTefC entradaApiTefC, SaidaApiTefC saidaApiTefC) {
        Class<?> entradaClazz = entradaApiTefC.getClass();
        Field[] fields = entradaClazz.getDeclaredFields();
        HashMap<String, Field> entradaMaps = new HashMap<String, Field>();
        for (Field field : fields) {
            if (!field.isAnnotationPresent(SubCampo.class)) continue;
            SubCampo subCampo = field.getAnnotation(SubCampo.class);
            field.setAccessible(true);
            entradaMaps.put(subCampo.codigo(), field);
        }
        Class<?> clazz = saidaApiTefC.getClass();
        fields = clazz.getDeclaredFields();
        HashMap<String, Field> saidaMaps = new HashMap<String, Field>();
        for (Field field : fields) {
            if (!field.isAnnotationPresent(SubCampo.class)) continue;
            SubCampo subCampo = field.getAnnotation(SubCampo.class);
            field.setAccessible(true);
            saidaMaps.put(subCampo.codigo(), field);
        }
        this.oper8 = this.prepararOper8(identApiTefC, entradaApiTefC);
        StringBuilder builder = new StringBuilder();
        try {
            Field field = (Field)entradaMaps.get("0048");
            SubCampo subCampo = field.getAnnotation(SubCampo.class);
            String strSubCampo = this.stringUtil.formataSubCampo(subCampo, field, entradaApiTefC);
            if (strSubCampo != null) {
                builder.append(strSubCampo);
            }
            if ((strSubCampo = this.stringUtil.formataSubCampo(subCampo = (field = (Field)entradaMaps.get("0120")).getAnnotation(SubCampo.class), field, entradaApiTefC)) != null) {
                builder.append(strSubCampo);
            }
            if ((strSubCampo = this.stringUtil.formataSubCampo(subCampo = (field = (Field)saidaMaps.get("0083")).getAnnotation(SubCampo.class), field, saidaApiTefC)) != null) {
                builder.append(strSubCampo);
            }
            if ((strSubCampo = this.stringUtil.formataSubCampo(subCampo = (field = (Field)saidaMaps.get("0084")).getAnnotation(SubCampo.class), field, saidaApiTefC)) != null) {
                builder.append(strSubCampo);
            }
            if ((strSubCampo = this.stringUtil.formataSubCampo(subCampo = (field = (Field)saidaMaps.get("0157")).getAnnotation(SubCampo.class), field, saidaApiTefC)) != null) {
                builder.append(strSubCampo);
            }
            if ((strSubCampo = this.stringUtil.formataSubCampo(subCampo = (field = (Field)saidaMaps.get("0162")).getAnnotation(SubCampo.class), field, saidaApiTefC)) != null) {
                builder.append(strSubCampo);
            }
            if ((strSubCampo = this.stringUtil.formataSubCampo(subCampo = (field = (Field)saidaMaps.get("0164")).getAnnotation(SubCampo.class), field, saidaApiTefC)) != null) {
                builder.append(strSubCampo);
            }
            if ((strSubCampo = this.stringUtil.formataSubCampo(subCampo = (field = (Field)saidaMaps.get("0165")).getAnnotation(SubCampo.class), field, saidaApiTefC)) != null) {
                builder.append(strSubCampo);
            }
        }
        catch (Exception e) {
            this.logger.error("Erro ao formatar cupom: " + e.getMessage());
        }
        byte[] array = new byte[builder.length() + 100];
        System.arraycopy(builder.toString().getBytes(), 0, array, 0, builder.length());
        Request request = new Request();
        request.setOper8(new String(this.oper8));
        request.setInput(new String(array) + "\u0000");
        this.preparaPath(identApiTefC, request);
        return this.getCupomTEF2(request);
    }

    @Override
    protected SaidaApiTefC solicitacaoTEF(IdentApiTefC identApiTefC, EntradaApiTefC entradaApiTefC) {
        this.oper8 = this.prepararOper8(identApiTefC, entradaApiTefC);
        this.subcampos = this.serializadorEntradaApitef.prepararSubCampo(entradaApiTefC);
        Request request = new Request();
        request.setOper8(new String(this.oper8));
        request.setInput(new String(this.subcampos) + "\u0000");
        this.preparaPath(identApiTefC, request);
        Response response = this.solicitacaoTEF2(request);
        String ret = this.stringUtil.completaString(response.getRet() + "", 2, '0', true);
        String erro = this.stringUtil.completaString(response.getErro() + "", 4, '0', true);
        this.output = response.getOutput() != null ? response.getOutput().getBytes() : "".getBytes();
        return this.preparaSaidaApiteC(entradaApiTefC.getOperacao(), ret.getBytes(), erro.getBytes(), this.output);
    }

    @Override
    protected SaidaApiTefC confirmacaoTEF(IdentApiTefC identApiTefC, EntradaApiTefC entradaApiTefC) {
        this.oper8 = this.prepararOper8(identApiTefC, entradaApiTefC);
        this.subcampos = this.serializadorEntradaApitef.prepararSubCampo(entradaApiTefC);
        Request request = new Request();
        request.setOper8(new String(this.oper8));
        request.setInput(new String(this.subcampos) + "\u0000");
        this.preparaPath(identApiTefC, request);
        Response response = this.confirmacaoTEF2(request);
        String ret = this.stringUtil.completaString(response.getRet() + "", 2, '0', true);
        String erro = this.stringUtil.completaString(response.getErro() + "", 4, '0', true);
        this.output = response.getOutput() != null ? response.getOutput().getBytes() : "".getBytes();
        return this.preparaSaidaApiteC(entradaApiTefC.getOperacao(), ret.getBytes(), erro.getBytes(), response.getOutput().getBytes());
    }

    @Override
    protected SaidaApiTefC desfazimentoTEF(IdentApiTefC identApiTefC, EntradaApiTefC entradaApiTefC) {
        this.oper8 = this.prepararOper8(identApiTefC, entradaApiTefC);
        this.subcampos = this.serializadorEntradaApitef.prepararSubCampo(entradaApiTefC);
        Request request = new Request();
        request.setOper8(new String(this.oper8));
        request.setInput(new String(this.subcampos) + "\u0000");
        this.preparaPath(identApiTefC, request);
        Response response = this.desfazimentoTEF2(request);
        String ret = this.stringUtil.completaString(response.getRet() + "", 2, '0', true);
        String erro = this.stringUtil.completaString(response.getErro() + "", 4, '0', true);
        this.output = response.getOutput() != null ? response.getOutput().getBytes() : "".getBytes();
        return this.preparaSaidaApiteC(entradaApiTefC.getOperacao(), ret.getBytes(), erro.getBytes(), response.getOutput().getBytes());
    }

    @Override
    protected SaidaApiTefC getTransactionNumberTEF(IdentApiTefC terminaldId, EntradaApiTefC ctfIn) {
        Response response = this.getTransactionNumberTEF2();
        String erro = this.stringUtil.completaString(response.getErro() + "", 4, '0', true);
        this.output = response.getOutput() != null ? response.getOutput().getBytes() : "".getBytes();
        SaidaApiTefC ret = new SaidaApiTefC();
        ret.num_trans(Integer.parseInt(new String(this.output)));
        ret.setCodigoErro(Integer.parseInt(erro));
        if (!ret.getCodigoErro().equals("0000")) {
            ret.setRetorno(1);
        }
        return ret;
    }

    private void preparaPath(IdentApiTefC identApiTefC, Request request) {
        if (this.getPath() != null) {
            int idxEmpresa = this.getVersaoPathTerminal() == 1 ? 0 : 1;
            String path = this.getPath() + identApiTefC.getNumeroEstabelecimento().substring(idxEmpresa) + identApiTefC.getNumeroLoja() + "." + identApiTefC.getNumeroPdv() + File.separator;
            request.setPath(path);
            File filePath = new File(path);
            if (!filePath.exists()) {
                filePath.mkdir();
            }
        }
    }

    static {
        System.loadLibrary("apiwebctf");
    }
}

