/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.apitef;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.ApitefDefault;
import com.csi.ctfclient.apitef.ApitefStringUtil;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.annotation.FormatoLista;
import com.csi.ctfclient.apitef.annotation.SubCampo;
import com.csi.ctfclient.apitef.annotation.SubCampos;
import com.csi.ctfclient.servicos.CTFClientCore;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class SerializadorEntradaApitef {
    private AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(SerializadorEntradaApitef.class);
    private ApitefStringUtil stringUtil = new ApitefStringUtil();

    public String serializar(EntradaApiTefC entrada) {
        StringBuilder builder = new StringBuilder();
        if ("1F".equals(entrada.getOperacao()) || "1G".equals(entrada.getOperacao()) || "5N".equals(entrada.getOperacao())) {
            entrada.setAdicionais(entrada.getOperacaoConsultada());
        }
        if (entrada.getDadosCreditoDigital() != null) {
            entrada.setInfo(entrada.getDadosCreditoDigital());
        }
        try {
            Comparator<ApitefDefault.FieldObject> comparator = new Comparator<ApitefDefault.FieldObject>(){

                @Override
                public int compare(ApitefDefault.FieldObject fieldA, ApitefDefault.FieldObject fieldB) {
                    if (fieldA.field.isAnnotationPresent(SubCampo.class) && fieldB.field.isAnnotationPresent(SubCampo.class)) {
                        SubCampo subCampoA = fieldA.field.getAnnotation(SubCampo.class);
                        SubCampo subCampoB = fieldB.field.getAnnotation(SubCampo.class);
                        return subCampoA.codigo().compareTo(subCampoB.codigo());
                    }
                    return -1;
                }
            };
            Class<?> clazz = entrada.getClass();
            List<Field> fieldsList = Arrays.asList(clazz.getDeclaredFields());
            TreeSet<ApitefDefault.FieldObject> fields = new TreeSet<ApitefDefault.FieldObject>(comparator);
            for (Field field : fieldsList) {
                Field[] innerFields;
                if (field.isAnnotationPresent(SubCampo.class)) {
                    ApitefDefault.FieldObject fieldObject = new ApitefDefault.FieldObject();
                    fieldObject.field = field;
                    fieldObject.object = entrada;
                    fields.add(fieldObject);
                    continue;
                }
                if (!field.isAnnotationPresent(SubCampos.class)) continue;
                for (Field innerField : innerFields = field.getType().getDeclaredFields()) {
                    if (!innerField.isAnnotationPresent(SubCampo.class)) continue;
                    ApitefDefault.FieldObject fieldObject = new ApitefDefault.FieldObject();
                    fieldObject.field = innerField;
                    field.setAccessible(true);
                    fieldObject.object = field.get(entrada);
                    if (fieldObject.object == null) continue;
                    fields.add(fieldObject);
                }
            }
            this.logger.debug("prepararSubcampo ->");
            for (ApitefDefault.FieldObject fieldObject : fields) {
                if (!fieldObject.field.isAnnotationPresent(SubCampo.class)) continue;
                this.recuperaField(builder, fieldObject);
            }
        }
        catch (Exception e) {
            this.logger.error(e);
        }
        return builder.toString();
    }

    public void logDetalhado(EntradaApiTefC entrada) {
        try {
            String str = this.serializar(entrada);
            while (str.length() >= 8) {
                int campo = Integer.parseInt(str.substring(0, 4));
                int tamanho = Integer.parseInt(str.substring(4, 8));
                String valor = str.substring(8, 8 + tamanho);
                this.logger.debug(Integer.toString(campo) + " <-- " + valor);
                str = str.substring(8 + tamanho);
            }
        }
        catch (Exception erro) {
            this.logger.error("Erro logando entrada apitefc: " + erro.getMessage());
        }
    }

    public byte[] prepararSubCampo(EntradaApiTefC entrada) {
        String str = this.serializar(entrada) + "\u0000";
        byte[] array = new byte[str.length() + 100];
        System.arraycopy(str.getBytes(), 0, array, 0, str.length());
        return array;
    }

    private void recuperaField(StringBuilder builder, ApitefDefault.FieldObject field) throws Exception {
        SubCampo subCampo = field.field.getAnnotation(SubCampo.class);
        if (field.object == null) {
            return;
        }
        field.field.setAccessible(true);
        Object valorObj = field.field.get(field.object);
        if (subCampo.lista()) {
            if (valorObj == null) {
                return;
            }
            String codigoSubcampo = subCampo.codigo();
            boolean repeteSubcampo = true;
            if (field.field.isAnnotationPresent(FormatoLista.class)) {
                FormatoLista formatoLista = field.field.getAnnotation(FormatoLista.class);
                repeteSubcampo = formatoLista.repeteCodigoSubCampo();
            }
            boolean tipoLista = valorObj instanceof List;
            boolean tipoArray = valorObj.getClass().isArray();
            if (tipoLista || tipoArray) {
                List<String> lista = null;
                if (tipoArray && valorObj instanceof String[]) {
                    lista = Arrays.asList((String[])valorObj);
                }
                if (lista != null) {
                    for (String strValor : lista) {
                        strValor = this.stringUtil.completaString(strValor.length() + "", 4, '0', true) + strValor;
                        builder.append(codigoSubcampo + strValor);
                        if (repeteSubcampo) continue;
                        int codigo = Integer.parseInt(codigoSubcampo);
                        codigoSubcampo = this.stringUtil.completaString(codigo + 1 + "", 4, '0', true);
                    }
                }
            } else {
                String dados = (String)field.field.get(field.object);
                if (dados.length() < 4) {
                    return;
                }
                int offset = 0;
                do {
                    String strTam = dados.substring(offset, offset + 4);
                    int tam = Integer.parseInt(strTam);
                    String valor = dados.substring(offset, offset + (tam += 4));
                    offset += tam;
                    builder.append(codigoSubcampo + valor);
                    if (repeteSubcampo) continue;
                    int codigo = Integer.parseInt(codigoSubcampo);
                    codigoSubcampo = this.stringUtil.completaString(codigo + 1 + "", 4, '0', true);
                } while (offset + 4 <= dados.length());
            }
            this.logger.debug("subcampo: " + subCampo.codigo() + " -> OK");
        } else {
            String strSubcampo = this.stringUtil.formataSubCampo(subCampo, field.field, field.object);
            if (strSubcampo != null) {
                builder.append(strSubcampo);
            }
        }
    }
}

