/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.apitef.util;

import com.csi.ctfclient.apitef.model.ConfirmacaoPositiva;
import com.csi.ctfclient.apitef.model.DadosConfirmacaoPositiva;
import com.csi.ctfclient.apitef.model.DadosTelefone;
import com.csi.ctfclient.apitef.model.InformacoesAdicionais;
import com.csi.ctfclient.apitef.model.ProdutoConvenioCombustivel;
import com.csi.ctfclient.apitef.model.ProdutoPromocional;
import com.csi.ctfclient.apitef.model.ProdutoValeGas;
import com.csi.ctfclient.apitef.model.ResumoEstatistica;
import com.csi.ctfclient.tools.util.StringUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class EntradaApiTefCUtil {
    private static final DecimalFormat FORMAT_2_ZEROS = new DecimalFormat("00");
    private static final DecimalFormat FORMAT_4_ZEROS = new DecimalFormat("0000");

    public String formataEcid(String ecid) {
        return ecid != null ? StringUtil.completaString(ecid + "", 2, '0', true) : null;
    }

    public String formataMcc(String mcc) {
        return mcc != null ? StringUtil.completaString(mcc + "", 4, '0', true) : null;
    }

    public String formataFlagPerguntasAdicionais(char flag) {
        return new Character(flag).toString();
    }

    public int formataLitros(BigDecimal valor) {
        return valor.movePointRight(3).intValue();
    }

    public int formataPrecoUnitarioLitroCombustivel(BigDecimal valor) {
        return valor == null ? 0 : valor.movePointRight(3).intValue();
    }

    public String formataListProdutoConvenioCombustivel(List<ProdutoConvenioCombustivel> valor, int versao) {
        StringBuffer bufferProdutos = new StringBuffer();
        for (ProdutoConvenioCombustivel produto : valor) {
            String strValor;
            bufferProdutos.append(produto.getCodigo());
            if (versao >= 2) {
                strValor = "0";
                if (produto.getQuantidade() != null) {
                    strValor = produto.getQuantidade().movePointRight(2).toString();
                }
                bufferProdutos.append(StringUtil.completaString(strValor, 12, '0', 3));
            }
            if (versao < 3) continue;
            strValor = "0";
            if (produto.getValorUnitario() != null) {
                strValor = produto.getValorUnitario().movePointRight(2).toString();
            }
            bufferProdutos.append(StringUtil.completaString(strValor, 12, '0', 3));
        }
        return bufferProdutos.toString();
    }

    public String formataDadosProdutosPromocionais(List<ProdutoPromocional> listProdutos) {
        if (listProdutos != null && listProdutos.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            for (ProdutoPromocional produto : listProdutos) {
                buffer.append(StringUtil.completaString(produto.getCodigoEAN(), 20, ' ', 4));
                buffer.append(StringUtil.completaString(String.valueOf(produto.getQuantidade()), 3, '0', 3));
                buffer.append(StringUtil.completaString(produto.getValorProduto().movePointRight(2).toString(), 7, '0', 3));
            }
            return buffer.toString();
        }
        return null;
    }

    public char formataModoCriptografiaDados(byte valor) {
        return Byte.toString(valor).charAt(0);
    }

    public String montaInfoConsultaAnaliticaSpc(int codigoCliente, int tipoDocumento, String documento, int tipoConsultaSpc, String codigoUsuarioPdv) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(StringUtil.completaString("" + codigoCliente, 15, '0', 3));
        stringBuffer.append(tipoDocumento);
        stringBuffer.append(StringUtil.completaString(this.getStringNullComLimite(documento, 17), 17, '0', 3));
        stringBuffer.append(tipoConsultaSpc);
        stringBuffer.append(StringUtil.completaString(this.getStringNullComLimite(codigoUsuarioPdv, 10), 10, ' ', 4));
        return stringBuffer.toString();
    }

    public String montaBit62ConsultaAnaliticaSpc(String nomeCliente, Date dataNascimentoCliente) {
        StringBuffer stringBuffer = new StringBuffer();
        DecimalFormat format2Zeros = new DecimalFormat("00");
        stringBuffer.append(format2Zeros.format(this.getStringNull(nomeCliente).length()));
        stringBuffer.append(StringUtil.completaString(this.getStringNull(nomeCliente), 40, ' ', 4));
        if (dataNascimentoCliente != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");
            stringBuffer.append(dateFormat.format(dataNascimentoCliente));
        } else {
            stringBuffer.append("        ");
        }
        return stringBuffer.toString();
    }

    public String formataEstatistica(ResumoEstatistica estatistica) {
        StringBuffer stringBuffer = new StringBuffer();
        DecimalFormat format3Zeros = new DecimalFormat("000");
        stringBuffer.append(StringUtil.completaString(this.getStringNullComLimite(estatistica.getFabricantePinpad(), 20), 20, ' ', false));
        stringBuffer.append(StringUtil.completaString(this.getStringNullComLimite(estatistica.getNumeroSeriePinpad(), 20), 20, ' ', false));
        stringBuffer.append(StringUtil.completaString(this.getStringNullComLimite(estatistica.getVersaoHardwarePinpad(), 20), 20, ' ', false));
        stringBuffer.append(StringUtil.completaString(this.getStringNullComLimite(estatistica.getVersaoFirmwarePinpad(), 20), 20, ' ', false));
        stringBuffer.append(StringUtil.completaString(this.getStringNullComLimite(estatistica.getVersaoAplBasica(), 20), 20, ' ', false));
        stringBuffer.append(StringUtil.completaString(this.getStringNullComLimite(estatistica.getNomeFabricanteTef(), 20), 20, ' ', false));
        stringBuffer.append(StringUtil.completaString(this.getStringNullComLimite(estatistica.getVersaoAplTef(), 20), 20, ' ', false));
        stringBuffer.append(StringUtil.completaString(this.getStringNullComLimite(estatistica.getNomeFabricanteAc(), 20), 20, ' ', false));
        stringBuffer.append(StringUtil.completaString(this.getStringNullComLimite(estatistica.getVersaoAplAc(), 20), 20, ' ', false));
        stringBuffer.append(format3Zeros.format(estatistica.getQtdeLeituraMagnetico()));
        stringBuffer.append(format3Zeros.format(estatistica.getQtdeErroLeituraMagnetico()));
        stringBuffer.append(format3Zeros.format(estatistica.getQtdeSenhaPinMagnetico()));
        stringBuffer.append(format3Zeros.format(estatistica.getQtdeErroSenhaPinMagnetico()));
        stringBuffer.append(format3Zeros.format(estatistica.getQtdeSenhaOnlineChip()));
        stringBuffer.append(format3Zeros.format(estatistica.getQtdeErroSenhaOnlineChip()));
        stringBuffer.append(format3Zeros.format(estatistica.getQtdeSenhaOfflineChip()));
        stringBuffer.append(format3Zeros.format(estatistica.getQtdeErroSenhaOfflineChip()));
        stringBuffer.append(format3Zeros.format(estatistica.getQtdeCartoesBloqErroSenhaChip()));
        stringBuffer.append(format3Zeros.format(estatistica.getQtdeLeituraSmart()));
        stringBuffer.append(format3Zeros.format(estatistica.getQtdeFallbackChipCredito()));
        stringBuffer.append(format3Zeros.format(estatistica.getQtdeFallbackChipDebito()));
        stringBuffer.append(StringUtil.completaString(this.getStringNullComLimite(estatistica.getVersaoKernelEMV(), 30), 30, ' ', 4));
        stringBuffer.append(StringUtil.completaString(this.getStringNullComLimite(estatistica.getVersaoEspecificacao(), 5), 5, ' ', 4));
        return stringBuffer.toString();
    }

    public String formataProdutosConvenioDatasus(Vector<String> produtos) {
        if (produtos == null || produtos.size() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (String produto : produtos) {
            String tam = StringUtil.completaString("" + produto.length(), 4, '0', true);
            buffer.append(tam + produto);
        }
        return buffer.toString();
    }

    public String formataDadosCreditoDigital(DadosTelefone creditoDigital) {
        String value = "";
        if (creditoDigital.getVersaoLayout() == 3) {
            String autorizadoraTelefonia = creditoDigital.getCodigoAutorizadora() != null ? creditoDigital.getCodigoAutorizadora() : "";
            String coditoUsuarioPdv = creditoDigital.getCodigoUsuarioPdv() != null ? creditoDigital.getCodigoUsuarioPdv() : "";
            value = StringUtil.completeStringCHAR(autorizadoraTelefonia, 2) + StringUtil.completeStringZERO(String.valueOf(creditoDigital.getDdd().length()), 2) + creditoDigital.getDdd() + StringUtil.completeStringZERO(String.valueOf(creditoDigital.getTelefone().length()), 2) + creditoDigital.getTelefone() + StringUtil.completeNumberZERO(creditoDigital.getDigitoVerificadortelefone(), 2) + StringUtil.completeStringCHAR(coditoUsuarioPdv, 10) + StringUtil.completeNumberZERO(creditoDigital.getTipoCreditoCompra(), 2);
        } else {
            String autorizadoraTelefonia = creditoDigital.getCodigoAutorizadora() != null ? creditoDigital.getCodigoAutorizadora() : "";
            String coditoUsuarioPdv = creditoDigital.getCodigoUsuarioPdv() != null ? creditoDigital.getCodigoUsuarioPdv() : "";
            value = StringUtil.completeStringCHAR(autorizadoraTelefonia, 2) + StringUtil.completeStringZERO(creditoDigital.getDdd(), 3) + StringUtil.completeStringZERO(creditoDigital.getTelefone(), 8) + StringUtil.completeNumberZERO(creditoDigital.getDigitoVerificadortelefone(), 2) + StringUtil.completeStringCHAR(coditoUsuarioPdv, 10) + StringUtil.completeNumberZERO(creditoDigital.getTipoCreditoCompra(), 2);
        }
        return value;
    }

    public int formataTimeout(int valor) {
        int timeout = valor;
        timeout = valor + valor * 15 / 100;
        return timeout;
    }

    public String formataConfirmacaoPositiva(DadosConfirmacaoPositiva dadosConfirmacaoPositiva) {
        if (dadosConfirmacaoPositiva != null) {
            List<ConfirmacaoPositiva> listConfirmacaoPositiva = dadosConfirmacaoPositiva.getListConfirmacaoPositiva();
            StringBuffer bufferConfirmacaoPositiva = new StringBuffer();
            DecimalFormat format2Zeros = new DecimalFormat("00");
            if (dadosConfirmacaoPositiva.getVersao() == 1) {
                bufferConfirmacaoPositiva.append(format2Zeros.format(listConfirmacaoPositiva.size()));
                for (ConfirmacaoPositiva confirmacaoPositiva : listConfirmacaoPositiva) {
                    bufferConfirmacaoPositiva.append(confirmacaoPositiva.getIdPrompt());
                }
            } else {
                bufferConfirmacaoPositiva.append(format2Zeros.format(listConfirmacaoPositiva.size()));
                for (ConfirmacaoPositiva confirmacaoPositiva : listConfirmacaoPositiva) {
                    bufferConfirmacaoPositiva.append(confirmacaoPositiva.getIdPrompt()).append(format2Zeros.format(confirmacaoPositiva.getTamanhoMaximo()));
                }
            }
            bufferConfirmacaoPositiva.append(dadosConfirmacaoPositiva.getPinCriptogravado());
            return bufferConfirmacaoPositiva.toString();
        }
        return "";
    }

    public String formataProdutoValeGas(ProdutoValeGas produtoValeGas) {
        int valor = 0;
        if (produtoValeGas != null) {
            valor = produtoValeGas.getCodigo();
        }
        return StringUtil.completaString("" + valor, 7, '0', 3);
    }

    public String formataProdutosConvenioFarmacia(Vector<String> produtos) {
        if (produtos == null || produtos.size() == 0) {
            return "";
        }
        StringBuffer strProdutos = new StringBuffer();
        for (int i = 0; i < produtos.size(); ++i) {
            String produto = produtos.get(i);
            strProdutos.append(StringUtil.completaString("" + produto.length(), 4, '0', true)).append(produto);
        }
        return strProdutos.toString();
    }

    public String formataDadosPagamento(Vector<String> pagamentos) {
        if (pagamentos == null || pagamentos.size() == 0) {
            return "";
        }
        StringBuffer strProdutos = new StringBuffer();
        for (int i = 0; i < pagamentos.size(); ++i) {
            String forma = pagamentos.get(i);
            strProdutos.append(StringUtil.completaString("" + forma.length(), 4, '0', true)).append(forma);
        }
        return strProdutos.toString();
    }

    public String formataInformacoesAdicionais(List<InformacoesAdicionais> listInformacoesAdicionaisLocal) {
        StringBuffer buffer = new StringBuffer();
        if (listInformacoesAdicionaisLocal != null) {
            for (InformacoesAdicionais informacoesAdicionais : listInformacoesAdicionaisLocal) {
                String tipo = informacoesAdicionais.getTipoCaptura().equals("") ? (informacoesAdicionais.isEnvioAutorizadora() ? "1" : "0") : informacoesAdicionais.getTipoCaptura();
                String bufferParcial = informacoesAdicionais.getCodigoGrupo() + informacoesAdicionais.getCodigoInformacao() + informacoesAdicionais.getCodigoTabela() + FORMAT_2_ZEROS.format(informacoesAdicionais.getTamanhoMinimo()) + FORMAT_2_ZEROS.format(informacoesAdicionais.getTamanhoMaximo()) + tipo + (informacoesAdicionais.isDuplaDigitacao() ? "1" : "0") + FORMAT_2_ZEROS.format(informacoesAdicionais.getTamanhoInformacaoAdicional()) + informacoesAdicionais.getMensagemInformacaoAdicional();
                buffer.append(FORMAT_4_ZEROS.format(bufferParcial.length())).append(bufferParcial);
            }
        }
        return buffer.toString();
    }

    private String getStringNullComLimite(String value, int tamanhoLimite) {
        if (value != null) {
            if (tamanhoLimite > 0 && value.length() > tamanhoLimite) {
                return value.substring(0, 20);
            }
            return value;
        }
        return "";
    }

    private String getStringNull(String value) {
        return this.getStringNullComLimite(value, 0);
    }
}

