/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.config;

import com.csi.ctfclient.autenticacao.AutenticacaoUtil;
import com.csi.ctfclient.autenticacao.DadosAutenticacao;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ConfCTFClientDefaultHandler;
import com.csi.ctfclient.config.ConfClienteServico;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.tools.communication.Host;
import com.csi.ctfclient.tools.communication.ServicoCTF;
import java.util.LinkedHashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfCTFClientAutenticacaoHandler
extends ConfCTFClientDefaultHandler {
    private static Logger logger = LogManager.getLogger(ControladorConfCTFClient.class);
    private ConfCTFClient confCTFClient;

    @Override
    public void reader() throws ExcecaoApiAc {
        super.reader();
        ConfCTFClient confCTFClient = super.getConfCTFClient();
        if (confCTFClient.isSuporteHttps()) {
            AutenticacaoUtil autenticacaoUtil = AutenticacaoUtil.getInstance();
            try {
                if (autenticacaoUtil.isDadosAutenticacao()) {
                    logger.info("configuracao de autenticacao identificada. utilizar dados da autenticacao.");
                    DadosAutenticacao dadosAutenticacao = autenticacaoUtil.getDadosAutenticacao();
                    if (!AutenticacaoUtil.getIdentificao().equalsIgnoreCase(dadosAutenticacao.getIdentificacao())) {
                        logger.error("identificacao do terminal nao confere com os dados da autenticacao.");
                        autenticacaoUtil.clean();
                        logger.warn("dados da autenticacao invalidados. necessario realizar nova autenticacao.");
                        ConfCTFClient newConfCTFClient = new ConfCTFClient();
                        newConfCTFClient.setEstabelecimento(null);
                        newConfCTFClient.setLoja(null);
                        newConfCTFClient.setTerminal(null);
                        LinkedHashSet ips = new LinkedHashSet();
                        newConfCTFClient.setIps(ips);
                        ConfClienteServico confClienteServico = confCTFClient.getConfClienteServico();
                        if (confClienteServico != null) {
                            confClienteServico.setHost(null);
                            newConfCTFClient.setConfClienteServico(confClienteServico);
                        }
                        if (ControladorConfCTFClient.getInstance() != null) {
                            ControladorConfCTFClient.getInstance().resetDadosAutenticacao();
                        }
                        logger.warn("configuracao basica invalidada.");
                        throw new Exception("dados de auteneticacao invalidos!");
                    }
                    String terminal = dadosAutenticacao.getTerminal();
                    confCTFClient.setEstabelecimento(terminal.substring(0, 5));
                    confCTFClient.setLoja(terminal.substring(5, 9));
                    confCTFClient.setTerminal(terminal.substring(9));
                    LinkedHashSet<ServicoCTF> ips = new LinkedHashSet<ServicoCTF>();
                    for (String ctfHost : dadosAutenticacao.getCtfHosts()) {
                        Host host = new Host(ctfHost);
                        try {
                            ServicoCTF servico = new ServicoCTF(host, "443", "HTTPS");
                            ips.add(servico);
                        }
                        catch (ExcecaoParametroInvalido e) {
                            logger.error("valor de parametro invalido ==> ips");
                        }
                    }
                    confCTFClient.setIps(ips);
                    ConfClienteServico confClienteServico = confCTFClient.getConfClienteServico();
                    if (confClienteServico != null) {
                        if (confClienteServico.getHost() != null) {
                            logger.warn("host local do cliente servicos ignorado. Autenticacao de terminal habilitada.");
                        }
                        confClienteServico.setHost(dadosAutenticacao.getClientServicesHost());
                    }
                }
            }
            catch (ExcecaoApiAc e) {
                throw e;
            }
            catch (Exception e) {
                logger.error("erro na validacao dos dados de autenticacao");
            }
        }
        this.confCTFClient = confCTFClient;
    }

    @Override
    public ConfCTFClient getConfCTFClient() {
        return this.confCTFClient;
    }
}

