/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.config;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;

public abstract class ConfCTFClientHandler {
    private ConfCTFClient confCTFClient;

    public abstract String getDiretorioTrabalho();

    public abstract void reader() throws ExcecaoApiAc;

    public abstract void save(ConfCTFClient var1) throws ExcecaoApiAc;

    public abstract void save(ConfCTFClient var1, boolean var2) throws ExcecaoApiAc;

    public abstract void resetDadosAutenticacao() throws ExcecaoApiAc;

    public ConfCTFClient getConfCTFClient() {
        return this.confCTFClient;
    }

    public void setConfCTFClient(ConfCTFClient confCTFClient) {
        this.confCTFClient = confCTFClient;
    }

    public boolean isEstabelecimentoValido() {
        if (this.confCTFClient != null) {
            return this.validaEstabelecimento(this.confCTFClient.getEstabelecimento());
        }
        return false;
    }

    protected boolean validaEstabelecimento(String value) {
        return value != null && value.length() == 5;
    }

    public boolean isLojaValida() {
        if (this.confCTFClient != null) {
            return this.validaLoja(this.confCTFClient.getLoja());
        }
        return false;
    }

    protected boolean validaLoja(String value) {
        return value != null && value.length() == 4;
    }

    public boolean isTerminalValido() {
        if (this.confCTFClient != null) {
            return this.confCTFClient.getTerminal() != null && this.confCTFClient.getTerminal().length() == 3;
        }
        return false;
    }

    public boolean isListaIPValida() {
        if (this.confCTFClient != null) {
            return this.confCTFClient.getIps() != null && this.confCTFClient.getIps().size() > 0 || this.confCTFClient.getComunicacaoCTF() != null && this.confCTFClient.getComunicacaoCTF().length > 0;
        }
        return false;
    }

    public boolean isMultiEc() {
        return this.confCTFClient.isMultiEC();
    }

    protected boolean validaNumeroSites(Integer value) {
        return value != null && value > 0;
    }

    protected boolean validaQuantidadeVias(Integer value) {
        return value != null && value > 0;
    }

    protected boolean validaVersaoAC(String value) {
        return value != null && value.length() <= 10;
    }

    protected boolean validaPort(String value) {
        try {
            int intValue = Integer.parseInt(value);
            return intValue >= 1 && intValue <= 65535;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

