/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.config;

import br.com.auttar.AuttarLogger;
import br.com.auttar.ctfclient.Version;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ConfCTFClientHandler;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.config.ConfPeriferico;
import java.text.SimpleDateFormat;

public class ControladorConfCTFClient {
    public static final String FABRICANTE_TEF = "AUTTAR PROCESSAMENTO DE DADOS";
    public static final String CTFCLIENT_HOME = "CTFCLIENT_HOME";
    public static final String DATA_VERSAO = new SimpleDateFormat("dd/MM/yyyy").format(Version.getBuildDate());
    public static final String VERSAO_CLIENT = String.format("C%02d%02d%02d", Version.getMajor(), Version.getMinor(), Version.getPatch());
    public static final String VERSAO_CLIENT_DRAFT = String.format("D%02d", Version.getDraft());
    public static final String VERSAO_CLIENT_FULL = String.format("%s%s", VERSAO_CLIENT, VERSAO_CLIENT_DRAFT);
    public static final String VERSAO_CIELO = "C0214";
    public static final String VERSAO_REDECARD = "C0138";
    public static final String VERSAO_ESPECIFICACAO_REDECARD = "L0602";
    public static final String INTEGRACAO_STANDALONE = "standalone";
    public static final String INTEGRACAO_DLL = "dll";
    public static final String INTEGRACAO_TEF_DISC = "tef_disc";
    public static final String INTEGRACAO_TEF_IP = "tef_ip";
    public static final String INTEGRACAO_WEB = "web";
    public static final String INTEGRACAO_ANDROID = "android";
    public static final String INTEGRACAO_WEB_SOCKET = "websocket";
    public static final String INTEGRACAO_POSTEF = "postef";
    public static final String PIN_EMV = "16";
    public static final long TIME_OUT_DELAY = 1500L;
    public static final long TIME_OUT_DELAY_PLATAFORMA_PROMOCIONAL = 5000L;
    private static final String DEFAULT_HANDLER = "com.csi.ctfclient.config.ConfCTFClientAutenticacaoHandler";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    private static String HANDLER = null;
    private static ControladorConfCTFClient readerConfClientCTF = null;
    private static ConfCTFClientHandler configCTFClintHandler = null;

    private ControladorConfCTFClient() {
    }

    public static synchronized ControladorConfCTFClient getInstance() throws ExcecaoNaoLocal {
        if (readerConfClientCTF == null) {
            logger.info("Inicializando controlador de configuracoes...");
            if (HANDLER == null) {
                HANDLER = DEFAULT_HANDLER;
            }
            try {
                configCTFClintHandler = (ConfCTFClientHandler)Class.forName(HANDLER).newInstance();
            }
            catch (Exception e) {
                logger.error("Erro no carregamento da classe de configuracao: " + e.getMessage());
                return null;
            }
            readerConfClientCTF = new ControladorConfCTFClient();
            readerConfClientCTF.reader();
        }
        return readerConfClientCTF;
    }

    public static String getDiretorioTrabalho() {
        return configCTFClintHandler.getDiretorioTrabalho();
    }

    public ConfCTFClient getConfig() {
        return configCTFClintHandler.getConfCTFClient();
    }

    public ConfCTFClientHandler getHandler() {
        return configCTFClintHandler;
    }

    public static void setHandler(String nome) {
        HANDLER = nome;
    }

    public void resetDadosAutenticacao() throws ExcecaoApiAc {
        configCTFClintHandler.resetDadosAutenticacao();
    }

    private void reader() throws ExcecaoNaoLocal {
        logger.info("inicializando carga dos parametros de configuracao...");
        try {
            logger.info("inicializando leitura do arquivo de configuracoes");
            logger.info("CTFCLIENT_HOME = " + ControladorConfCTFClient.getDiretorioTrabalho());
            logger.info("SO = " + System.getProperty("os.name").toLowerCase());
            configCTFClintHandler.reader();
            logger.info("Finalizando atualizacao do arquivo de configuracoes...");
        }
        catch (Exception e) {
            logger.fatal(e.getMessage());
            throw new ExcecaoNaoLocal(e, "CCCC01", "Erro ao ler arquivo de configuracoes");
        }
    }

    public void save(ConfCTFClient confCTFClient) throws ExcecaoNaoLocal {
        this.save(confCTFClient, !this.getConfig().isSuporteHttps());
    }

    public void save(ConfCTFClient confCTFClient, boolean ignoreSuporteHttps) throws ExcecaoNaoLocal {
        logger.info("Inicializando atualizacao do arquivo de configuracoes...");
        try {
            configCTFClintHandler.save(confCTFClient, ignoreSuporteHttps);
        }
        catch (Exception e) {
            logger.fatal(e.getMessage());
            throw new ExcecaoNaoLocal(e, "CCCC02", "Erro ao salvar arquivo de configuracoes");
        }
    }

    public boolean isEstabelecimentoValido() {
        return configCTFClintHandler.isEstabelecimentoValido();
    }

    public boolean isLojaValida() {
        return configCTFClintHandler.isLojaValida();
    }

    public boolean isTerminalValido() {
        return configCTFClintHandler.isTerminalValido();
    }

    public boolean isListaIPValida() {
        return configCTFClintHandler.isListaIPValida();
    }

    public boolean isMultiEc() {
        return configCTFClintHandler.isMultiEc();
    }

    public void configuraPinpad(String portaPinpad, String messagePrompt) throws ExcecaoNaoLocal {
        ConfCTFClient confCTFClient = this.getConfig();
        ConfPeriferico leitorCartao = new ConfPeriferico("PARAMS_LEITOR_CARTAO");
        leitorCartao.setNomeClasse("com.csi.ctfclient.tools.devices.LeitorCartaoHandler");
        String[] parametrosLeitorCartao = new String[]{portaPinpad, "PASSE O CARTAO", messagePrompt};
        leitorCartao.setParametros(parametrosLeitorCartao);
        confCTFClient.setLeitorCartao(leitorCartao);
        ConfPeriferico leitorPinpad = new ConfPeriferico("PARAMS_PINPAD");
        leitorPinpad.setNomeClasse("com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad");
        String[] parametrosPinpad = new String[]{portaPinpad, messagePrompt, "DIGITE A SENHA", "PROCESSANDO..."};
        leitorPinpad.setParametros(parametrosPinpad);
        confCTFClient.setPin(leitorPinpad);
        this.save(confCTFClient);
    }
}

