/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.excecoes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;

public class ExcecaoApiAc
extends Exception {
    private static final long serialVersionUID = 1L;
    private String complemento = "";
    private String detalhe = "";
    private String[] stack;
    private Throwable excecao;

    public ExcecaoApiAc() {
        this("EX01");
    }

    public ExcecaoApiAc(String codigo) {
        super(String.format("%s - []", codigo));
    }

    public ExcecaoApiAc(String codigo, String compl, String det) {
        super(String.format("%s - %s [%s]", codigo, compl, det));
        this.complemento = compl;
        this.detalhe = det;
    }

    public ExcecaoApiAc(Throwable t, String errorCode, String complement) {
        super(String.format("%s - %s [%s, %s]", errorCode, complement, t.getClass().getName(), t.getMessage()));
        this.complemento = complement;
        this.excecao = t;
    }

    public ExcecaoApiAc(Throwable t, String errorCode, String complement, String details) {
        super(String.format("%s - %s [%s, %s, %s]", errorCode, complement, details, t.getClass().getName(), t.getMessage()));
        this.complemento = complement;
        this.excecao = t;
        this.detalhe = details;
    }

    public ExcecaoApiAc(String codigo, String compl, String det, Throwable excecao) {
        super(codigo);
        this.complemento = compl;
        this.detalhe = det;
        this.excecao = excecao;
    }

    public static final String[] getStackTraceComoString(Throwable e) {
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOut);
        e.printStackTrace(printWriter);
        printWriter.close();
        ByteArrayInputStream byteArrayInput = new ByteArrayInputStream(byteArrayOut.toByteArray());
        InputStreamReader inputReader = new InputStreamReader(byteArrayInput);
        LineNumberReader lineReader = new LineNumberReader(inputReader);
        ArrayList<String> linhas = new ArrayList<String>();
        try {
            String linha = lineReader.readLine();
            while (linha != null) {
                linhas.add(linha);
                linha = lineReader.readLine();
            }
        }
        catch (IOException linha) {
            // empty catch block
        }
        String[] retorno = new String[linhas.size()];
        retorno = linhas.toArray(retorno);
        return retorno;
    }

    public void appendComplemento(String complementoExtra) {
        this.complemento = this.complemento + complementoExtra;
    }

    public void appendDetalhe(String detalheExtra) {
        this.detalhe = this.detalhe + detalheExtra;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExcecaoApiAc) {
            ExcecaoApiAc temp = (ExcecaoApiAc)obj;
            return this.getCodigo().equals(temp.getCodigo());
        }
        return false;
    }

    public String getCodigo() {
        return this.getMessage();
    }

    public String getComplemento() {
        return this.complemento;
    }

    public String getDetalhe() {
        return this.detalhe;
    }

    public String[] getInformacoesDetalhe() {
        if (this.getStack() == null) {
            this.setStack(ExcecaoApiAc.getStackTraceComoString(this));
        }
        return this.getStack();
    }

    protected final String[] getStack() {
        return this.stack;
    }

    protected final void setStack(String[] newStack) {
        this.stack = newStack;
    }

    public Throwable getExcecao() {
        return this.excecao;
    }
}

