/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;

public class EtchedRoundBorder
extends AbstractBorder {
    private static final long serialVersionUID = 1L;
    private int angleX;
    private int angleY;

    public EtchedRoundBorder() {
        this(true, 20, 20);
    }

    public EtchedRoundBorder(boolean e, int angleX, int angleY) {
        this.angleX = angleX;
        this.angleY = angleY;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int w = width;
        int h = height;
        g.translate(x, y);
        g.setColor(new Color(130, 130, 130));
        g.fillRoundRect(1, 1, w - 2, h - 2, this.angleX, this.angleY);
        g.setColor(new Color(97, 97, 97));
        g.fillRoundRect(2, 2, w - 6, h - 6, this.angleX - 1, this.angleY - 1);
        g.setColor(new Color(52, 52, 52));
        g.fillRoundRect(3, 3, w - 6, h - 6, this.angleX - 2, this.angleY - 2);
        g.setColor(new Color(38, 38, 38));
        g.fillRoundRect(5, 5, w - 10, h - 10, this.angleX - 3, this.angleY - 3);
        if (this.isBorderOpaque()) {
            JComponent component = (JComponent)c;
            component.setOpaque(false);
            g.setColor(c.getBackground());
            g.fillRoundRect(6, 6, w - 12, h - 12, this.angleX - 4, this.angleY - 4);
        }
        g.translate(-x, -y);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(10, 10, 10, 10);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.bottom = 2;
        insets.right = 2;
        insets.top = 2;
        insets.left = 2;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

