/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.gui;

import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.gui.JPanelImage;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.generic.JPanelDisplay;
import java.awt.Color;
import java.awt.Container;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TelaPrincipal
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(Periferico.class);
    private JPanelDisplay display;
    private JPanelImage imagepanel;
    private String PATH_IMG_BACKGROUND = "imagens/background4.png";
    private RecuperaFocoListener recuperaFocoListener = null;

    public TelaPrincipal() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Container container = this.getContentPane();
        container.setLayout(null);
        container.add(this.getImagePanel());
        this.setSize(305, 410);
        this.setTitle("Auttar - CTF Client - " + ControladorConfCTFClient.VERSAO_CLIENT);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.setFocusable(true);
        Class[] mytypes = new Class[]{Boolean.TYPE};
        Method metodo = null;
        try {
            BigDecimal versao = new BigDecimal(System.getProperty("java.version").substring(0, 3));
            if (versao.compareTo(new BigDecimal("1.5")) > -1) {
                logger.info("M\u00e1quina virtual 1.5 ou superior detectada, solicitando foco...");
                metodo = this.getClass().getMethod("setAlwaysOnTop", mytypes);
                Object[] meusObjetos = new Object[]{Boolean.TRUE};
                metodo.invoke((Object)this, meusObjetos);
                this.recuperaFocoListener = new RecuperaFocoListener();
                this.addWindowListener(this.recuperaFocoListener);
            } else {
                logger.info("M\u00e1quina virtual 1.5 ou superior n\u00e3o detectada.");
            }
        }
        catch (Exception e) {
            logger.warn("Exception ao tentar invocar o AlwaysOnTop da m\u00e1quina virtual superior a 1.4. Error: " + e.getMessage());
        }
    }

    protected JPanelImage getImagePanel() {
        if (this.imagepanel == null) {
            this.imagepanel = new JPanelImage();
            ImageIcon icon = new ImageIcon(this.PATH_IMG_BACKGROUND);
            this.imagepanel.setIcon(icon);
            this.imagepanel.setLayout(null);
            this.imagepanel.setStretch(true);
            this.imagepanel.setBounds(0, 0, 300, 385);
        }
        return this.imagepanel;
    }

    public void setDisplay(JPanelDisplay display) {
        if (this.display != null) {
            this.getImagePanel().remove(this.display);
        }
        this.display = display;
        this.display.setLocation(30, 45);
        this.display.setSize(600, 420);
        this.display.setBackground(new Color(193, 193, 193));
        this.display.setFocusable(true);
        this.getImagePanel().add(this.display);
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        super.addMouseListener(listener);
        this.getImagePanel().addMouseListener(listener);
    }

    public void removeRecuperaFocoListener() {
        if (this.recuperaFocoListener != null) {
            this.removeWindowListener(this.recuperaFocoListener);
        }
    }

    class RecuperaFocoListener
    implements WindowListener {
        RecuperaFocoListener() {
        }

        private void windowSelect() {
            try {
                logger.debug("iniciando processo de recupera\u00e7\u00e3o de foco");
                Class<?> mouseInfoClass = Class.forName("java.awt.MouseInfo");
                Method pointInfoMethod = mouseInfoClass.getDeclaredMethod("getPointerInfo", new Class[0]);
                Object pointInfoObject = pointInfoMethod.invoke(null, new Object[0]);
                Method locationMethod = pointInfoObject.getClass().getDeclaredMethod("getLocation", new Class[0]);
                Point point = (Point)locationMethod.invoke(pointInfoObject, new Object[0]);
                int x = (int)point.getX();
                int y = (int)point.getY();
                Robot rb = new Robot();
                rb.mouseMove(TelaPrincipal.this.getX() + 100, TelaPrincipal.this.getY() + 50);
                rb.mousePress(16);
                rb.mouseRelease(16);
                rb.mouseMove(x, y);
                logger.debug("foco solicitado com sucesso");
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }

        @Override
        public void windowActivated(WindowEvent arg0) {
            this.windowSelect();
        }

        @Override
        public void windowClosed(WindowEvent arg0) {
        }

        @Override
        public void windowClosing(WindowEvent arg0) {
        }

        @Override
        public void windowDeactivated(WindowEvent arg0) {
        }

        @Override
        public void windowDeiconified(WindowEvent arg0) {
        }

        @Override
        public void windowIconified(WindowEvent arg0) {
        }

        @Override
        public void windowOpened(WindowEvent arg0) {
            this.windowSelect();
        }
    }
}

