/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao;

import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.integracao.Handler;
import com.csi.ctfclient.integracao.SocketGetData;
import com.csi.ctfclient.integracao.event.HandlerEvent;
import com.csi.ctfclient.servicos.CTFClient;
import com.csi.ctfclient.tools.communication.Host;
import com.csi.ctfclient.tools.communication.Servico;
import com.csi.ctfclient.tools.communication.access.Conector;
import com.csi.ctfclient.tools.communication.access.ExcecaoErroInstanciacaoServidor;
import com.csi.ctfclient.tools.communication.access.ExcecaoNenhumaThreadDisponivel;
import com.csi.ctfclient.tools.communication.access.GerenciadorDeAcesso;
import com.csi.ctfclient.tools.communication.access.Servidor;
import com.csi.ctfclient.tools.communication.access.TratadorDeConexoesDeEntrada;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SocketHandler
extends Handler
implements TratadorDeConexoesDeEntrada {
    private static final Logger logger = LogManager.getLogger(CTFClient.class);
    private static String tipoAcesso = "TCP/IP";
    private Servidor servidor = null;
    private Servico servicoLocal;
    private String port;
    private String strHost;
    private boolean enable;
    private SocketGetData socketGetData;
    private SocketHandler objHandler = this;

    public SocketHandler(Map<String, String> map) {
        this(map.get("host"), map.get("port"));
    }

    public SocketHandler(String strHost, String port) {
        this.strHost = strHost;
        this.port = port;
    }

    @Override
    public void start() throws ExcecaoParametroInvalido, ExcecaoErroInstanciacaoServidor {
        if (this.enable) {
            return;
        }
        try {
            this.servicoLocal = new Servico(new Host(this.strHost), this.port);
        }
        catch (ExcecaoParametroInvalido e) {
            logger.error("Erro criando servi\u00e7o por erros nos par\u00e2metros");
            return;
        }
        this.servidor = GerenciadorDeAcesso.getInstanciaServidor(tipoAcesso, this.servicoLocal, this, 60);
        logger.info("Servidor CTFClient aberto.");
        this.enable = true;
    }

    @Override
    public void stop() {
        this.servidor.finalizarServidor();
        this.enable = false;
    }

    @Override
    public SocketGetData getHandlerConexaoEntrada(Conector conexao) throws ExcecaoNenhumaThreadDisponivel {
        try {
            SocketGetData socketGetData = SocketGetData.getInstance(this.objHandler, conexao);
            logger.info("Conex\u00e3o aceita");
            return socketGetData;
        }
        catch (IllegalStateException e) {
            logger.error("Conex\u00e3o recusada, j\u00e1 existe um cliente conectado");
            throw new ExcecaoNenhumaThreadDisponivel(e.getMessage());
        }
    }

    public SocketGetData getSocketGetData() {
        return this.socketGetData;
    }

    public void fireReadInputStream(String dados, OutputStream outputStream) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(dados.getBytes());
        HandlerEvent event = new HandlerEvent(this, inputStream, outputStream);
        this.fireReadStream(event);
    }

    public void fireReadInputStream(InputStream inputStream, OutputStream outputStream) {
        HandlerEvent event = new HandlerEvent(this, inputStream, outputStream);
        this.fireReadStream(event);
    }
}

