/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao;

import com.csi.ctfclient.integracao.ConfiguracaoIntegrador;
import com.csi.ctfclient.integracao.Handler;
import com.csi.ctfclient.integracao.HandlerManager;
import com.csi.ctfclient.servicos.CTFClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StartupCTFClient {
    private static final Logger logger = LogManager.getLogger(CTFClient.class);
    private Handler handler;

    public void start() throws Exception {
        logger.info("Abrindo servidor CTFClient...");
        logger.info("inicializando instancia do CTFClient...");
        CTFClient.getInstancia();
        logger.info("instancia do CTFClient inicializada.");
        ConfiguracaoIntegrador configuracao = ConfiguracaoIntegrador.newInstanceBuild();
        this.handler = configuracao.getHandlerStream();
        this.handler.addHandlerListener(new HandlerManager(configuracao));
        this.handler.start();
    }

    public void stop() {
        if (this.handler != null) {
            this.handler.stop();
            logger.info("CTFClient finalizado.");
            this.handler = null;
        }
    }

    public boolean isAtivo() {
        return this.handler != null;
    }
}

