/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao;

import com.csi.ctfclient.integracao.SyntaxError;
import com.csi.ctfclient.integracao.TimeoutException;
import com.csi.ctfclient.integracao.constantes.ConstantesIntegracaoCSI;

public class TrataErroIntegracao
implements ConstantesIntegracaoCSI {
    public static final String ERRO_ENT_ABERTURA_ARQUIVO = "5001";
    public static final String ERRO_ENT_LEITURA_PRIMEIRA_LINHA = "5002";
    public static final String ERRO_ENT_TAMANHO_INV_PRIMEIRA_LINHA = "5004";
    public static final String ERRO_ENT_LEITURA_SEGUNDA_LINHA = "5005";
    public static final String ERRO_ENT_TAMANHO_INV_SEGUNDA_LINHA = "5007";
    public static final String ERRO_ENT_LEITURA_TERCEIRA_LINHA = "5008";
    public static final String ERRO_ENT_TAMANHO_INV_TERCEIRA_LINHA = "5010";
    public static final String ERRO_CONF_CAMPO_PORTACLIENT_NAO_ENCONTRADO = "5103";
    public static final String ERRO_CONF_CONECTANDO_CTFCLIENT_JAVA = "5104";
    public static final String ERRO_TIMEOUT_COMUNICACAO = "5200";
    public static final String ERRO_DESCONHECIDO = "5220";
    private String codigoErro;
    private String[] mensagens;

    public TrataErroIntegracao(Exception e) {
        if (e instanceof SyntaxError) {
            SyntaxError syntaxError = (SyntaxError)e;
            if (syntaxError.getMotivo() == 4 || syntaxError.getMotivo() == 3 || syntaxError.getMotivo() == 1) {
                switch (syntaxError.getLinha()) {
                    case 1: {
                        if (syntaxError.getMotivo() == 4) {
                            this.codigoErro = ERRO_ENT_TAMANHO_INV_PRIMEIRA_LINHA;
                            break;
                        }
                        if (syntaxError.getMotivo() != 1) break;
                        this.codigoErro = ERRO_ENT_LEITURA_PRIMEIRA_LINHA;
                        break;
                    }
                    case 2: {
                        if (syntaxError.getMotivo() == 4) {
                            this.codigoErro = ERRO_ENT_TAMANHO_INV_SEGUNDA_LINHA;
                            break;
                        }
                        if (syntaxError.getMotivo() != 1) break;
                        this.codigoErro = ERRO_ENT_LEITURA_SEGUNDA_LINHA;
                        break;
                    }
                    case 3: {
                        if (syntaxError.getMotivo() == 4) {
                            this.codigoErro = ERRO_ENT_TAMANHO_INV_TERCEIRA_LINHA;
                            break;
                        }
                        if (syntaxError.getMotivo() == 3) {
                            this.codigoErro = ERRO_ENT_LEITURA_TERCEIRA_LINHA;
                            break;
                        }
                        if (syntaxError.getMotivo() != 1) break;
                        this.codigoErro = ERRO_ENT_LEITURA_TERCEIRA_LINHA;
                        break;
                    }
                }
            }
            this.mensagens = new String[]{syntaxError.getMotivoErro()};
        } else {
            this.codigoErro = e instanceof TimeoutException ? ERRO_TIMEOUT_COMUNICACAO : ERRO_DESCONHECIDO;
        }
    }

    public String getCodigoErro() {
        return this.codigoErro;
    }

    public String[] getMensagens() {
        return this.mensagens;
    }
}

