/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao.parser;

import com.csi.ctfclient.integracao.SyntaxError;
import com.csi.ctfclient.servicos.CTFClient;
import com.csi.ctfclient.servicos.EntradaCTFClient;
import com.csi.ctfclient.servicos.IdentTerminal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CSILine1 {
    private static final Logger logger = LogManager.getLogger(CTFClient.class);
    private final EntradaCTFClient entrada;
    private final IdentTerminal identTerminal;

    public CSILine1(EntradaCTFClient entrada, IdentTerminal identTerminal) {
        this.entrada = entrada;
        this.identTerminal = identTerminal;
    }

    public void parse(String linha) throws SyntaxError {
        if (linha.length() != 35) {
            throw new SyntaxError(1, 4);
        }
        try {
            this.entrada.setOperacao(this.readOperacao(linha));
            this.entrada.setDataAbertura(this.readDataAbertura(linha));
            this.identTerminal.setEstabelecimento(this.readEstabelecimento(linha));
            this.identTerminal.setLoja(this.readLoja(linha));
            this.identTerminal.setTerminal(this.readTerminal(linha));
        }
        catch (NumberFormatException e) {
            logger.error("Erro no conte\u00fado da primeira linha");
            throw new SyntaxError(1, 3);
        }
    }

    private int readOperacao(String linha) {
        return Integer.parseInt(linha.substring(0, 3));
    }

    private Date readDataAbertura(String linha) {
        Date date;
        try {
            date = new SimpleDateFormat("yyyyMMdd").parse(linha.substring(20, 28));
        }
        catch (ParseException e) {
            date = null;
        }
        return date;
    }

    private String readEstabelecimento(String linha) {
        return linha.substring(3, 8);
    }

    private String readLoja(String linha) {
        return linha.substring(8, 12);
    }

    private String readTerminal(String linha) {
        return linha.substring(12, 15);
    }
}

