/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao.parser;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.integracao.SyntaxError;
import com.csi.ctfclient.integracao.domain.CampoLinha2Enum;
import com.csi.ctfclient.integracao.parser.Bit62Parser;
import com.csi.ctfclient.integracao.parser.ConfigParser;
import com.csi.ctfclient.integracao.parser.SplitPagamentoParser;
import com.csi.ctfclient.servicos.CTFClient;
import com.csi.ctfclient.servicos.EntradaCTFClient;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.ControladorTranslator;
import com.csi.ctfclient.tools.util.NumberUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CSILine2e3 {
    private static final Logger logger = LogManager.getLogger(CTFClient.class);
    private final EntradaCTFClient entrada;
    private final IdentTerminal identTerminal;
    private final ConfCTFClient config;
    private int posLinha3 = 0;
    private int posBitLinha2 = 0;

    public CSILine2e3(EntradaCTFClient entrada, IdentTerminal identTerminal, ConfCTFClient config) {
        this.entrada = entrada;
        this.identTerminal = identTerminal;
        this.config = config;
    }

    public void parse(String linha2, String linha3) throws Exception {
        if (linha2.length() != 128) {
            throw new SyntaxError(2, 4);
        }
        if (!NumberUtil.isNumeric(linha2)) {
            throw new SyntaxError(2, 3);
        }
        try {
            this.fillCodigoTransacao(linha2, linha3);
            this.fillNumeroCupom(linha2, linha3);
            this.fillCampoDepreciado(linha2, linha3, CampoLinha2Enum.COD_MOEDA_DEPRECIADO);
            this.fillValorTransacao(linha2, linha3);
            this.fillNumeroCartao(linha2, linha3);
            this.fillInfo(linha2, linha3);
            this.fillTimestamp(linha2, linha3);
            this.fillCampoDepreciado(linha2, linha3, CampoLinha2Enum.SENHA_DEPRECIADO);
            this.fillNumeroParcelas(linha2, linha3);
            this.fillDataVencimentoCartao(linha2, linha3);
            this.fillDataReferencia(linha2, linha3);
            this.fillValorTaxaServico(linha2, linha3);
            this.fillValorEntrada(linha2, linha3);
            this.fillNsuCTF(linha2, linha3);
            this.fillCampoDepreciado(linha2, linha3, CampoLinha2Enum.DESCRICAO_PARCELAS_DEPRECIADO);
            this.fillCheque(linha2, linha3);
            this.fillBanco(linha2, linha3);
            this.fillAgencia(linha2, linha3);
            this.fillTipoDocumento(linha2, linha3);
            this.fillDocumento(linha2, linha3);
            this.fillContaCorrente(linha2, linha3);
            this.fillBit62(linha2, linha3);
            this.fillCodigoAutorizacao(linha2, linha3);
            this.fillMedicamento(linha2, linha3);
            this.fillCodigoSeguraca(linha2, linha3);
            this.fillValorSaque(linha2, linha3);
            this.fillValorTaxaEmbarque(linha2, linha3);
            this.fillTipoGarantia(linha2, linha3);
            this.fillCampoDepreciado(linha2, linha3, CampoLinha2Enum.MULTI_TRANSACAO_DEPRECIADO);
            this.fillCodigoAutorizadora(linha2, linha3);
            this.fillCmc7(linha2, linha3);
            this.fillPracaCompensacao(linha2, linha3);
            this.fillNumeroTransacao(linha2, linha3);
            this.filltValorDesconto(linha2, linha3);
            this.fillValorAcrescimo(linha2, linha3);
            this.fillVersaoAc(linha2, linha3);
            this.fillNomeAc(linha2, linha3);
            this.fillEndereco(linha2, linha3);
            this.fillNumeroEndereco(linha2, linha3);
            this.fillComplementoEndereco(linha2, linha3);
            this.fillBlocoEndereco(linha2, linha3);
            this.fillBairro(linha2, linha3);
            this.fillCep(linha2, linha3);
            this.fillCiclosPular(linha2, linha3);
            this.fillNumeroPlanoDepreciado(linha2, linha3);
            this.fillNumeroItem(linha2, linha3);
            this.fillCodigoBarras(linha2, linha3);
            this.fillModoEntradaCodigoBarras(linha2, linha3);
            if (this.entrada.getOperacao() == OperationEnum.OP_CONFIG.getKey().intValue()) {
                new ConfigParser(this.identTerminal, this.config, this).parse(linha2, linha3);
            }
            this.fillFormaPagamentoContas(linha2, linha3);
            this.fillModoEntradaCartao(linha2, linha3);
            this.fillCapturaCmc7(linha2, linha3);
            this.fillDataEmissao(linha2, linha3);
            this.fillDDDTelefone(linha2, linha3);
            this.fillCampoDepreciado(linha2, linha3, CampoLinha2Enum.EVENTO_PROMOCIONAL_DEPRECIADO);
            this.fillCampoDepreciado(linha2, linha3, CampoLinha2Enum.CAPTURA_VENCIMENTO_DEPRECIADO);
            this.fillMultitransacaoWeb(linha2, linha3);
            this.fillCodigoMultitransacao(linha2, linha3);
            this.fillCodigoTabela(linha2, linha3);
            this.fillPermiteAprovacaoValorParcial(linha2, linha3);
            this.fillCreditoCelularHabilitado(linha2, linha3);
            this.fillMatriculaOperador(linha2, linha3);
            this.fillCodigoOrigemTransacao(linha2, linha3);
            this.fillRg(linha2, linha3);
            this.fillTelefoneFixo(linha2, linha3);
            this.fillTelefoneMovel(linha2, linha3);
            this.fillCodigoVoucher(linha2, linha3);
            this.fillPedido(linha2, linha3);
            this.fillTipoAutorizadoraAlfa(linha2, linha3);
            this.fillAcSuportaPlataformaPromocional(linha2, linha3);
            this.fillTipoCapturaPreAutorizacao(linha2, linha3);
            this.fillTipoProduto(linha2, linha3);
            this.fillCodigoTerminalOriginal(linha2, linha3);
            this.fillMad(linha2, linha3);
            this.fillIpBombasFusion(linha2, linha3);
            this.fillConsulta(linha2, linha3);
            this.fillIdentConsulta(linha2, linha3);
            this.fillTipoIdentificacaoPagamentoFatura(linha2, linha3);
            this.fillIdentificacaoPagamentoFatura(linha2, linha3);
            this.fillFormaIdentificacaoPagamentoFatura(linha2, linha3);
            this.fillTipoCapturaDadosPinpad(linha2, linha3);
            this.fillIdentificadorMultiEC(linha2, linha3);
            this.fillVersaoBibliotecaIntegracao(linha2, linha3);
            this.fillIdentificacaoSolucaoCerta(linha2, linha3);
            this.fillExecutaConsultaFinanciamentoAutorizadora(linha2, linha3);
            this.fillSoftDescriptor(linha2, linha3);
            this.fillMcc(linha2, linha3);
            this.fillWalletUtilizado(linha2, linha3);
            this.fillIdentificadorWallet(linha2, linha3);
            this.fillTipoRecargaCelular(linha2, linha3);
            this.fillCodigoCartaoPrepagoDigital(linha2, linha3);
            this.fillConfigSubComercio(linha2, linha3);
            this.fillMatriculaSupervisor(linha2, linha3);
            this.fillNumeroPlano2(linha2, linha3);
            this.fillDesabilitaDigitacao(linha2, linha3);
            this.fillToken(linha2, linha3);
            this.fillSplitPagamento(linha2, linha3);
            this.fillPix(linha2, linha3);
        }
        catch (NumberFormatException e) {
            logger.error("Erro na convers\u00e3o num\u00e9rica na terceira linha. erro no bit= " + (this.posBitLinha2 + 1));
            throw new SyntaxError(3, 3);
        }
        catch (StringIndexOutOfBoundsException e) {
            logger.error("A terceira linha n\u00e3o possui o tamanho esperado. erro no bit= " + (this.posBitLinha2 + 1) + ", tamanho= " + CampoLinha2Enum.findByPosicao(this.posBitLinha2).getTamanho());
            throw new SyntaxError(3, 4);
        }
    }

    public void fillCampoDepreciado(String linha2, String linha3, CampoLinha2Enum campo) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.COD_MOEDA_DEPRECIADO, linha2)) {
            this.captura(linha3, campo);
        }
    }

    protected void fillCodigoTransacao(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.CODIGO_TRANSACAO, linha2)) {
            this.entrada.setCodigoTransancao(this.capturaString(linha2, linha3, CampoLinha2Enum.CODIGO_TRANSACAO));
        }
    }

    protected void fillNumeroCupom(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.NUMERO_CUPOM, linha2)) {
            this.entrada.setNumeroCupom(this.capturaString(linha2, linha3, CampoLinha2Enum.NUMERO_CUPOM));
        }
    }

    protected void fillValorTransacao(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.VALOR_TRANSACAO, linha2)) {
            this.entrada.setValorTransacao(this.capturaBigDecimal(linha2, linha3, CampoLinha2Enum.VALOR_TRANSACAO));
        }
    }

    protected void fillNumeroCartao(String linha2, String linha3) throws SyntaxError {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.NUMERO_CARTAO, linha2)) {
            this.entrada.setNumeroCartao(this.captura(linha3, CampoLinha2Enum.NUMERO_CARTAO));
        }
    }

    protected void fillInfo(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.INFO, linha2)) {
            this.entrada.setInfo(this.capturaString(linha2, linha3, CampoLinha2Enum.INFO));
        }
    }

    protected void fillTimestamp(String linha2, String linha3) throws SyntaxError {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.TIMESTAMP, linha2)) {
            Date capturaDate = this.capturaDate(linha2, linha3, "ddMMyyyyHHmmss", CampoLinha2Enum.TIMESTAMP);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(capturaDate);
            this.entrada.setTimestamp(calendar.getTimeInMillis());
        }
    }

    protected void fillNumeroParcelas(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.NUMERO_PARCELAS, linha2)) {
            this.entrada.setNumeroParcelas(this.capturaInt(linha2, linha3, CampoLinha2Enum.NUMERO_PARCELAS));
        }
    }

    protected void fillDataVencimentoCartao(String linha2, String linha3) throws SyntaxError {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.DATA_VENCIMENTO_CARTAO, linha2)) {
            String dado = this.captura(linha3, CampoLinha2Enum.DATA_VENCIMENTO_CARTAO);
            this.entrada.setDataVencimentoCartao(dado.substring(2, 4) + dado.substring(0, 2));
        }
    }

    protected void fillDataReferencia(String linha2, String linha3) throws SyntaxError {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.DATA_REFERENCIA, linha2)) {
            this.entrada.setDataReferencia(this.capturaDate(linha2, linha3, "ddMMyyyy", CampoLinha2Enum.DATA_REFERENCIA));
        }
    }

    protected void fillValorTaxaServico(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.VALOR_TAXA_SERVICO, linha2)) {
            this.entrada.setValorTaxaServico(this.capturaBigDecimal(linha2, linha3, CampoLinha2Enum.VALOR_TAXA_SERVICO));
        }
    }

    protected void fillValorEntrada(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.VALOR_ENTRADA, linha2)) {
            this.entrada.setValorEntrada(this.capturaBigDecimal(linha2, linha3, CampoLinha2Enum.VALOR_ENTRADA));
        }
    }

    protected void fillNsuCTF(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.NSU_CTF, linha2)) {
            this.entrada.setNsuCTF(this.capturaInt(linha2, linha3, CampoLinha2Enum.NSU_CTF));
        }
    }

    protected void fillCheque(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.CHEQUE, linha2)) {
            this.entrada.setCheque(this.capturaLong(linha2, linha3, CampoLinha2Enum.CHEQUE));
        }
    }

    protected void fillBanco(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.BANCO, linha2)) {
            this.entrada.setBanco(this.capturaInt(linha2, linha3, CampoLinha2Enum.BANCO));
        }
    }

    protected void fillAgencia(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.AGENCIA, linha2)) {
            this.entrada.setAgencia(this.capturaInt(linha2, linha3, CampoLinha2Enum.AGENCIA));
        }
    }

    protected void fillTipoDocumento(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.TIPO_DOCUMENTO, linha2)) {
            this.entrada.setTipoDocumento(this.capturaInt(linha2, linha3, CampoLinha2Enum.TIPO_DOCUMENTO));
        }
    }

    protected void fillDocumento(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.DOCUMENTO, linha2)) {
            String dadoString = this.captura(linha3, CampoLinha2Enum.DOCUMENTO);
            if (this.entrada.getTipoDocumento() == 1) {
                this.entrada.setDocumento(dadoString.substring(dadoString.length() - 14));
            } else if (this.entrada.getTipoDocumento() == 2) {
                this.entrada.setDocumento(dadoString.substring(dadoString.length() - 11));
            } else {
                this.entrada.setDocumento(dadoString);
            }
        }
    }

    protected void fillContaCorrente(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.CONTA_CORRENTE, linha2)) {
            this.entrada.setContaCorrente(this.capturaLong(linha2, linha3, CampoLinha2Enum.CONTA_CORRENTE));
        }
    }

    protected void fillBit62(String linha2, String linha3) throws SyntaxError {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.BIT62, linha2)) {
            String dadoString = this.captura(linha3, CampoLinha2Enum.BIT62);
            new Bit62Parser(this.entrada).parse(dadoString);
        }
    }

    protected void fillCodigoAutorizacao(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.CODIGO_AUTORIZACAO, linha2)) {
            this.entrada.setCodigoAutorizacao(this.capturaString(linha2, linha3, CampoLinha2Enum.CODIGO_AUTORIZACAO));
        }
    }

    protected void fillMedicamento(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.MEDICAMENTO, linha2)) {
            this.entrada.setMedicamento(this.capturaString(linha2, linha3, CampoLinha2Enum.MEDICAMENTO));
        }
    }

    protected void fillCodigoSeguraca(String linha2, String linha3) throws SyntaxError {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.CODIGO_SEGURACA, linha2)) {
            this.entrada.setCodigoSeguraca(this.captura(linha3, CampoLinha2Enum.CODIGO_SEGURACA));
        }
    }

    protected void fillValorSaque(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.VALOR_SAQUE, linha2)) {
            this.entrada.setValorSaque(this.capturaBigDecimal(linha2, linha3, CampoLinha2Enum.VALOR_SAQUE));
        }
    }

    protected void fillValorTaxaEmbarque(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.VALOR_TAXA_EMBARQUE, linha2)) {
            this.entrada.setValorTaxaEmbarque(this.capturaBigDecimal(linha2, linha3, CampoLinha2Enum.VALOR_TAXA_EMBARQUE));
        }
    }

    protected void fillTipoGarantia(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.TIPO_GARANTIA, linha2)) {
            this.entrada.setTipoGarantia(this.capturaInt(linha2, linha3, CampoLinha2Enum.TIPO_GARANTIA));
        }
    }

    protected void fillCodigoAutorizadora(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.CODIGO_AUTORIZADORA, linha2)) {
            this.entrada.setCodigoAutorizadora(this.capturaString(linha2, linha3, CampoLinha2Enum.CODIGO_AUTORIZADORA));
        }
    }

    protected void fillCmc7(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.CMC7, linha2)) {
            this.entrada.setCmc7(this.capturaString(linha2, linha3, CampoLinha2Enum.CMC7));
        }
    }

    protected void fillPracaCompensacao(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.PRACA_COMPENSACAO, linha2)) {
            this.entrada.setPracaCompensacao(this.capturaInt(linha2, linha3, CampoLinha2Enum.PRACA_COMPENSACAO));
        }
    }

    protected void fillNumeroTransacao(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.NUMERO_TRANSACAO, linha2)) {
            this.entrada.setNumeroTransacao(this.capturaInt(linha2, linha3, CampoLinha2Enum.NUMERO_TRANSACAO));
        }
    }

    protected void filltValorDesconto(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.VALOR_DESCONTO, linha2)) {
            this.entrada.setValorDesconto(this.capturaBigDecimal(linha2, linha3, CampoLinha2Enum.VALOR_DESCONTO));
        }
    }

    protected void fillValorAcrescimo(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.VALOR_ACRESCIMO, linha2)) {
            this.entrada.setValorAcrescimo(this.capturaBigDecimal(linha2, linha3, CampoLinha2Enum.VALOR_ACRESCIMO));
        }
    }

    protected void fillVersaoAc(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.VERSAO_AC, linha2)) {
            String versaoAc = this.capturaString(linha2, linha3, CampoLinha2Enum.VERSAO_AC);
            this.entrada.setVersaoAc(versaoAc);
            this.config.setVersaoAC(versaoAc);
        }
    }

    protected void fillNomeAc(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.NOME_AC, linha2)) {
            this.entrada.setNomeAc(this.capturaString(linha2, linha3, CampoLinha2Enum.NOME_AC));
        }
    }

    protected void fillEndereco(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.ENDERECO, linha2)) {
            this.entrada.setEndereco(this.capturaString(linha2, linha3, CampoLinha2Enum.ENDERECO));
        }
    }

    protected void fillNumeroEndereco(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.NUMERO_ENDERECO, linha2)) {
            this.entrada.setNumero(String.valueOf(Integer.parseInt(this.captura(linha3, CampoLinha2Enum.NUMERO_ENDERECO))));
        }
    }

    protected void fillComplementoEndereco(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.COMPLEMENTO_ENDERECO, linha2)) {
            this.entrada.setComplemento(this.capturaString(linha2, linha3, CampoLinha2Enum.COMPLEMENTO_ENDERECO));
        }
    }

    protected void fillBlocoEndereco(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.BLOCO_ENDERECO, linha2)) {
            this.entrada.setBloco(this.capturaString(linha2, linha3, CampoLinha2Enum.BLOCO_ENDERECO));
        }
    }

    protected void fillBairro(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.BAIRRO_ENDERECO, linha2)) {
            this.entrada.setBairro(this.capturaString(linha2, linha3, CampoLinha2Enum.BAIRRO_ENDERECO));
        }
    }

    protected void fillCep(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.CEP_ENDERECO, linha2)) {
            this.entrada.setCep(this.capturaString(linha2, linha3, CampoLinha2Enum.CEP_ENDERECO));
        }
    }

    protected void fillCiclosPular(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.CICLOS_PULAR, linha2)) {
            this.entrada.setCiclosPular(this.capturaInt(linha2, linha3, CampoLinha2Enum.CICLOS_PULAR));
        }
    }

    protected void fillNumeroPlanoDepreciado(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.NUMERO_PLANO_DEPRECIADO, linha2)) {
            this.entrada.setNumeroPlano(String.valueOf(this.capturaInt(linha2, linha3, CampoLinha2Enum.NUMERO_PLANO_DEPRECIADO)));
        }
    }

    protected void fillNumeroItem(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.NUMERO_ITEM, linha2)) {
            this.entrada.setNumeroItem(String.valueOf(this.capturaLong(linha2, linha3, CampoLinha2Enum.NUMERO_ITEM)));
        }
    }

    protected void fillCodigoBarras(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.CODIGO_BARRAS, linha2)) {
            this.entrada.setCodigoBarras(this.capturaString(linha2, linha3, CampoLinha2Enum.CODIGO_BARRAS));
        }
    }

    protected void fillModoEntradaCodigoBarras(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.MODO_ENTRADA_CODIGO_BARRAS, linha2)) {
            this.entrada.setModoEntradaCodigoBarras(this.capturaInt(linha2, linha3, CampoLinha2Enum.MODO_ENTRADA_CODIGO_BARRAS));
        }
    }

    protected void fillFormaPagamentoContas(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.FORMA_PAGAMENTO_CONTAS, linha2)) {
            this.entrada.setFormaPagamentoContas(this.capturaInt(linha2, linha3, CampoLinha2Enum.FORMA_PAGAMENTO_CONTAS));
        }
    }

    protected void fillModoEntradaCartao(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.MODO_ENTRADA_CARTAO, linha2)) {
            this.entrada.setModoEntradaCartao(this.capturaInt(linha2, linha3, CampoLinha2Enum.MODO_ENTRADA_CARTAO));
        }
    }

    protected void fillCapturaCmc7(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.CAPTURA_CMC7, linha2)) {
            boolean result = this.capturaBoolean(linha2, linha3, CampoLinha2Enum.CAPTURA_CMC7);
            if (this.entrada.getOperacao() == OperationEnum.OP_CONFIG.getKey().intValue()) {
                this.config.setCapturaCmc7(result);
            }
        }
    }

    protected void fillDataEmissao(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.DATA_EMISSAO, linha2)) {
            this.entrada.setDataEmissao(this.capturaString(linha2, linha3, CampoLinha2Enum.DATA_EMISSAO));
        }
    }

    protected void fillDDDTelefone(String linha2, String linha3) throws SyntaxError {
        boolean ambosNaoSetados;
        boolean dddSetado = this.fillDDD(linha2, linha3);
        boolean telefoneSetado = this.fillTelefone(linha2, linha3);
        boolean ambosSetados = dddSetado && telefoneSetado;
        boolean bl = ambosNaoSetados = !dddSetado && !telefoneSetado;
        if (!ambosSetados && !ambosNaoSetados) {
            logger.warn("O DDD e o Telefone devem ser informados ou nenhum deles");
            throw new SyntaxError(3, 3, "O DDD E O TELEFONE DEVEM SER INFORMADOS OU NENHUM DELES");
        }
    }

    protected boolean fillDDD(String linha2, String linha3) throws SyntaxError {
        boolean dddSetado = false;
        if (this.isBitLinha2Ativo(CampoLinha2Enum.DDD, linha2)) {
            this.entrada.setDdd(this.captura(linha3, CampoLinha2Enum.DDD).trim());
            dddSetado = true;
        }
        return dddSetado;
    }

    protected boolean fillTelefone(String linha2, String linha3) throws SyntaxError {
        boolean telefoneSetado = false;
        if (this.isBitLinha2Ativo(CampoLinha2Enum.TELEFONE, linha2)) {
            this.entrada.setTelefone(this.captura(linha3, CampoLinha2Enum.TELEFONE).trim());
            telefoneSetado = true;
        }
        return telefoneSetado;
    }

    protected void fillMultitransacaoWeb(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.MULTITRANSACAO_WEB, linha2)) {
            this.entrada.setMultitransacaoWeb(this.capturaBoolean(linha2, linha3, CampoLinha2Enum.MULTITRANSACAO_WEB));
        }
    }

    protected void fillCodigoMultitransacao(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.CODIGO_MULTITRANSACAO, linha2)) {
            this.entrada.setCodigoMultitransacao(this.capturaString(linha2, linha3, CampoLinha2Enum.CODIGO_MULTITRANSACAO));
        }
    }

    protected void fillCodigoTabela(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.CODIGO_TABELA, linha2)) {
            this.entrada.setCodigoTabela(this.capturaInt(linha2, linha3, CampoLinha2Enum.CODIGO_TABELA));
        }
    }

    protected void fillPermiteAprovacaoValorParcial(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.PERMITE_APROVACAO_VALOR_PARCIAL, linha2)) {
            this.entrada.setPermiteAprovacaoValorParcial(this.capturaBoolean(linha2, linha3, CampoLinha2Enum.PERMITE_APROVACAO_VALOR_PARCIAL));
        }
    }

    protected void fillCreditoCelularHabilitado(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.CREDITO_CELULAR_HABILITADO, linha2)) {
            boolean result = this.capturaBoolean(linha2, linha3, CampoLinha2Enum.CREDITO_CELULAR_HABILITADO);
            if (this.entrada.getOperacao() == OperationEnum.OP_CONFIG.getKey().intValue()) {
                this.config.setCreditoCelularHabilitado(result);
            }
        }
    }

    protected void fillMatriculaOperador(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.MATRICULA_OPERADOR, linha2)) {
            this.entrada.setMatriculaOperador(this.capturaString(linha2, linha3, CampoLinha2Enum.MATRICULA_OPERADOR));
        }
    }

    protected void fillCodigoOrigemTransacao(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.CODIGO_ORIGEM_TRANSACAO, linha2)) {
            this.entrada.setCodigoOrigemTransacao(this.capturaInt(linha2, linha3, CampoLinha2Enum.CODIGO_ORIGEM_TRANSACAO));
        }
    }

    protected void fillRg(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.RG, linha2)) {
            this.entrada.setRg(this.capturaInt(linha2, linha3, CampoLinha2Enum.RG));
        }
    }

    protected void fillTelefoneFixo(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.TELEFONE_FIXO, linha2)) {
            this.entrada.setTelefoneFixo(this.capturaString(linha2, linha3, CampoLinha2Enum.TELEFONE_FIXO));
        }
    }

    protected void fillTelefoneMovel(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.TELEFONE_MOVEL, linha2)) {
            this.entrada.setTelefoneMovel(this.capturaString(linha2, linha3, CampoLinha2Enum.TELEFONE_MOVEL));
        }
    }

    protected void fillCodigoVoucher(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.CODIGO_VOUCHER, linha2)) {
            this.entrada.setCodigoVoucher(this.capturaString(linha2, linha3, CampoLinha2Enum.CODIGO_VOUCHER));
        }
    }

    protected void fillPedido(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.PEDIDO, linha2)) {
            this.entrada.setPedido(this.capturaString(linha2, linha3, CampoLinha2Enum.PEDIDO));
        }
    }

    protected void fillTipoAutorizadoraAlfa(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.TIPO_AUTORIZADORA_ALFA, linha2)) {
            this.entrada.setTipoAutorizadoraAlfa(this.capturaString(linha2, linha3, CampoLinha2Enum.TIPO_AUTORIZADORA_ALFA));
        }
    }

    protected void fillAcSuportaPlataformaPromocional(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.AC_SUPORTA_PLATAFORMA_PROMOCIONAL, linha2)) {
            this.config.setAcSuportaPlataformaPromocional(this.capturaBoolean(linha2, linha3, CampoLinha2Enum.AC_SUPORTA_PLATAFORMA_PROMOCIONAL));
        }
    }

    protected void fillTipoCapturaPreAutorizacao(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.TIPO_CAPTURA_PRE_AUTORIZACAO, linha2)) {
            this.entrada.setTipoCapturaPreAutorizacao(this.capturaInt(linha2, linha3, CampoLinha2Enum.TIPO_CAPTURA_PRE_AUTORIZACAO));
        }
    }

    protected void fillTipoProduto(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.TIPO_PRODUTO, linha2)) {
            this.entrada.setTipoProduto(this.capturaString(linha2, linha3, CampoLinha2Enum.TIPO_PRODUTO));
        }
    }

    protected void fillCodigoTerminalOriginal(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.CODIGO_TERMINAL_ORIGINAL, linha2)) {
            this.entrada.setCodigoTerminalOriginal(this.capturaString(linha2, linha3, CampoLinha2Enum.CODIGO_TERMINAL_ORIGINAL));
        }
    }

    protected void fillMad(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.MAD, linha2)) {
            this.entrada.setMad(this.capturaString(linha2, linha3, CampoLinha2Enum.MAD));
        }
    }

    protected void fillIpBombasFusion(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.IP_BOMBAS_FUSION, linha2)) {
            int offset = Integer.parseInt(linha3.substring(this.posLinha3, this.posLinha3 + 2));
            this.posLinha3 += 2;
            String ipFusion = linha3.substring(this.posLinha3, this.posLinha3 + offset);
            this.posLinha3 += offset;
            int portaFusion = Integer.parseInt(linha3.substring(this.posLinha3, this.posLinha3 + 5));
            this.posLinha3 += 5;
            this.config.setIpFusion(ipFusion);
            this.config.setPortaFusion(portaFusion);
        }
    }

    protected void fillConsulta(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.CONSULTA, linha2)) {
            this.entrada.setConsulta(this.capturaBoolean(linha2, linha3, CampoLinha2Enum.CONSULTA));
        }
    }

    protected void fillIdentConsulta(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.IDENT_CONSULTA, linha2)) {
            this.entrada.setIdentConsulta(this.capturaLong(linha2, linha3, CampoLinha2Enum.IDENT_CONSULTA));
        }
    }

    protected void fillTipoIdentificacaoPagamentoFatura(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.TIPO_IDENTIFICACAO_PAGAMENTO_FATURA, linha2)) {
            this.entrada.setTipoIdentificacaoPagamentoFatura(this.capturaInt(linha2, linha3, CampoLinha2Enum.TIPO_IDENTIFICACAO_PAGAMENTO_FATURA));
        }
    }

    protected void fillIdentificacaoPagamentoFatura(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.IDENTIFICACAO_PAGAMENTO_FATURA, linha2)) {
            this.entrada.setIdentificacaoPagamentoFatura(this.capturaString(linha2, linha3, CampoLinha2Enum.IDENTIFICACAO_PAGAMENTO_FATURA));
        }
    }

    protected void fillFormaIdentificacaoPagamentoFatura(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.FORMA_IDENTIFICACAO_PAGAMENTO_FATURA, linha2)) {
            this.entrada.setFormaIdentificacaoPagamentoFatura(this.capturaInt(linha2, linha3, CampoLinha2Enum.FORMA_IDENTIFICACAO_PAGAMENTO_FATURA));
        }
    }

    protected void fillTipoCapturaDadosPinpad(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.TIPO_CAPTURA_DADOS_PINPAD, linha2)) {
            this.entrada.setTipoCapturaDadosPinpad(this.capturaInt(linha2, linha3, CampoLinha2Enum.TIPO_CAPTURA_DADOS_PINPAD));
        }
    }

    protected void fillIdentificadorMultiEC(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.IDENTIFICADOR_MULTI_EC, linha2)) {
            this.entrada.setIdentificadorMultiEC(this.capturaString(linha2, linha3, CampoLinha2Enum.IDENTIFICADOR_MULTI_EC));
        }
    }

    protected void fillVersaoBibliotecaIntegracao(String linha2, String linha3) {
        ConfCTFClient confCTFClient = null;
        try {
            confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        }
        catch (ExcecaoApiAc e) {
            logger.error("Erro ao utlizar o arquivo de configura\u00e7\u00e3o para verificar a vers\u00e3o da biblioteca. " + e.getMessage());
        }
        if (confCTFClient != null && confCTFClient.isIntegracaoDll()) {
            if (this.isBitLinha2Ativo(CampoLinha2Enum.VERSAO_BIBLIOTECA_INTEGRACAO, linha2)) {
                int dadoInt = Integer.parseInt(this.captura(linha3, CampoLinha2Enum.VERSAO_BIBLIOTECA_INTEGRACAO));
                logger.info("Vers\u00e3o da biblioteca de integra\u00e7\u00e3o (" + StringUtil.completaString("" + dadoInt, 4, '0', 3) + ")");
                this.setVersaoBibliotecaIntegracao(dadoInt);
            } else {
                logger.warn("Vers\u00e3o da biblioteca de integra\u00e7\u00e3o n\u00e3o enviada, considerando (" + StringUtil.completaString("100", 4, '0', 3) + ")");
                this.setVersaoBibliotecaIntegracao(100);
            }
        }
    }

    protected void setVersaoBibliotecaIntegracao(int dadoInt) {
        ControladorTranslator.setVersaoBibliotecaIntegracao(dadoInt);
    }

    protected void fillIdentificacaoSolucaoCerta(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.IDENTIFICACAO_SOLUCAO_CERTA, linha2)) {
            String dadoLinha = this.captura(linha3, CampoLinha2Enum.IDENTIFICACAO_SOLUCAO_CERTA);
            try {
                Long.parseLong(dadoLinha);
            }
            catch (NumberFormatException e1) {
                logger.error("Bit 104: Identifica\u00e7\u00e3o Solu\u00e7\u00e3o Certa n\u00e3o num\u00e9rico");
                throw e1;
            }
            this.entrada.setIdentificacaoSolucaoCerta(dadoLinha);
        }
    }

    protected void fillExecutaConsultaFinanciamentoAutorizadora(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.EXECUTA_CONSULTA_FINANCIAMENTO_AUTORIZADORA, linha2)) {
            int dadoInt = 0;
            try {
                dadoInt = Integer.parseInt(this.captura(linha3, CampoLinha2Enum.EXECUTA_CONSULTA_FINANCIAMENTO_AUTORIZADORA));
            }
            catch (NumberFormatException e1) {
                logger.error("Bit 105: Executar Consulta Financiamento Autorizadora n\u00e3o num\u00e9rico");
                throw e1;
            }
            this.entrada.setExecutaConsultaFinanciamentoAutorizadora(dadoInt == 1);
        }
    }

    protected void fillSoftDescriptor(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.SOFT_DESCRIPTOR, linha2)) {
            this.entrada.setSoftDescriptor(this.capturaString(linha2, linha3, CampoLinha2Enum.SOFT_DESCRIPTOR));
        }
    }

    protected void fillMcc(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.MCC, linha2)) {
            this.entrada.setMcc(this.capturaString(linha2, linha3, CampoLinha2Enum.MCC));
        }
    }

    protected void fillWalletUtilizado(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.WALLET_UTILIZADO, linha2)) {
            try {
                this.entrada.setWalletUtilizado(Integer.parseInt(this.captura(linha3, CampoLinha2Enum.WALLET_UTILIZADO)));
            }
            catch (NumberFormatException e1) {
                logger.error("Bit 108: Wallet utilizado n\u00e3o num\u00e9rico");
                throw e1;
            }
        }
    }

    protected void fillIdentificadorWallet(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.IDENTIFICADOR_WALLET, linha2)) {
            this.entrada.setIdentificadorWallet(this.capturaString(linha2, linha3, CampoLinha2Enum.IDENTIFICADOR_WALLET));
        }
    }

    protected void fillTipoRecargaCelular(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.TIPO_RECARGA_CELULAR, linha2)) {
            this.entrada.setTipoRecargaCelular(this.capturaString(linha2, linha3, CampoLinha2Enum.TIPO_RECARGA_CELULAR));
        }
    }

    protected void fillCodigoCartaoPrepagoDigital(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.CODIGO_CARTAO_PREPAGO_DIGITAL, linha2)) {
            this.entrada.setCodigoCartaoPrepagoDigital(this.capturaString(linha2, linha3, CampoLinha2Enum.CODIGO_CARTAO_PREPAGO_DIGITAL));
        }
    }

    protected void fillConfigSubComercio(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_SUB_COMERCIO, linha2)) {
            this.entrada.setConfigSubComercio(this.capturaString(linha2, linha3, CampoLinha2Enum.CONFIG_SUB_COMERCIO));
        }
    }

    protected void fillMatriculaSupervisor(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.MATRICULA_SUPERVISOR, linha2)) {
            this.entrada.setMatriculaSupervisor(this.capturaString(linha2, linha3, CampoLinha2Enum.MATRICULA_SUPERVISOR));
        }
    }

    protected void fillNumeroPlano2(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.NUMERO_PLANO_2, linha2)) {
            this.entrada.setNumeroPlano(this.capturaString(linha2, linha3, CampoLinha2Enum.NUMERO_PLANO_2));
        }
    }

    protected void fillDesabilitaDigitacao(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.DESABILITA_DIGITACAO, linha2)) {
            this.entrada.setDesabilitaDigitacao(this.capturaBoolean(linha2, linha3, CampoLinha2Enum.DESABILITA_DIGITACAO));
        }
    }

    protected void fillToken(String linha2, String linha3) throws Exception {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.TOKEN, linha2)) {
            this.entrada.setToken(this.capturaString(linha2, linha3, CampoLinha2Enum.TOKEN));
        }
    }

    protected void fillSplitPagamento(String linha2, String linha3) throws Exception {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.SPLIT_PAGAMENTO, linha2)) {
            new SplitPagamentoParser(this.entrada).parse(this.capturaString(linha2, linha3, CampoLinha2Enum.SPLIT_PAGAMENTO));
        }
    }

    protected void fillPix(String linha2, String linha3) {
        if (this.isBitLinha2Ativo(CampoLinha2Enum.PIX, linha2)) {
            String pixLine = this.capturaString(linha2, linha3, CampoLinha2Enum.PIX);
            int startIndex = 4;
            int endIndex = 7;
            int transactionLineLength = Integer.parseInt(pixLine.substring(startIndex, endIndex));
            startIndex = endIndex;
            endIndex = startIndex + transactionLineLength;
            this.entrada.setPixTransactionId(pixLine.substring(startIndex, endIndex));
            startIndex = endIndex;
            endIndex = startIndex + 3;
            int pspLineLength = Integer.parseInt(pixLine.substring(startIndex, endIndex));
            startIndex = endIndex;
            endIndex = startIndex + pspLineLength;
            this.entrada.setPixReceiverPSP(pixLine.substring(startIndex, endIndex));
        }
    }

    protected void somaPosicaoLinha3(int valor) {
        this.posLinha3 += valor;
    }

    protected String capturaString(String linha2, String linha3, CampoLinha2Enum campo) {
        String captura = this.captura(linha3, campo);
        return captura != null ? captura.trim() : null;
    }

    protected Integer capturaInt(String linha2, String linha3, CampoLinha2Enum campo) {
        String captura = this.captura(linha3, campo);
        return captura != null ? Integer.parseInt(captura.trim()) : 0;
    }

    protected Long capturaLong(String linha2, String linha3, CampoLinha2Enum campo) {
        String captura = this.captura(linha3, campo);
        return captura != null ? Long.parseLong(captura.trim()) : 0L;
    }

    protected boolean capturaBoolean(String linha2, String linha3, CampoLinha2Enum campo) {
        return this.capturaInt(linha2, linha3, campo) == 1;
    }

    protected Date capturaDate(String linha2, String linha3, String mask, CampoLinha2Enum campo) throws SyntaxError {
        try {
            return new SimpleDateFormat(mask).parse(this.captura(linha3, campo));
        }
        catch (ParseException e) {
            throw new SyntaxError(3, 3, campo.name() + " DE FORMATO INVALIDO.");
        }
    }

    protected BigDecimal capturaBigDecimal(String linha2, String linha3, CampoLinha2Enum campo) {
        String captura = this.captura(linha3, campo);
        return captura != null ? new BigDecimal(captura).movePointLeft(2) : null;
    }

    private String captura(String linha, CampoLinha2Enum campo) {
        ++this.posBitLinha2;
        int tam = campo.getTamanho();
        if (tam < 0) {
            int tamVar = Math.abs(tam);
            String tamStr = linha.substring(this.posLinha3, this.posLinha3 + tamVar);
            tam = Integer.parseInt(tamStr);
            this.posLinha3 += tamVar;
        }
        String dadoLinha = linha.substring(this.posLinha3, this.posLinha3 + tam);
        this.posLinha3 += tam;
        return dadoLinha;
    }

    protected boolean isBitLinha2Ativo(CampoLinha2Enum campo, String linha2) {
        return linha2.charAt(campo.getPosLinha1() - 1) == '1';
    }

    void initPosLinha3(int posLinha3) {
        this.posLinha3 = posLinha3;
    }

    public int getPosLinha3() {
        return this.posLinha3;
    }

    public EntradaCTFClient getEntrada() {
        return this.entrada;
    }
}

