/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao.parser;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.integracao.TimeoutException;
import com.csi.ctfclient.integracao.parser.CSILine1;
import com.csi.ctfclient.integracao.parser.CSILine2e3;
import com.csi.ctfclient.integracao.parser.ParserInput;
import com.csi.ctfclient.servicos.CTFClient;
import com.csi.ctfclient.servicos.EntradaCTFClient;
import com.csi.ctfclient.servicos.IdentTerminal;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParserInputCSI
extends ParserInput {
    private static final Logger logger = LogManager.getLogger(CTFClient.class);
    private IdentTerminal identTerminal;
    private EntradaCTFClient entrada;
    private ConfCTFClient config;

    @Override
    public void parseStream(InputStream stream) throws Exception {
        this.entrada = new EntradaCTFClient();
        this.identTerminal = new IdentTerminal();
        this.config = new ConfCTFClient();
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(stream));
        String linha1 = this.readLinha1(reader);
        String linha2 = this.readLinha(reader);
        String linha3 = this.readLinha(reader);
        new CSILine1(this.entrada, this.identTerminal).parse(linha1);
        new CSILine2e3(this.entrada, this.identTerminal, this.config).parse(linha2, linha3);
    }

    String readLinha1(LineNumberReader reader) throws TimeoutException, ExcecaoApiAc {
        ConfCTFClient confCTFClient = this.createConfCTFClient();
        String linha1 = "";
        int bytesJaLidos1aLinha = 0;
        try {
            linha1 = reader.readLine();
            if (confCTFClient.isIntegracaoDll()) {
                for (int tentativa = 1; linha1.length() < 4 && tentativa <= 2; ++tentativa) {
                    bytesJaLidos1aLinha = bytesJaLidos1aLinha + linha1.length() + 1;
                    logger.info("Lendo mais bytes da linha1, ja lidos: " + bytesJaLidos1aLinha + " byte(s)");
                    linha1 = reader.readLine();
                }
            }
        }
        catch (Exception e) {
            logger.error("Problemas na conex\u00e3o ou timeout na leitura do posentra");
            throw new TimeoutException();
        }
        if (confCTFClient.isIntegracaoDll()) {
            boolean configuracaoTerminal = this.isConfiguracaoTerminal(linha1);
            if (!configuracaoTerminal) {
                try {
                    linha1 = linha1.substring(4 - bytesJaLidos1aLinha, linha1.length());
                }
                catch (Exception e) {
                    logger.error("Problemas na conex\u00e3o ou timeout");
                    throw new TimeoutException();
                }
            }
            this.entrada.setConfigTerminalInterno(configuracaoTerminal);
        }
        return linha1;
    }

    boolean isConfiguracaoTerminal(String linha1) {
        return linha1.length() > 3 && linha1.substring(0, 3).equals("800");
    }

    String readLinha(LineNumberReader reader) throws TimeoutException {
        try {
            return reader.readLine();
        }
        catch (Exception e) {
            logger.error("Problemas na conex\u00e3o ou timeout");
            throw new TimeoutException();
        }
    }

    ConfCTFClient createConfCTFClient() throws ExcecaoApiAc {
        try {
            return ControladorConfCTFClient.getInstance().getConfig();
        }
        catch (ExcecaoApiAc e) {
            logger.error(e.getMessage());
            throw e;
        }
    }

    @Override
    public EntradaCTFClient getEntrada() {
        return this.entrada;
    }

    @Override
    public IdentTerminal getIdentTerminal() {
        return this.identTerminal;
    }

    @Override
    public ConfCTFClient getConfig() {
        return this.config;
    }
}

