/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao.parser;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.model.ProdutoPromocional;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.integracao.SyntaxError;
import com.csi.ctfclient.integracao.constantes.ConstantesIntegracaoCSI;
import com.csi.ctfclient.integracao.parser.ParserOutput;
import com.csi.ctfclient.servicos.CTFClient;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.CartaoPrepagoDigitalResposta;
import com.csi.ctfclient.servicos.EstabelecimentoMultiECResposta;
import com.csi.ctfclient.servicos.QrCodeQueryResponse;
import com.csi.ctfclient.servicos.RespostaAtivacaoCartaoPrepago;
import com.csi.ctfclient.servicos.RespostaBypass;
import com.csi.ctfclient.servicos.RespostaCompraCreditoDigital;
import com.csi.ctfclient.servicos.RespostaConsultaAnaliticaSPC;
import com.csi.ctfclient.servicos.RespostaConsultaAvs;
import com.csi.ctfclient.servicos.RespostaConsultaCartaoPrepagoDigital;
import com.csi.ctfclient.servicos.RespostaConsultaConfiguracao;
import com.csi.ctfclient.servicos.RespostaConsultaEstabelecimentosMultiEC;
import com.csi.ctfclient.servicos.RespostaConsultaValoresCreditoDigital;
import com.csi.ctfclient.servicos.RespostaCorrespondenteBancario;
import com.csi.ctfclient.servicos.RespostaOperacaoCheque;
import com.csi.ctfclient.servicos.RespostaPagamentoFaturaCartao;
import com.csi.ctfclient.servicos.RespostaProdutosPromocionais;
import com.csi.ctfclient.servicos.RespostaSimulacaoCrediario;
import com.csi.ctfclient.servicos.RespostaTransacoesSAA;
import com.csi.ctfclient.servicos.RespostaValeGas;
import com.csi.ctfclient.servicos.SaidaCTFClient;
import com.csi.ctfclient.tools.communication.Host;
import com.csi.ctfclient.tools.communication.ServicoCTF;
import com.csi.ctfclient.tools.devices.ControladorTranslator;
import com.csi.ctfclient.tools.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ParserOutputCSI
extends ParserOutput
implements ConstantesIntegracaoCSI {
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClient.class);
    private final int[] tamCampo = new int[]{3, 5, 4, 3, 40, 2, 4, 3, 19, 4, 6, 6, 9, 20, 2, 12, 2, 12, 4, 12, 2, 38, 12, 8, 6, 2, 2, 16, 2, 6, 12, 1, 12, 8, 12, 8, 50, 12, 12, 12, 12, 5, 4, 12, 9, 15, 1, 30, 19, 30, 2, 8, 1, 30};
    private final int[] tipoCampo = new int[]{1, 1, 1, 1, 2, 1, 1, 2, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 2, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 2, 1, 2, 1, 1, 2, 1, 2, 2, 1, 1, 2};
    private final int[] tamCampoConsultaAvs = new int[]{1, 16};
    private final int[] tipoCampoConsultaAvs = new int[]{2, 1};
    private final int[] tamCampoCorrespondenteBancario = new int[]{40, 6, 8, 17, 29, 16, 12, 12, 12, 8, 1, 48, 2, 34};
    private final int[] tipoCampoCorrespondenteBancario = new int[]{2, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2};
    private final int[] tamCampoPagamentoFatura = new int[]{40, 6, 8, 17, 12, 12, 5, 16, 12, 12, 12, 6, 16, 1, 48, 2, 34};
    private final int[] tipoCampoPagamentoFatura = new int[]{2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2};
    private final int[] tamCampoConsultaValorCreditoDigital = new int[]{2, 11, 10, 10, 2, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 2, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
    private final int[] tipoCampoConsultaValorCreditoDigital = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private final int[] tamCampoCompraCreditoDigitalLayout3 = new int[]{2, -2, -2};
    private final int[] tipoCampoCompraCreditoDigitalLayout3 = new int[]{1, 1, 1};
    private final int[] tamCampoCompraCreditoDigitalLayout1 = new int[]{2, 3, 8};
    private final int[] tipoCampoCompraCreditoDigitalLayout1 = new int[]{1, 1, 1};
    private final int[] tamCampoConsultaValorCreditoDigital2 = new int[]{2, 11, 10, 10, 2, -4};
    private final int[] tipoCampoConsultaValorCreditoDigital2 = new int[]{1, 1, 1, 1, 1, 2};
    private final int[] tamCampoConsultaConfiguracao = new int[]{10, -2, -3, 40, -3, 40, -3, 40, -3, 40, -3, 40, -3, 40, -3, 40, -3, 1, 1, 1};
    private final int[] tipoCampoConsultaConfiguracao = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
    private final int[] tamCampoValeGas = new int[]{7, 15, 15};
    private final int[] tipoCampoValeGas = new int[]{1, 2, 1};
    private final int[] tamCampoTefDiscOperacaoCheque = new int[]{34, 1, 17, 8, 4, 4, 10};
    private final int[] tipoCampoTefDiscOperacaoCheque = new int[]{2, 1, 1, 1, 1, 1, 1};
    private final int[] tamCampoConsultaAnaliticaSpc = new int[]{83};
    private final int[] tipoCampoConsultaAnaliticaSpc = new int[]{2};
    private final int[] tamCampoAtivacaoCartaoPrepago = new int[]{60};
    private final int[] tipoCampoAtivacaoCartaoPrepago = new int[]{2};
    private OutputStream outStr;

    public String formatLL(int tam, String campo) {
        int tamCampo;
        if (campo == null) {
            campo = "";
        }
        String strTam = (tamCampo = campo.length()) < 10 ? "0" + tamCampo : "" + tamCampo;
        return strTam + StringUtil.completaString(campo, tam, ' ', 4);
    }

    public String formatLLL(int tam, String campo) {
        int tamCampo = campo.length();
        String strTam = "";
        strTam = tamCampo < 10 ? "00" + tamCampo : (tamCampo < 100 ? "0" + tamCampo : "" + tamCampo);
        return strTam + StringUtil.completaString(campo, tam - 3, ' ', true);
    }

    public String formatLLLL(int tam, String campo) {
        int tamCampo = campo.length();
        String strTam = "";
        strTam = tamCampo < 100 ? "000" + tamCampo : (tamCampo < 10 ? "00" + tamCampo : (tamCampo < 100 ? "0" + tamCampo : "" + tamCampo));
        return strTam + StringUtil.completaString(campo, tam - 3, ' ', true);
    }

    public void montaStream(SaidaCTFClient saida) throws SyntaxError {
        int col = 0;
        int ultimaLinha = 1;
        DecimalFormat df = null;
        Calendar calendar = Calendar.getInstance();
        try {
            StringBuffer buffer = new StringBuffer();
            Integer codigoOperacao = saida.getOperacao();
            buffer.append(this.format(this.tamCampo[col], saida.getOperacao(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getEstabelecimento(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getLoja(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getTerminal(), this.tipoCampo[col]));
            buffer.append(this.formatLL(this.tamCampo[++col], saida.getDocumento()));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoRetorno(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoErro(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoRespAutorizadora(), this.tipoCampo[col]));
            String cartao = this.format(this.tamCampo[++col], saida.getNumeroCartao(), this.tipoCampo[col]);
            int tamCartao = cartao.trim().length();
            cartao = tamCartao > 10 ? tamCartao + cartao : "0" + tamCartao + cartao;
            buffer.append(cartao);
            ++col;
            if (saida.getDataVencimentoCartao() != null && saida.getDataVencimentoCartao().length() == 4) {
                String mes = saida.getDataVencimentoCartao().substring(0, 2);
                String ano = saida.getDataVencimentoCartao().substring(2);
                String dataVencimentoCartao = ano + mes;
                buffer.append(this.format(this.tamCampo[col], dataVencimentoCartao, this.tipoCampo[col]));
                ++col;
            } else {
                buffer.append(this.format(this.tamCampo[col], saida.getDataVencimentoCartao(), this.tipoCampo[col]));
                ++col;
            }
            buffer.append(this.format(this.tamCampo[col], saida.getNsuCTF(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoAprovacao(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNsuAutorizadora(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNomeOperacao(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoAutorizadora(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNomeAutorizadora(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoVan(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNomeVan(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoInstFinanceira(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNomeInstFinanceira(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoTransacaoCanceladaCTF(), this.tipoCampo[col]));
            buffer.append(this.formatLL(this.tamCampo[++col], ""));
            buffer.append(this.format(this.tamCampo[++col], saida.getValorTransacao(), this.tipoCampo[col]));
            ++col;
            String dataTransacaoFormatada = "";
            String horaTransacaoFormatada = "";
            boolean dataHoraSetado = false;
            if (codigoOperacao.equals(OperationEnum.OP_CONSULTA_CARTAO.getKey())) {
                calendar.setTimeInMillis(saida.getIdentConsulta());
                dataHoraSetado = true;
            } else if (saida.getHorarioTransacao() != null) {
                calendar.setTime(saida.getHorarioTransacao());
                dataHoraSetado = true;
            }
            if (dataHoraSetado) {
                df = new DecimalFormat("00");
                dataTransacaoFormatada = df.format(calendar.get(5)) + df.format(calendar.get(2) + 1) + calendar.get(1);
                horaTransacaoFormatada = df.format(calendar.get(11)) + df.format(calendar.get(12)) + df.format(calendar.get(13));
            }
            buffer.append(this.format(this.tamCampo[col], dataTransacaoFormatada, this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], horaTransacaoFormatada, this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNumeroTransacao(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoTransacaoCTF(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getInformacaoCriptografada(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNumeroParcelas(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNsuCTFOriginal(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getValorEntrada(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getTipoGarantia(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getValorSaque(), this.tipoCampo[col]));
            ++col;
            String data1aParcelaFormatada = null;
            if (saida.getData1aParcela() != null) {
                df = new DecimalFormat("00");
                calendar.setTime(saida.getData1aParcela());
                data1aParcelaFormatada = df.format(calendar.get(5)) + df.format(calendar.get(2) + 1) + calendar.get(1);
            }
            buffer.append(this.format(this.tamCampo[col], data1aParcelaFormatada, this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getValorParcela(), this.tipoCampo[col]));
            ++col;
            String dataTransacaoOriginal = null;
            if (saida.getDataTransacaoOrig() != null) {
                df = new DecimalFormat("00");
                calendar.setTime(saida.getDataTransacaoOrig());
                dataTransacaoOriginal = df.format(calendar.get(5)) + df.format(calendar.get(2) + 1) + calendar.get(1);
            }
            buffer.append(this.format(this.tamCampo[col], dataTransacaoOriginal, this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getLogomarca(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getSaldoCliente(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoMultitransacao(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getValorParcela(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getValorTotal(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getTaxaJuros(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], "", this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getValorDesconto(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoAprovacao(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNsuAutorizadora(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getTipoCapturaPreAutorizacao(), this.tipoCampo[col]));
            buffer.append(this.formatLL(this.tamCampo[++col], saida.getNomeBandeiraProduto()));
            buffer.append(this.format(this.tamCampo[++col], saida.getIdentConsulta(), this.tipoCampo[col]));
            buffer.append(this.formatLL(this.tamCampo[++col], saida.getNomeRedeAdquirente()));
            buffer.append(this.format(this.tamCampo[++col], saida.getCodigoVanAlfa(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNumeroValeTroca(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getVerificacaoPortadorCartao(), this.tipoCampo[col]));
            buffer.append(this.format(this.tamCampo[++col], saida.getNomeCliente(), this.tipoCampo[col]));
            ++col;
            if (saida.getPixTransactionId() != null && saida.getPixReceiverPSP() != null) {
                buffer.append(this.formatLLL(saida.getPixTransactionId().length(), saida.getPixTransactionId()));
                buffer.append(this.formatLLL(saida.getPixReceiverPSP().length(), saida.getPixReceiverPSP()));
            } else {
                buffer.append("000000");
            }
            buffer.append("\n");
            ultimaLinha = 2;
            if (saida.getMensagemCTF() != null) {
                for (int i = 0; i < saida.getMensagemCTF().length; ++i) {
                    buffer.append(this.formatLLL(saida.getMensagemCTF()[i].length(), saida.getMensagemCTF()[i]));
                }
            }
            buffer.append("000\n");
            if (saida.getCodigoRetorno() == 0) {
                QrCodeQueryResponse response;
                ultimaLinha = 3;
                int col3aLinha = 0;
                if (codigoOperacao.equals(OperationEnum.OP_BYPASS.getKey()) || codigoOperacao.equals(OperationEnum.OP_CONSULTA_FINANCIAMENTO_CREDITO.getKey()) || codigoOperacao.equals(OperationEnum.OP_IDENTIFICACAO_CARTAO_ASSOCIADO.getKey()) || codigoOperacao.equals(OperationEnum.OP_CREDITO.getKey()) || codigoOperacao.equals(OperationEnum.OP_CREDITO_GENERICO.getKey()) || codigoOperacao.equals(OperationEnum.OP_CRED_PARC_COM_JUROS.getKey()) || codigoOperacao.equals(OperationEnum.OP_CRED_PARC_SEM_JUROS.getKey()) || codigoOperacao.equals(OperationEnum.OP_DEBITO.getKey()) || codigoOperacao.equals(OperationEnum.OP_DEBITO_GENERICO.getKey()) || codigoOperacao.equals(OperationEnum.OP_DEB_PRE_DATADO.getKey()) || codigoOperacao.equals(OperationEnum.OP_DEB_PARCELADO_SEM_PARC_AVISTA.getKey()) || codigoOperacao.equals(OperationEnum.OP_DEB_PARCELADO_COM_PARC_AVISTA.getKey()) && saida.getRespostaBypass() != null) {
                    RespostaBypass respostaBypass = saida.getRespostaBypass();
                    if (respostaBypass != null && respostaBypass.getValue() != null) {
                        buffer.append(respostaBypass.getValue());
                        ++col3aLinha;
                    }
                    String splitInfo = "";
                    df = new DecimalFormat("0000");
                    if (saida.getSplitPagamentoPaymentID() != null) {
                        splitInfo = df.format(saida.getSplitPagamentoPaymentID().length());
                        splitInfo = splitInfo + saida.getSplitPagamentoPaymentID();
                    }
                    if (saida.getSplitPagamentoMktTransactionID() != null) {
                        splitInfo = splitInfo + df.format(saida.getSplitPagamentoMktTransactionID().length());
                        splitInfo = splitInfo + saida.getSplitPagamentoMktTransactionID();
                    }
                    buffer.append(splitInfo);
                } else if (codigoOperacao.equals(OperationEnum.OP_CONSULTA_AVS.getKey())) {
                    RespostaConsultaAvs respostaConsultaAvs = saida.getRespostaConsultaAvs();
                    buffer.append(this.format(this.tamCampoConsultaAvs[col3aLinha], respostaConsultaAvs.getCodigoResposta(), this.tipoCampoConsultaAvs[col3aLinha]));
                    buffer.append(this.format(this.tamCampoConsultaAvs[++col3aLinha], respostaConsultaAvs.getResultadoConsulta(), this.tipoCampoConsultaAvs[col3aLinha]));
                    ++col3aLinha;
                } else if (codigoOperacao.equals(OperationEnum.OP_PGTO_FICHA_COMPENSACAO_COM_CONSULTA.getKey()) || codigoOperacao.equals(OperationEnum.OP_PGTO_FICHA_COMPENSACAO.getKey()) || codigoOperacao.equals(OperationEnum.OP_PGTO_CONVENIO_COM_CONSULTA.getKey()) || codigoOperacao.equals(OperationEnum.OP_PGTO_CONVENIO.getKey()) || codigoOperacao.equals(OperationEnum.OP_CONSULTA_FICHA_COMPENSACAO.getKey()) || codigoOperacao.equals(OperationEnum.OP_CONSULTA_CONVENIO.getKey())) {
                    RespostaCorrespondenteBancario respostaCorrespondenteBancario = saida.getRespostaCorrespondenteBancario();
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[col3aLinha], respostaCorrespondenteBancario.getCorrespondenteBancario().getCedente(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    df = new DecimalFormat("00");
                    calendar.setTime(respostaCorrespondenteBancario.getCorrespondenteBancario().getDataContabil());
                    String dataContabilFormatada = df.format(calendar.get(5)) + df.format(calendar.get(2) + 1) + String.valueOf(calendar.get(1)).substring(2);
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], dataContabilFormatada, this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    ++col3aLinha;
                    String bufferFormaPgto = "";
                    bufferFormaPgto = bufferFormaPgto + (respostaCorrespondenteBancario.getCorrespondenteBancario().isPagamentoDinheiro() ? "1" : "0");
                    bufferFormaPgto = bufferFormaPgto + (respostaCorrespondenteBancario.getCorrespondenteBancario().isPagamentoCheque() ? "1" : "0");
                    bufferFormaPgto = bufferFormaPgto + (respostaCorrespondenteBancario.getCorrespondenteBancario().isPagamentoChequeBanco() ? "1" : "0");
                    bufferFormaPgto = bufferFormaPgto + (respostaCorrespondenteBancario.getCorrespondenteBancario().isPagamentoDebito() ? "1" : "0");
                    bufferFormaPgto = bufferFormaPgto + (respostaCorrespondenteBancario.getCorrespondenteBancario().isPagamentoCredito() ? "1" : "0");
                    bufferFormaPgto = bufferFormaPgto + (respostaCorrespondenteBancario.getCorrespondenteBancario().isPagamentoCartaoProprio() ? "1" : "0");
                    bufferFormaPgto = bufferFormaPgto + "00";
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[col3aLinha], bufferFormaPgto, this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], respostaCorrespondenteBancario.getCorrespondenteBancario().getNumeroConvenio(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], respostaCorrespondenteBancario.getCorrespondenteBancario().getFiller(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], respostaCorrespondenteBancario.getCorrespondenteBancario().getAutenticacao(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], respostaCorrespondenteBancario.getValor(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], respostaCorrespondenteBancario.getValorDesconto(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], respostaCorrespondenteBancario.getValorAcrescimo(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    df = new DecimalFormat("00");
                    calendar.setTime(respostaCorrespondenteBancario.getDataVencimento());
                    String dataVencimentoFormatada = df.format(calendar.get(5)) + df.format(calendar.get(2) + 1) + calendar.get(1);
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], dataVencimentoFormatada, this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], respostaCorrespondenteBancario.getModoEntrada(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], respostaCorrespondenteBancario.getCodigoBarras(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], respostaCorrespondenteBancario.getModalidadePagamento(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    buffer.append(this.format(this.tamCampoCorrespondenteBancario[++col3aLinha], respostaCorrespondenteBancario.getCmc7(), this.tipoCampoCorrespondenteBancario[col3aLinha]));
                    ++col3aLinha;
                } else if (codigoOperacao.equals(OperationEnum.OP_CONSULTA_FATURA_CARTAO.getKey())) {
                    RespostaBypass respostaBypass = saida.getRespostaBypass();
                    if (respostaBypass != null && respostaBypass.getValue() != null) {
                        buffer.append(respostaBypass.getValue());
                        ++col3aLinha;
                    }
                } else if (codigoOperacao.equals(OperationEnum.OP_PAGAMENTO_FATURA_CARTAO.getKey())) {
                    RespostaPagamentoFaturaCartao respostaPagamentoFaturaCartao = saida.getRespostaPagamentoFaturaCartao();
                    if (respostaPagamentoFaturaCartao != null) {
                        buffer.append(this.format(this.tamCampoPagamentoFatura[col3aLinha], respostaPagamentoFaturaCartao.getCorrespondenteBancario().getCedente(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        df = new DecimalFormat("00");
                        calendar.setTime(respostaPagamentoFaturaCartao.getCorrespondenteBancario().getDataContabil());
                        String dataContabilFormatada = String.valueOf(calendar.get(1)).substring(2) + df.format(calendar.get(2) + 1) + df.format(calendar.get(5));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], dataContabilFormatada, this.tipoCampoPagamentoFatura[col3aLinha]));
                        ++col3aLinha;
                        String bufferFormaPgto = "";
                        bufferFormaPgto = bufferFormaPgto + (respostaPagamentoFaturaCartao.getCorrespondenteBancario().isPagamentoDinheiro() ? "1" : "0");
                        bufferFormaPgto = bufferFormaPgto + (respostaPagamentoFaturaCartao.getCorrespondenteBancario().isPagamentoCheque() ? "1" : "0");
                        bufferFormaPgto = bufferFormaPgto + (respostaPagamentoFaturaCartao.getCorrespondenteBancario().isPagamentoChequeBanco() ? "1" : "0");
                        bufferFormaPgto = bufferFormaPgto + (respostaPagamentoFaturaCartao.getCorrespondenteBancario().isPagamentoDebito() ? "1" : "0");
                        bufferFormaPgto = bufferFormaPgto + (respostaPagamentoFaturaCartao.getCorrespondenteBancario().isPagamentoCredito() ? "1" : "0");
                        bufferFormaPgto = bufferFormaPgto + (respostaPagamentoFaturaCartao.getCorrespondenteBancario().isPagamentoCartaoProprio() ? "1" : "0");
                        bufferFormaPgto = bufferFormaPgto + "00";
                        buffer.append(this.format(this.tamCampoPagamentoFatura[col3aLinha], bufferFormaPgto, this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getCorrespondenteBancario().getNumeroConvenio(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getValorDevido(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getValorOriginal(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getCorrespondenteBancario().getFiller(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getCorrespondenteBancario().getAutenticacao(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getValorAcrescimo(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getValorDesconto(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getPagamentoMinimo(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        ++col3aLinha;
                        df = new DecimalFormat("00");
                        String dataVencimentoFormatada = "000000";
                        if (respostaPagamentoFaturaCartao.getDataVencimento() != null) {
                            calendar.setTime(respostaPagamentoFaturaCartao.getDataVencimento());
                            dataVencimentoFormatada = df.format(calendar.get(5)) + df.format(calendar.get(2) + 1) + String.valueOf(calendar.get(1)).substring(2);
                        }
                        buffer.append(this.format(this.tamCampoPagamentoFatura[col3aLinha], dataVencimentoFormatada, this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getNumeroDocumento(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getModoEntrada(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getCodigoBarras(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getModalidadePagamento(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        buffer.append(this.format(this.tamCampoPagamentoFatura[++col3aLinha], respostaPagamentoFaturaCartao.getCmc7(), this.tipoCampoPagamentoFatura[col3aLinha]));
                        ++col3aLinha;
                    }
                } else if (codigoOperacao.equals(OperationEnum.OP_CONSULTA_VALORES_CREDITO_DIGITAL.getKey())) {
                    RespostaConsultaValoresCreditoDigital respCD = saida.getRespostaConsultaValoresCreditoDigital();
                    if (respCD.getVersaoLayout() == 1) {
                        buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital[col3aLinha], respCD.getCodigoOperadora(), this.tipoCampoConsultaValorCreditoDigital[col3aLinha]));
                        String ddd = this.format(3, respCD.getDDD(), 1);
                        String telefone = this.format(8, respCD.getTelefone(), 1);
                        buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital[++col3aLinha], ddd + telefone, this.tipoCampoConsultaValorCreditoDigital[col3aLinha]));
                        buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital[++col3aLinha], respCD.getValorVariavelMinimo(), this.tipoCampoConsultaValorCreditoDigital[col3aLinha]));
                        buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital[++col3aLinha], respCD.getValorVariavelMaximo(), this.tipoCampoConsultaValorCreditoDigital[col3aLinha]));
                        buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital[++col3aLinha], respCD.getQtdeValores(), this.tipoCampoConsultaValorCreditoDigital[col3aLinha]));
                        ++col3aLinha;
                        Iterator<BigDecimal> iteratorValor = respCD.getValoresCreditoDigital().iterator();
                        for (int seqValor = 1; iteratorValor.hasNext() && seqValor <= 10; ++seqValor) {
                            BigDecimal valorAtual = iteratorValor.next();
                            buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital[col3aLinha], valorAtual, this.tipoCampoConsultaValorCreditoDigital[col3aLinha]));
                            ++col3aLinha;
                        }
                        for (int iValor = 0; iValor < 10 - respCD.getValoresCreditoDigital().size(); ++iValor) {
                            buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital[col3aLinha], 0, this.tipoCampoConsultaValorCreditoDigital[col3aLinha]));
                            ++col3aLinha;
                        }
                        buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital[col3aLinha], respCD.getQtdeBonus(), this.tipoCampoConsultaValorCreditoDigital[col3aLinha]));
                        ++col3aLinha;
                        Iterator<BigDecimal> iteratorBonus = respCD.getValoresBonus().iterator();
                        for (int seqBonus = 1; iteratorBonus.hasNext() && seqBonus <= 10; ++seqBonus) {
                            BigDecimal valorBonus = iteratorBonus.next();
                            buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital[col3aLinha], valorBonus, this.tipoCampoConsultaValorCreditoDigital[col3aLinha]));
                            ++col3aLinha;
                        }
                        for (int iBonus = 0; iBonus < 10 - respCD.getValoresBonus().size(); ++iBonus) {
                            buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital[col3aLinha], 0, this.tipoCampoConsultaValorCreditoDigital[col3aLinha]));
                            ++col3aLinha;
                        }
                    } else if (respCD.getVersaoLayout() == 2 || respCD.getVersaoLayout() == 3) {
                        buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital2[col3aLinha], respCD.getCodigoOperadora(), this.tipoCampoConsultaValorCreditoDigital2[col3aLinha]));
                        ++col3aLinha;
                        if (respCD.getVersaoLayout() >= 3) {
                            buffer.append(this.formatLL(-2, respCD.getDDD()));
                            buffer.append(this.formatLL(-2, respCD.getTelefone()));
                            ++col3aLinha;
                        } else {
                            String ddd = this.format(3, respCD.getDDD(), 1);
                            String telefone = this.format(8, respCD.getTelefone(), 1);
                            buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital2[col3aLinha], ddd + telefone, this.tipoCampoConsultaValorCreditoDigital2[col3aLinha]));
                            ++col3aLinha;
                        }
                        buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital2[col3aLinha], respCD.getValorVariavelMinimo(), this.tipoCampoConsultaValorCreditoDigital2[col3aLinha]));
                        buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital2[++col3aLinha], respCD.getValorVariavelMaximo(), this.tipoCampoConsultaValorCreditoDigital2[col3aLinha]));
                        buffer.append(this.format(this.tamCampoConsultaValorCreditoDigital2[++col3aLinha], respCD.getQtdeValores(), this.tipoCampoConsultaValorCreditoDigital2[col3aLinha]));
                        ++col3aLinha;
                        Iterator<BigDecimal> iteratorValor = respCD.getValoresCreditoDigital().iterator();
                        Iterator<BigDecimal> iteratorBonus = respCD.getValoresBonus().iterator();
                        while (iteratorValor.hasNext()) {
                            BigDecimal valorAtual = iteratorValor.next();
                            BigDecimal valorBonus = iteratorBonus.next();
                            buffer.append(this.format(10, valorAtual, 1));
                            buffer.append(this.format(10, valorBonus, 1));
                        }
                        ++col3aLinha;
                    }
                } else if (codigoOperacao.equals(OperationEnum.OP_COMPRA_CREDITO_DIGITAL.getKey())) {
                    RespostaCompraCreditoDigital respCD = saida.getRespostaCompraCreditoDigital();
                    if (respCD.getVersaoLayout() < 3) {
                        buffer.append(this.format(this.tamCampoCompraCreditoDigitalLayout1[col3aLinha], respCD.getCodigoOperadora(), this.tipoCampoCompraCreditoDigitalLayout1[col3aLinha]));
                        buffer.append(this.format(this.tamCampoCompraCreditoDigitalLayout1[++col3aLinha], respCD.getDdd(), this.tipoCampoCompraCreditoDigitalLayout1[col3aLinha]));
                        buffer.append(this.format(this.tamCampoCompraCreditoDigitalLayout1[++col3aLinha], respCD.getTelefone(), this.tipoCampoCompraCreditoDigitalLayout1[col3aLinha]));
                        ++col3aLinha;
                    } else if (respCD.getVersaoLayout() == 3) {
                        buffer.append(this.format(this.tamCampoCompraCreditoDigitalLayout3[col3aLinha], respCD.getCodigoOperadora(), this.tipoCampoCompraCreditoDigitalLayout3[col3aLinha]));
                        buffer.append(this.formatLL(this.tamCampoCompraCreditoDigitalLayout3[++col3aLinha], respCD.getDdd()));
                        buffer.append(this.formatLL(this.tamCampoCompraCreditoDigitalLayout3[++col3aLinha], respCD.getTelefone()));
                        ++col3aLinha;
                    }
                } else if (codigoOperacao.equals(OperationEnum.OP_TEF_IP_CHEQUE.getKey())) {
                    RespostaOperacaoCheque respostaCheque = saida.getRespostaCheque();
                    buffer.append(this.format(this.tamCampoTefDiscOperacaoCheque[col3aLinha], respostaCheque.getCmc7(), this.tipoCampoTefDiscOperacaoCheque[col3aLinha]));
                    buffer.append(this.format(this.tamCampoTefDiscOperacaoCheque[++col3aLinha], respostaCheque.getTipoDocumento(), this.tipoCampoTefDiscOperacaoCheque[col3aLinha]));
                    buffer.append(this.format(this.tamCampoTefDiscOperacaoCheque[++col3aLinha], respostaCheque.getDocumento(), this.tipoCampoTefDiscOperacaoCheque[col3aLinha]));
                    SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");
                    String dataCheque = dateFormat.format(respostaCheque.getDataCheque());
                    buffer.append(this.format(this.tamCampoTefDiscOperacaoCheque[++col3aLinha], dataCheque, this.tipoCampoTefDiscOperacaoCheque[col3aLinha]));
                    buffer.append(this.format(this.tamCampoTefDiscOperacaoCheque[++col3aLinha], respostaCheque.getBanco(), this.tipoCampoTefDiscOperacaoCheque[col3aLinha]));
                    buffer.append(this.format(this.tamCampoTefDiscOperacaoCheque[++col3aLinha], respostaCheque.getAgencia(), this.tipoCampoTefDiscOperacaoCheque[col3aLinha]));
                    buffer.append(this.format(this.tamCampoTefDiscOperacaoCheque[++col3aLinha], respostaCheque.getContaCorrente(), this.tipoCampoTefDiscOperacaoCheque[col3aLinha]));
                    ++col3aLinha;
                } else if (codigoOperacao.equals(OperationEnum.OP_COMPRA_VALE_GAS.getKey())) {
                    RespostaValeGas respValeGas = saida.getRespostaValeGas();
                    buffer.append(this.format(this.tamCampoValeGas[col3aLinha], respValeGas.getCodigoProduto(), this.tipoCampoValeGas[col3aLinha]));
                    buffer.append(this.format(this.tamCampoValeGas[++col3aLinha], respValeGas.getDescricaoProduto(), this.tipoCampoValeGas[col3aLinha]));
                    buffer.append(this.format(this.tamCampoValeGas[++col3aLinha], respValeGas.getNumeroEVale(), this.tipoCampoValeGas[col3aLinha]));
                    ++col3aLinha;
                } else if (codigoOperacao.equals(OperationEnum.OP_CONSULTA_CONFIGURACAO.getKey())) {
                    RespostaConsultaConfiguracao consConf = saida.getRespostaConsultaConfiguracao();
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[col3aLinha], consConf.getVersaoAc(), this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    df = new DecimalFormat("00000");
                    String portaFormatada = df.format(Integer.parseInt(consConf.getPortClient()));
                    buffer.append(this.formatLL(this.tamCampoConsultaConfiguracao[++col3aLinha], consConf.getHostClient()) + portaFormatada);
                    ++col3aLinha;
                    Set<ServicoCTF> ipsCTF = consConf.getIpsCTF();
                    Iterator<ServicoCTF> iteIps = ipsCTF.iterator();
                    String bufferIps = "";
                    df = new DecimalFormat("00000");
                    while (iteIps.hasNext()) {
                        ServicoCTF servico = iteIps.next();
                        String porta = servico.getIdentificadorServico();
                        Host host = servico.getHost();
                        String protocolo = servico.getProtocolo();
                        bufferIps = bufferIps + this.formatLL(-2, host.getEndereco());
                        bufferIps = bufferIps + df.format(Integer.parseInt(porta));
                        bufferIps = bufferIps + StringUtil.completaString(protocolo, 4, ' ', 4);
                    }
                    bufferIps = bufferIps + "00";
                    buffer.append(this.formatLLL(this.tamCampoConsultaConfiguracao[col3aLinha], bufferIps));
                    String classeTeclado = consConf.getTeclado() != null ? consConf.getTeclado().getNomeLogico() : "";
                    String tipoTeclado = classeTeclado.equals("TECLADO_PC") ? "TECLADO_PC" : "";
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[++col3aLinha], tipoTeclado, this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    String param = consConf.getTeclado() != null ? this.generateParam(consConf.getTeclado().getParametros()) : "";
                    buffer.append(this.formatLLL(this.tamCampoConsultaConfiguracao[++col3aLinha], param));
                    String classeDisplayOperador = consConf.getDisplayOperador() != null ? consConf.getDisplayOperador().getNomeLogico() : "";
                    String tipoDisplayOperador = classeDisplayOperador.equals("DISPLAY_CTFCLIENT") ? "DISPLAY_CTFCLIENT" : (classeDisplayOperador.length() == 0 ? "DISPLAY_CTFCLIENT" : "");
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[++col3aLinha], tipoDisplayOperador, this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    param = consConf.getDisplayOperador() != null ? this.generateParam(consConf.getDisplayOperador().getParametros()) : "";
                    buffer.append(this.formatLLL(this.tamCampoConsultaConfiguracao[++col3aLinha], param));
                    String classeDisplayCliente = consConf.getDisplayCliente() != null ? consConf.getDisplayCliente().getNomeLogico() : "";
                    String tipoDisplayCliente = classeDisplayCliente.equals("DISPLAY_CTFCLIENT") ? "DISPLAY_CTFCLIENT" : "DISPLAY_CTFCLIENT";
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[++col3aLinha], tipoDisplayCliente, this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    param = consConf.getDisplayCliente() != null ? this.generateParam(consConf.getDisplayCliente().getParametros()) : "";
                    buffer.append(this.formatLLL(this.tamCampoConsultaConfiguracao[++col3aLinha], param));
                    String tipoLeitorCartoes = StringUtil.completaString("LEITOR_CARTAO_BIB_COMPARTILHADA", 40, ' ', true);
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[++col3aLinha], tipoLeitorCartoes, this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    param = consConf.getLeitorCartao() != null ? this.generateParam(consConf.getLeitorCartao().getParametros()) : "";
                    buffer.append(this.formatLLL(this.tamCampoConsultaConfiguracao[++col3aLinha], param));
                    String tipoPinpad = StringUtil.completaString("PINPAD_BIB_COMPARTILHADA", 40, ' ', true);
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[++col3aLinha], tipoPinpad, this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    param = consConf.getPin() != null ? this.generateParam(consConf.getPin().getParametros()) : "";
                    buffer.append(this.formatLLL(this.tamCampoConsultaConfiguracao[++col3aLinha], param));
                    String classeScanner = consConf.getScanner() != null ? consConf.getScanner().getNomeLogico() : "";
                    String tipoScanner = classeScanner.equals("SCANNER_SERIAL") ? "SCANNER_SERIAL" : "";
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[++col3aLinha], tipoScanner, this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    param = consConf.getScanner() != null ? this.generateParam(consConf.getScanner().getParametros()) : "";
                    buffer.append(this.formatLLL(this.tamCampoConsultaConfiguracao[++col3aLinha], param));
                    String classeLeitorDocumentos = consConf.getLeitorDocumento() != null ? consConf.getLeitorDocumento().getNomeLogico() : "";
                    String tipoLeitorDocumentos = classeLeitorDocumentos.equals("LEITOR_DOCUMENTO_TECPOINTTL840") ? "LEITOR_DOCUMENTO_TECPOINTTL840" : "";
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[++col3aLinha], tipoLeitorDocumentos, this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    param = consConf.getLeitorDocumento() != null ? this.generateParam(consConf.getLeitorDocumento().getParametros()) : "";
                    buffer.append(this.formatLLL(this.tamCampoConsultaConfiguracao[++col3aLinha], param));
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[++col3aLinha], consConf.isIntegracaoCriptografada() ? "1" : "0", this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[++col3aLinha], consConf.isCapturaCmc7() ? "1" : "0", this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    buffer.append(this.format(this.tamCampoConsultaConfiguracao[++col3aLinha], consConf.isCreditoCelularHabilitado() ? "1" : "0", this.tipoCampoConsultaConfiguracao[col3aLinha]));
                    ++col3aLinha;
                } else if (codigoOperacao.equals(OperationEnum.OP_CONSULTA_ANALITICA_SPC.getKey())) {
                    RespostaConsultaAnaliticaSPC respostaConsultaAnaliticaSPC = saida.getRespostaConsultaAnaliticaSPC();
                    buffer.append(this.format(this.tamCampoConsultaAnaliticaSpc[col3aLinha], respostaConsultaAnaliticaSPC.getBit62(), this.tipoCampoConsultaAnaliticaSpc[col3aLinha]));
                    ++col3aLinha;
                } else if (codigoOperacao.equals(OperationEnum.OP_ATIVACAO_CARTAO_PREPAGO.getKey())) {
                    RespostaAtivacaoCartaoPrepago respostaAtivacaoCartaoPrepago = saida.getRespostaAtivacaoCartaoPrepago();
                    buffer.append(this.format(this.tamCampoAtivacaoCartaoPrepago[col3aLinha], respostaAtivacaoCartaoPrepago.toString(), this.tipoCampoAtivacaoCartaoPrepago[col3aLinha]));
                    ++col3aLinha;
                } else if (codigoOperacao.equals(OperationEnum.OP_CARGA_PRODUTOS_PROMOCIONAIS.getKey())) {
                    RespostaProdutosPromocionais respostaProdutosPromocionais = saida.getRespostaProdutosPromocionais();
                    buffer.append(this.format(14, respostaProdutosPromocionais.getTimestamp(), 2));
                    ++col3aLinha;
                    List<ProdutoPromocional> listProdutos = respostaProdutosPromocionais.getListProdutosPromocionais();
                    if (listProdutos != null) {
                        for (ProdutoPromocional produtoPromocional : listProdutos) {
                            buffer.append(this.format(20, produtoPromocional.getCodigoEAN(), 2));
                        }
                    }
                    ++col3aLinha;
                } else if (codigoOperacao.equals(OperationEnum.OP_DESCONTO_PRODUTOS_PROMOCIONAIS.getKey())) {
                    RespostaProdutosPromocionais respostaProdutosPromocionais = saida.getRespostaProdutosPromocionais();
                    List<ProdutoPromocional> listProdutos = respostaProdutosPromocionais.getListProdutosPromocionais();
                    if (listProdutos != null) {
                        for (ProdutoPromocional produtoPromocional : listProdutos) {
                            buffer.append(this.format(20, produtoPromocional.getCodigoEAN(), 2));
                            buffer.append(this.format(3, produtoPromocional.getQuantidade(), 1));
                            buffer.append(this.format(7, produtoPromocional.getValorDesconto(), 1));
                        }
                    }
                    ++col3aLinha;
                } else if (codigoOperacao.equals(OperationEnum.OP_SIMULACAO_CREDIARIO_DE_CREDITO.getKey())) {
                    RespostaSimulacaoCrediario respostaSimulacaoCrediario = saida.getRespostaSimulacaoCrediario();
                    buffer.append(this.format(this.tamCampoAtivacaoCartaoPrepago[col3aLinha], respostaSimulacaoCrediario.toString(), this.tipoCampoAtivacaoCartaoPrepago[col3aLinha]));
                    ++col3aLinha;
                } else if (codigoOperacao.equals(OperationEnum.OP_EMISSAO_VALE_TROCA.getKey()) || codigoOperacao.equals(OperationEnum.OP_RESGATE_VALE_TROCA.getKey()) || codigoOperacao.equals(OperationEnum.OP_CONSULTA_REIMPRESSAO_VALE_TROCA.getKey()) || codigoOperacao.equals(OperationEnum.OP_REIMPRESSAO_VALE_TROCA.getKey()) || codigoOperacao.equals(OperationEnum.OP_CONSULTA_GARANTIA_ESTENDIDA.getKey()) || codigoOperacao.equals(OperationEnum.OP_CONSULTA_GARANTIA_ROUBO_FURTO.getKey()) || codigoOperacao.equals(OperationEnum.OP_PAGAMENTO_GARANTIA_EXTENDIDA.getKey()) || codigoOperacao.equals(OperationEnum.OP_PAGAMENTO_GARANTIA_ROUBO_FURTO.getKey()) || codigoOperacao.equals(OperationEnum.OP_CONSULTA_RESGATE_GARANTIA_NAO_MAGNETICA.getKey()) || codigoOperacao.equals(OperationEnum.OP_COMPRA_RESGATE_GARANTIA_NAO_MAGNETICA.getKey()) || codigoOperacao.equals(OperationEnum.OP_CONSULTA_ASSOCIADO.getKey()) || codigoOperacao.equals(OperationEnum.OP_COMPRA_ASSOCIADO.getKey()) || codigoOperacao.equals(OperationEnum.OP_CARGA_HABILITACAO_CARTAO_PRESENTE.getKey()) || codigoOperacao.equals(OperationEnum.OP_RESGATE_CARTAO_PRESENTE_SAA.getKey()) || codigoOperacao.equals(OperationEnum.OP_CONSULTA_CARTAO_PRESENTE_SAA.getKey()) || codigoOperacao.equals(OperationEnum.OP_CARGA_HABILITACAO_CUPONAGEM.getKey()) || codigoOperacao.equals(OperationEnum.OP_CONSULTA_CUPONAGEM.getKey()) || codigoOperacao.equals(OperationEnum.OP_RESGATE_CUPONAGEM.getKey())) {
                    RespostaTransacoesSAA respostaTransacoesSAA = saida.getRespostaTransacoesSAA();
                    if (respostaTransacoesSAA != null) {
                        buffer.append(respostaTransacoesSAA.getBit62());
                        ++col3aLinha;
                    }
                } else if (codigoOperacao.equals(OperationEnum.OP_CAPTURA_DADO_PINPAD.getKey())) {
                    if (saida.getCapturaDadoPinpad() != null) {
                        buffer.append(saida.getCapturaDadoPinpad());
                        ++col3aLinha;
                    }
                } else if (codigoOperacao.equals(OperationEnum.OP_CONSULTA_ESTABELECIMENTOS_MULTI_EC.getKey())) {
                    RespostaConsultaEstabelecimentosMultiEC respostaMultiEC = saida.getRespostaConsultaEstabelecimentosMultiEC();
                    List<EstabelecimentoMultiECResposta> listEstabelecimentosComerciais = respostaMultiEC.getListEstabelecimentosComerciais();
                    if (listEstabelecimentosComerciais != null) {
                        for (EstabelecimentoMultiECResposta estabelecimentoMultiEC : listEstabelecimentosComerciais) {
                            buffer.append(this.format(14, estabelecimentoMultiEC.getIdentificadorEstabelecimento(), 2));
                            buffer.append(this.format(2, estabelecimentoMultiEC.getDescricao().length(), 1));
                            buffer.append(estabelecimentoMultiEC.getDescricao());
                        }
                    }
                } else if (codigoOperacao.equals(OperationEnum.OP_CONSULTA_CARTAO_PREPAGO_DIGITAL.getKey())) {
                    RespostaConsultaCartaoPrepagoDigital respostaConsultaCartaoPrepagoDigital = saida.getRespostaConsultaCartaoPrepagoDigital();
                    if (respostaConsultaCartaoPrepagoDigital != null && respostaConsultaCartaoPrepagoDigital.getListCartaoPrepagoDigital() != null) {
                        for (CartaoPrepagoDigitalResposta cartaoPrepago : respostaConsultaCartaoPrepagoDigital.getListCartaoPrepagoDigital()) {
                            buffer.append(this.format(2, cartaoPrepago.getCodigoEAN().length(), 1));
                            buffer.append(cartaoPrepago.getCodigoEAN());
                            buffer.append(this.format(12, cartaoPrepago.getValor() != null ? cartaoPrepago.getValor().movePointRight(2).longValue() : 0L, 1));
                            buffer.append(this.format(2, cartaoPrepago.getDescricao().length(), 1));
                            buffer.append(cartaoPrepago.getDescricao());
                        }
                    }
                } else if ((codigoOperacao.equals(OperationEnum.OP_QR_CODE_GENERICO.getKey()) || codigoOperacao.equals(OperationEnum.OP_CANCELAMENTO_GENERICO.getKey()) || codigoOperacao.equals(OperationEnum.OP_CANCELAMENTO_CRED.getKey()) || codigoOperacao.equals(OperationEnum.OP_CANCELAMENTO_DEB.getKey()) || codigoOperacao.equals(OperationEnum.OP_PIX_PAYMENT.getKey())) && (response = saida.getQrCodeQueryResponse()) != null && !StringUtil.isEmpty(response.getQrCodeImagePath())) {
                    buffer.append(response.getQrCodeImagePath());
                }
            }
            buffer.append("\n");
            ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
            if (confCTFClient.isIntegracaoDll()) {
                logger.info("Pulando escrita de cupons no POSSAIDA para integra\u00e7\u00e3o DLL.");
                ControladorTranslator.montaPossaida(this.outStr, buffer);
                return;
            }
            if (confCTFClient.isEnvioCupomIntegracao()) {
                if (saida.getCupomCliente() != null) {
                    logger.debug("Escrevendo cupom cliente no POSSAIDA.");
                    buffer.append(saida.getCupomCliente());
                } else {
                    logger.warn("N\u00e3o pode escrever cupom cliente no POSSAIDA.");
                }
                buffer.append("\n");
                if (saida.getCupomClienteReimpressao() != null) {
                    logger.debug("Escrevendo cupom cliente reimpress\u00e3o no POSSAIDA.");
                    buffer.append(saida.getCupomClienteReimpressao());
                } else {
                    logger.warn("N\u00e3o pode escrever cupom cliente reimpress\u00e3o no POSSAIDA.");
                }
                buffer.append("\n");
                if (saida.getCupomLojista() != null) {
                    logger.debug("Escrevendo cupom estabelecimento no POSSAIDA.");
                    buffer.append(saida.getCupomLojista());
                } else {
                    logger.warn("N\u00e3o pode escrever cupom estabelecimento no POSSAIDA.");
                }
                buffer.append("\n");
                if (saida.getCupomLojistaReimpressao() != null) {
                    logger.debug("Escrevendo cupom estabelecimento reimpress\u00e3o no POSSAIDA.");
                    buffer.append(saida.getCupomLojistaReimpressao());
                } else {
                    logger.warn("N\u00e3o pode escrever cupom estabelecimento reimpress\u00e3o no POSSAIDA.");
                }
                buffer.append("\n");
                if (saida.getCupomReduzido() != null) {
                    logger.debug("Escrevendo cupom reduzido no POSSAIDA.");
                    buffer.append(saida.getCupomReduzido());
                } else {
                    logger.warn("N\u00e3o pode escrever cupom reduzido no POSSAIDA.");
                }
                buffer.append("\n");
            }
            this.outStr.write(buffer.toString().getBytes());
            this.outStr.flush();
        }
        catch (IOException e) {
            logger.error("Problemas de IO no stream de sa\u00edda");
            throw new SyntaxError(ultimaLinha, 2);
        }
        catch (ExcecaoApiAc excecaoApiAc) {
            logger.error("Falha ao obter as configura\u00e7\u00f5es durante a montagem do POSSAIDA.");
        }
    }

    private String format(int tam, String value, int tipo) {
        if (value == null) {
            value = "";
        } else {
            String string = value = value.trim().length() != 0 ? value : value.trim();
        }
        if (value.length() > tam) {
            if (tipo == 1) {
                return value.substring(value.length() - tam);
            }
            return value.substring(0, tam);
        }
        if (tipo == 1) {
            return StringUtil.completaString(value, tam, '0', 3);
        }
        return StringUtil.completaString(value, tam, ' ', 4);
    }

    private String format(int tam, int value, int tipo) {
        return this.format(tam, String.valueOf(value), tipo);
    }

    private String format(int tam, long value, int tipo) {
        return this.format(tam, String.valueOf(value), tipo);
    }

    private String format(int tam, BigDecimal value, int tipo) {
        value = value != null ? value.multiply(new BigDecimal(100)) : new BigDecimal(0);
        DecimalFormat df = new DecimalFormat("0");
        return this.format(tam, df.format(value), tipo);
    }

    private String generateParam(String[] itens) {
        String result = "";
        for (int i = 0; i < itens.length; ++i) {
            if (i > 0) {
                result = result + ",";
            }
            result = result + itens[i];
        }
        return result;
    }

    public OutputStream getOutputStream() {
        return this.outStr;
    }

    @Override
    public OutputStream parse(SaidaCTFClient saida, OutputStream outStr) throws SyntaxError {
        this.outStr = outStr;
        this.montaStream(saida);
        return outStr;
    }
}

