/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao.parser;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.model.ProdutoSplitPagamento;
import com.csi.ctfclient.integracao.SyntaxError;
import com.csi.ctfclient.integracao.domain.CampoLinha2Enum;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClient;
import com.csi.ctfclient.tools.util.StringUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class SplitPagamentoParser {
    private static final DecimalFormat FORMAT_4_ZEROS = new DecimalFormat("0000");
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    private final EntradaCTFClient entrada;
    private final String bitSplitPagamento;
    private final int LEFT_POINT_VALORES = 2;
    protected int lastIndex;

    public SplitPagamentoParser(EntradaCTFClient entrada) {
        this.entrada = entrada;
        this.lastIndex = 0;
        this.bitSplitPagamento = String.valueOf(CampoLinha2Enum.SPLIT_PAGAMENTO.getPosLinha1());
    }

    public void parse(String splitInfo) throws Exception {
        this.entrada.setProdutoSplitPagamentoSellerId(this.getSplitInfoSubstring(splitInfo, this.lastIndex, 2));
        this.entrada.setProdutoSplitPagamentoOrderId(this.getSplitInfoSubstring(splitInfo, this.lastIndex, 2));
        this.entrada.setProdutosSplitPagamento(this.parseProducts(splitInfo));
    }

    protected String getSplitInfoSubstring(String splitInfo, int index, int sizeOffset) {
        int size = Integer.parseInt(splitInfo.substring(index, index + sizeOffset));
        this.lastIndex = index + sizeOffset + size;
        return splitInfo.substring(index + sizeOffset, this.lastIndex);
    }

    protected List<ProdutoSplitPagamento> parseProducts(String splitInfo) throws Exception {
        ArrayList<ProdutoSplitPagamento> products = new ArrayList<ProdutoSplitPagamento>();
        do {
            products.add(this.parseProduct(splitInfo));
        } while (this.lastIndex < splitInfo.length());
        return products;
    }

    protected ProdutoSplitPagamento parseProduct(String splitInfo) throws Exception {
        ProdutoSplitPagamento product = new ProdutoSplitPagamento();
        String productString = this.getSplitInfoSubstring(splitInfo, this.lastIndex, 3);
        String[] atributosProdutoTransacao = this.getAtributosProdutoTransacao(productString);
        product.setTipoIdentificacao(4);
        product.setCodigo(this.getCodigo(atributosProdutoTransacao[1].trim()));
        product.setQuantidade(this.getQuantidade(atributosProdutoTransacao[2].trim()));
        product.setValorUnitario(this.getValorUnitario(atributosProdutoTransacao[3].trim()));
        product.setNome(this.getDescricaoProduto(atributosProdutoTransacao[4].trim()));
        product.setIdSubseller(this.getIdSubseller(atributosProdutoTransacao[5].trim()));
        product.setValorJuros(this.getValorJuros(atributosProdutoTransacao[6].trim()));
        product.setPorcentagemTaxa(this.getValorPorcentagem(atributosProdutoTransacao[7].trim()));
        product.setValorTaxa(this.getValorTaxa(atributosProdutoTransacao[8].trim()));
        return product;
    }

    protected String getCodigo(String codigo) throws SyntaxError {
        if (codigo == null || codigo.length() == 0) {
            logger.error("Erro na captura de produtos da transacao. Campo 'C\u00f3digo' \u00e9 obrigat\u00f3rio. Erro no bit= ".concat(this.bitSplitPagamento));
            throw new SyntaxError(3, 7);
        }
        return codigo;
    }

    protected Integer getQuantidade(String quantidade) throws Exception {
        if (quantidade == null || quantidade.length() == 0) {
            logger.error("Erro na captura de produtos da transacao. Campo 'Quantidade' \u00e9 obrigat\u00f3rio e deve ser maior que zero. Erro no bit ".concat(this.bitSplitPagamento));
            throw new SyntaxError(3, 8);
        }
        try {
            return Integer.parseInt(quantidade);
        }
        catch (NumberFormatException e) {
            logger.error("Erro na captura de produtos da transacao. Campo 'Quantidade' possui caracteres inv\u00e1lidos. Erro no bit= ".concat(this.bitSplitPagamento));
            throw new SyntaxError(3, 8);
        }
        catch (Exception e) {
            logger.error("Erro no bit= ".concat(this.bitSplitPagamento));
            logger.error("Erro n\u00e3o identificado: ".concat(e.getMessage()));
            throw e;
        }
    }

    protected BigDecimal getValorUnitario(String valorUnitario) throws Exception {
        if (valorUnitario == null || valorUnitario.length() == 0 || valorUnitario.length() > 12 || Long.parseLong(valorUnitario) <= 0L) {
            logger.error("Erro na captura de produtos da transacao. Campo 'Valor Unit\u00e1rio' \u00e9 obrigat\u00f3rio, deve ser maior que zero e deve conter no m\u00e1ximo 12 caracteres. Erro no bit= ".concat(this.bitSplitPagamento));
            throw new SyntaxError(3, 9);
        }
        try {
            return new BigDecimal(valorUnitario).movePointLeft(2);
        }
        catch (NumberFormatException e) {
            logger.error("Erro no bit= ".concat(this.bitSplitPagamento));
            throw new SyntaxError(3, 9);
        }
        catch (Exception e) {
            logger.error("Erro no bit= ".concat(this.bitSplitPagamento));
            logger.error(e.getMessage());
            throw e;
        }
    }

    protected String getDescricaoProduto(String descricaoProduto) throws SyntaxError {
        if (descricaoProduto == null || descricaoProduto.length() == 0) {
            logger.error("Erro na captura de produtos da transacao. Campo 'Nome' \u00e9 obrigat\u00f3rio. Erro no bit= ".concat(this.bitSplitPagamento));
            throw new SyntaxError(3, 10);
        }
        return descricaoProduto;
    }

    protected String getIdSubseller(String idSubseller) throws SyntaxError {
        if (idSubseller == null || idSubseller.length() == 0) {
            logger.error("Erro na captura de produtos da transacao. Campo 'Id Subseller' \u00e9 obrigat\u00f3rio. Erro no bit= ".concat(this.bitSplitPagamento));
            throw new SyntaxError(3, 11);
        }
        return idSubseller;
    }

    protected BigDecimal getValorJuros(String valorJuros) throws Exception {
        if (valorJuros != null && !valorJuros.isEmpty()) {
            try {
                return new BigDecimal(valorJuros).movePointLeft(2);
            }
            catch (NumberFormatException e) {
                logger.error("Erro na captura de produtos da transacao. Campo 'Valor Juros' possui um caracter inv\u00e1lido. Erro no bit= ".concat(this.bitSplitPagamento));
                throw new SyntaxError(3, 12);
            }
            catch (Exception e) {
                logger.error("Erro no bit= ".concat(this.bitSplitPagamento));
                logger.error(e.getMessage());
                throw e;
            }
        }
        return new BigDecimal(-1);
    }

    protected boolean validaPorcentagem(String valorPorcentagem) {
        int indexDoPonto = valorPorcentagem.indexOf(".");
        if (indexDoPonto != -1) {
            String subStringPercentagem = valorPorcentagem.substring(0, indexDoPonto);
            if (subStringPercentagem.length() > 3) {
                return false;
            }
            subStringPercentagem = valorPorcentagem.substring(indexDoPonto + 1, valorPorcentagem.length());
            return subStringPercentagem.length() <= 6;
        }
        return valorPorcentagem.length() < 4;
    }

    protected BigDecimal getValorPorcentagem(String valorPorcentagem) throws Exception {
        if (valorPorcentagem != null && !valorPorcentagem.isEmpty()) {
            if (this.validaPorcentagem(valorPorcentagem)) {
                try {
                    return new BigDecimal(valorPorcentagem);
                }
                catch (NumberFormatException e) {
                    logger.error("Erro na captura de produtos da transacao. Campo 'Porcentagem Taxa' possui caracter inv\u00e1lido. Erro no bit= ".concat(this.bitSplitPagamento));
                    throw new SyntaxError(3, 12);
                }
                catch (Exception e) {
                    logger.error("Erro no bit= ".concat(this.bitSplitPagamento));
                    logger.error(e.getMessage());
                    throw e;
                }
            }
            logger.error("Erro na captura de produtos da transacao. Campo 'Porcentagem Taxa' possui caracter inv\u00e1lido. Erro no bit= ".concat(this.bitSplitPagamento));
            throw new SyntaxError(3, 12);
        }
        return new BigDecimal(-1);
    }

    protected BigDecimal getValorTaxa(String valorTaxa) throws Exception {
        if (valorTaxa != null && !valorTaxa.isEmpty()) {
            try {
                return new BigDecimal(valorTaxa).movePointLeft(2);
            }
            catch (NumberFormatException e) {
                logger.error("Erro na captura de produtos da transacao. Campo 'Valor Taxa' possui caracter inv\u00e1lido. Erro no bit= ".concat(this.bitSplitPagamento));
                throw new SyntaxError(3, 12);
            }
            catch (Exception e) {
                logger.error("Erro no bit= ".concat(this.bitSplitPagamento));
                logger.error(e.getMessage());
                throw e;
            }
        }
        return new BigDecimal(-1);
    }

    protected String[] getAtributosProdutoTransacao(String produtoTransacao) throws SyntaxError {
        String[] atributosProdutoTransacao = produtoTransacao.replaceAll("\\|\\|", "\\| \\|").split("\\|");
        if (atributosProdutoTransacao.length != 9) {
            logger.error("Erro na captura de produtos da transacao. Numero de atributos diferente do esperado (9). Erro no bit= ".concat(this.bitSplitPagamento));
            throw new SyntaxError(3, 6);
        }
        return atributosProdutoTransacao;
    }

    public String serializa(List<ProdutoSplitPagamento> produtos) {
        StringBuffer result = new StringBuffer();
        for (ProdutoSplitPagamento produto : produtos) {
            String bufferInfo = produto.getTipoIdentificacao() + "|" + produto.getCodigo() + "|" + produto.getQuantidade() + "|" + StringUtil.completaString(produto.getValorUnitario().toString().replaceAll("\\.", ""), 12, '0', 3) + "|" + produto.getNome() + "|" + produto.getIdSubseller() + "|";
            bufferInfo = null != produto.getValorJuros() ? bufferInfo + (produto.getValorJuros().compareTo(new BigDecimal(-1)) == 0 ? "|" : this.getValorFormatado(produto.getValorJuros(), 12, '0', 3) + "|") : bufferInfo + "|";
            bufferInfo = bufferInfo + (produto.getPorcentagemTaxa().compareTo(new BigDecimal(-1)) == 0 ? "|" : produto.getPorcentagemTaxa() + "|");
            bufferInfo = bufferInfo + (produto.getValorTaxa().compareTo(new BigDecimal(-1)) == 0 ? "|" : this.getValorFormatado(produto.getValorTaxa(), 12, '0', 3) + "|");
            result.append(FORMAT_4_ZEROS.format(bufferInfo.length())).append(bufferInfo);
        }
        return result.toString();
    }

    private String getValorFormatado(BigDecimal valor, int tamanho, char complemento, int lado) {
        return valor != null ? StringUtil.completaString(valor.toString().replaceAll("\\.", ""), tamanho, complemento, lado) : StringUtil.completaString("0", tamanho, complemento, lado);
    }
}

