/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes;

import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IDevices;
import com.csi.ctfclient.operacoes.model.DadosBaixaTecnica;
import com.csi.ctfclient.operacoes.model.DadosBaixaTecnicaPinpad;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoVisanetEMV;
import com.csi.ctfclient.tools.util.PersistenciaObjetos;
import com.csi.ctfclient.tools.util.StringUtil;

public class ControladorBaixaTecnica {
    private static final String PATH_NAME = "baixa_tecnica.dat";
    private static final String KEY_BAIXA_TECNICA = "KEY_BAIXA_TECNICA";
    private static ControladorBaixaTecnica instancia;
    private boolean baixaTecnicaSolicitada;
    private DadosBaixaTecnica dadosBaixaTecnica;
    private PersistenciaObjetos persistencia;

    private ControladorBaixaTecnica() throws ExcecaoNaoLocal {
        if (ControladorConfCTFClient.getDiretorioTrabalho() != null) {
            this.setPersistencia(new PersistenciaObjetos(ControladorConfCTFClient.getDiretorioTrabalho() + PATH_NAME));
        } else {
            this.setPersistencia(new PersistenciaObjetos(PATH_NAME));
        }
    }

    public static ControladorBaixaTecnica getInstance() throws ExcecaoNaoLocal {
        if (instancia == null) {
            instancia = new ControladorBaixaTecnica();
        }
        return instancia;
    }

    private DadosBaixaTecnicaPinpad getDadosPin(IDevices dado) {
        PinEMV pin;
        ControladorPerifericos perifericos = dado.getPerifericos();
        SaidaGetInfoEMV info = null;
        SaidaGetInfoVisanetEMV infoVisa = null;
        try {
            pin = perifericos.getPin();
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            pin = null;
        }
        if (pin != null) {
            try {
                info = pin.getInfo();
                infoVisa = pin.getInfoVisanet();
            }
            catch (Exception excecaoPerifericos) {
                // empty catch block
            }
            String redeAdquirente = null;
            String versaoRedeAdquirente = null;
            String modeloSAM = null;
            String anoMesPersonalizacao = null;
            String ultDigitosSeriePinpad = null;
            String idSAM = null;
            if (infoVisa != null) {
                redeAdquirente = infoVisa.getRedeAdquirente();
                versaoRedeAdquirente = infoVisa.getVersaoRedeAdquirente();
                modeloSAM = infoVisa.getModeloSAM();
                anoMesPersonalizacao = infoVisa.getAnoMesPersonalizacao();
                ultDigitosSeriePinpad = infoVisa.getUltDigitosSeriePinpad();
                idSAM = infoVisa.getIdSAM();
            }
            return new DadosBaixaTecnicaPinpad(info.getFabricante(), info.getModeloHardware(), info.getVersaoFirmware(), info.getVersaoEspecificacao(), info.getVersaoAplBasica(), info.getNumSeriePinpad(), info.getRetorno(), redeAdquirente, versaoRedeAdquirente, modeloSAM, anoMesPersonalizacao, ultDigitosSeriePinpad, idSAM);
        }
        DadosBaixaTecnicaPinpad dadosBaixaTecnica = new DadosBaixaTecnicaPinpad();
        dadosBaixaTecnica.setRetornoPPGetInfo(-1);
        return dadosBaixaTecnica;
    }

    private DadosBaixaTecnica capturaDadosPersistidos() {
        DadosBaixaTecnica dados = null;
        try {
            dados = (DadosBaixaTecnica)this.getPersistencia().get(KEY_BAIXA_TECNICA);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dados;
    }

    public boolean verificaNecessidadeBaixaTecnica(IDevices dado) throws ExcecaoNaoLocal {
        DadosBaixaTecnica dadosPersistidos = this.capturaDadosPersistidos();
        DadosBaixaTecnicaPinpad dadosPinPad = this.getDadosPin(dado);
        String codigoPDV = ControladorConfCTFClient.getInstance().getConfig().getTerminal();
        DadosBaixaTecnica dadosBaixa = new DadosBaixaTecnica(dadosPinPad, codigoPDV);
        this.setDadosBaixaTecnica(dadosBaixa);
        if (dadosPersistidos == null || dadosPinPad != null && !dadosPersistidos.equals(dadosBaixa)) {
            this.setBaixaTecnicaSolicitada(true);
        }
        return this.isBaixaTecnicaSolicitada();
    }

    public void persisteBaixaTecnica() throws ExcecaoNaoLocal {
        if (this.dadosBaixaTecnica != null) {
            this.getPersistencia().save(KEY_BAIXA_TECNICA, this.dadosBaixaTecnica);
            this.getPersistencia().persist(true);
        }
        this.setBaixaTecnicaSolicitada(false);
    }

    private DadosBaixaTecnica getDadosBaixaTecnica() {
        return this.dadosBaixaTecnica;
    }

    private void setDadosBaixaTecnica(DadosBaixaTecnica dadosBaixaTecnica) {
        this.dadosBaixaTecnica = dadosBaixaTecnica;
    }

    private PersistenciaObjetos getPersistencia() {
        return this.persistencia;
    }

    private void setPersistencia(PersistenciaObjetos persistencia) {
        this.persistencia = persistencia;
    }

    public String montaDadosGeraisPin() {
        DadosBaixaTecnicaPinpad baixaTecnica = null;
        if (this.getDadosBaixaTecnica() == null) {
            this.setDadosBaixaTecnica(this.capturaDadosPersistidos());
        }
        baixaTecnica = this.getDadosBaixaTecnica().getDadosBaixaTecnicaPinpad();
        String dado = "";
        if (baixaTecnica != null) {
            dado = baixaTecnica.getRetornoPPGetInfo() == -1 ? dado + "-1" : dado + StringUtil.completaString(String.valueOf(baixaTecnica.getRetornoPPGetInfo()), 2, '0', 3);
        }
        dado = dado + StringUtil.completaString(baixaTecnica != null && baixaTecnica.getFabricante() != null ? baixaTecnica.getFabricante() : "", 20, ' ', 4);
        dado = dado + StringUtil.completaString(baixaTecnica != null && baixaTecnica.getModeloHardware() != null ? baixaTecnica.getModeloHardware() : "", 20, ' ', 4);
        dado = dado + StringUtil.completaString(baixaTecnica != null && baixaTecnica.getVersaoFirmware() != null ? baixaTecnica.getVersaoFirmware() : "", 20, ' ', 4);
        dado = dado + StringUtil.completaString(baixaTecnica != null && baixaTecnica.getVersaoEspecificacao() != null ? baixaTecnica.getVersaoEspecificacao() : "", 4, ' ', 4);
        dado = dado + StringUtil.completaString(baixaTecnica != null && baixaTecnica.getVersaoAplBasica() != null ? baixaTecnica.getVersaoAplBasica() : "", 16, ' ', 4);
        dado = dado + StringUtil.completaString(baixaTecnica != null && baixaTecnica.getNumSeriePinpad() != null ? baixaTecnica.getNumSeriePinpad() : "", 20, ' ', 4);
        return dado;
    }

    public String montaDadosVisaNetPin() {
        DadosBaixaTecnicaPinpad baixaTecnica = null;
        String dado = "";
        if (this.getDadosBaixaTecnica() == null) {
            this.setDadosBaixaTecnica(this.capturaDadosPersistidos());
        }
        baixaTecnica = this.getDadosBaixaTecnica().getDadosBaixaTecnicaPinpad();
        dado = dado + StringUtil.completaString(baixaTecnica != null && baixaTecnica.getVersaoRedeAdquirente() != null ? baixaTecnica.getVersaoRedeAdquirente() : "", 20, ' ', 4);
        dado = dado + StringUtil.completaString(baixaTecnica != null && baixaTecnica.getModeloSAM() != null ? baixaTecnica.getModeloSAM() : "", 5, ' ', 4);
        dado = dado + StringUtil.completaString(baixaTecnica != null && baixaTecnica.getAnoMesPersonalizacao() != null ? baixaTecnica.getAnoMesPersonalizacao() : "", 4, ' ', 4);
        dado = dado + StringUtil.completaString(baixaTecnica != null && baixaTecnica.getUltDigitosSeriePinpad() != null ? baixaTecnica.getUltDigitosSeriePinpad() : "", 8, ' ', 4);
        dado = dado + StringUtil.completaString(baixaTecnica != null && baixaTecnica.getIdSAM() != null ? baixaTecnica.getIdSAM() : "", 10, ' ', 4);
        return dado;
    }

    public boolean isBaixaTecnicaSolicitada() {
        return this.baixaTecnicaSolicitada;
    }

    public void setBaixaTecnicaSolicitada(boolean baixaTecnicaSolicitada) {
        this.baixaTecnicaSolicitada = baixaTecnicaSolicitada;
    }
}

