/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.info.constantes.ConstantesControladorPeriferico;
import com.csi.ctfclient.operacoes.ControladorPerifericosHandler;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.ConfiguracaoPerifericos;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.LeitorDocumento;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.PerifericoEntradaDadosListener;
import com.csi.ctfclient.tools.devices.Scanner;
import com.csi.ctfclient.tools.devices.Teclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.lang.reflect.Constructor;
import java.util.List;

public class ControladorPerifericos
implements ConstantesControladorPeriferico {
    public static final String DEFAULT_HANDLER = "com.csi.ctfclient.operacoes.ControladorPerifericosDefault";
    public static final int WRITE_LEFT_TO_RIGHT = 0;
    public static final int WRITE_RIGHT_TO_LEFT = 1;
    public static String HANDLER = null;
    private final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
    private ConfiguracaoPerifericos configuracaoPerifericos;
    private ControladorPerifericosHandler perifericosHandler = null;
    private PerifericoEntradaDadosListener eventoNaoEsperadoListener;
    private EventoDispositivoEntrada eventoNaoEsperado;
    private boolean displayLocked;

    public ControladorPerifericos() {
    }

    public ControladorPerifericos(ConfiguracaoPerifericos per, boolean integracaoTranslator) {
        this.logger.info("Instanciando controlador de perifericos...");
        this.configuracaoPerifericos = per;
        if (HANDLER == null) {
            HANDLER = DEFAULT_HANDLER;
        }
        try {
            Class[] params = new Class[]{ControladorPerifericos.class, ConfiguracaoPerifericos.class, Boolean.TYPE};
            Class<?> clazz = Class.forName(HANDLER);
            Constructor<?> cons = clazz.getConstructor(params);
            this.perifericosHandler = (ControladorPerifericosHandler)cons.newInstance(this, per, integracaoTranslator);
        }
        catch (Exception e) {
            this.logger.fatal(String.format("Erro generico ao carregar periferico %s: %s", HANDLER, e.getMessage()), e);
        }
    }

    public static void setHandler(String nome) {
        HANDLER = nome;
    }

    public ControladorPerifericosHandler getHandeler() {
        return this.perifericosHandler;
    }

    public void configTerminalInterno(boolean configTerminalInterno) {
        if (this.perifericosHandler != null) {
            this.perifericosHandler.configTerminalInterno(configTerminalInterno);
        }
    }

    public ILeitorCartaoHandler getLeitorCartao() throws ExcecaoPerifericos {
        return this.perifericosHandler.getLeitorCartao();
    }

    public LeitorDocumento getLeitorDocumento() throws ExcecaoPerifericos {
        return this.perifericosHandler.getLeitorDocumento();
    }

    public Scanner getScanner() throws ExcecaoPerifericos {
        return this.perifericosHandler.getScanner();
    }

    public PinEMV getPin() throws ExcecaoPerifericos {
        return this.perifericosHandler.getPin();
    }

    public Teclado getTeclado() throws ExcecaoPerifericos {
        return this.perifericosHandler.getTeclado();
    }

    public LayoutDisplay getUltimoDisplay() {
        return this.perifericosHandler.getUltimoDisplay();
    }

    public int imprimeDisplay(LayoutDisplay layoutDisplay) throws ExcecaoNaoLocal {
        if (this.displayLocked) {
            this.logger.info("Pulando a exibi\u00e7\u00e3o de display pois a tela est\u00e1 trancada");
            return ControladorPerifericosHandler.NO_LINES_PRINTED;
        }
        return this.perifericosHandler.imprimeDisplay(layoutDisplay);
    }

    public void printPNG(String header, String footer1, String footer2, byte[] image) throws ExcecaoNaoLocal {
        if (this.displayLocked) {
            this.logger.info("Pulando a exibi\u00e7\u00e3o de QR Code pois a tela est\u00e1 trancada");
            return;
        }
        this.perifericosHandler.printPNG(header, footer1, footer2, image);
    }

    public synchronized EventoDispositivoEntrada confirmaDado(LayoutDisplay layoutDisplay) throws ExcecaoNaoLocal {
        return this.perifericosHandler.confirmaDado(layoutDisplay);
    }

    public synchronized EventoDispositivoEntrada capturaPOSTef(LayoutDisplay layoutDisplay) throws ExcecaoNaoLocal {
        return this.perifericosHandler.capturaPOSTef(layoutDisplay);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo) throws ExcecaoNaoLocal {
        return this.perifericosHandler.capturaDado(layoutDisplay, tipoCampo);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, String valorDefault) throws ExcecaoNaoLocal {
        return this.perifericosHandler.capturaDado(layoutDisplay, tipoCampo, valorDefault);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, boolean autoSkip, ConstantesApiAc.TipoCampo tipoCampo) throws ExcecaoNaoLocal {
        return this.perifericosHandler.capturaDado(layoutDisplay, autoSkip, tipoCampo);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, int tamMaximoEdicao) throws ExcecaoNaoLocal {
        return this.perifericosHandler.capturaDado(layoutDisplay, tipoCampo, tamMaximoEdicao);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, String valorDefault, boolean aceitaZerosEsquerda) throws ExcecaoNaoLocal {
        return this.perifericosHandler.capturaDado(layoutDisplay, tipoCampo, valorDefault, aceitaZerosEsquerda);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, boolean aceitaZerosEsquerda) throws ExcecaoNaoLocal {
        return this.perifericosHandler.capturaDado(layoutDisplay, tipoCampo, aceitaZerosEsquerda);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, boolean aceitaZerosEsquerda, boolean mascaraSenha) throws ExcecaoNaoLocal {
        return this.perifericosHandler.capturaDado(layoutDisplay, tipoCampo, aceitaZerosEsquerda, mascaraSenha);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, int modoEdicao, boolean aceitaZerosEsquerda, boolean mascaraSenha) throws ExcecaoNaoLocal {
        return this.perifericosHandler.capturaDado(layoutDisplay, tipoCampo, modoEdicao, aceitaZerosEsquerda, mascaraSenha);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, int modoEdicao, boolean pularLinhaEdicao, int colunaEdicao, boolean aceitaZerosEsquerda) throws ExcecaoNaoLocal {
        return this.perifericosHandler.capturaDado(layoutDisplay, tipoCampo, modoEdicao, pularLinhaEdicao, colunaEdicao, aceitaZerosEsquerda);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, int modoEdicao, boolean pularLinhaEdicao, int colunaEdicao, boolean aceitaZerosEsquerda, String valorDefault) throws ExcecaoNaoLocal {
        return this.perifericosHandler.capturaDado(layoutDisplay, tipoCampo, modoEdicao, pularLinhaEdicao, colunaEdicao, aceitaZerosEsquerda, valorDefault);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, boolean pularLinhaEdicao, int colunaEdicao, boolean aceitaZerosEsquerda) throws ExcecaoNaoLocal {
        return this.perifericosHandler.capturaDado(layoutDisplay, tipoCampo, pularLinhaEdicao, colunaEdicao, aceitaZerosEsquerda);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, boolean aceitaZerosEsquerda, long[] perifericos) throws ExcecaoNaoLocal {
        return this.perifericosHandler.capturaDado(layoutDisplay, tipoCampo, aceitaZerosEsquerda, perifericos);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, boolean aceitaZerosEsquerda, String valorDefault, long[] perifericos) throws ExcecaoNaoLocal {
        return this.perifericosHandler.capturaDado(layoutDisplay, tipoCampo, aceitaZerosEsquerda, valorDefault, perifericos);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, boolean aceitaZerosEsquerda, int colunaEdicao, boolean pularLinhaEdicao, String valorDefault) throws ExcecaoNaoLocal {
        return this.perifericosHandler.capturaDado(layoutDisplay, tipoCampo, aceitaZerosEsquerda, colunaEdicao, pularLinhaEdicao, valorDefault);
    }

    public synchronized EventoDispositivoEntrada captureDataAlignedLeft(LayoutDisplay display, ConstantesApiAc.TipoCampo field, String defaultValue) throws ExcecaoNaoLocal {
        return this.perifericosHandler.captureDataAlignedLeft(display, field, defaultValue);
    }

    public int imprimeMenu(LayoutMenu layoutMenu) throws ExcecaoNaoLocal {
        return this.perifericosHandler.imprimeMenu(layoutMenu);
    }

    public EventoTeclado imprimeMenu(LayoutMenu layoutMenu, String[] mensagemCaptura, ConstantesApiAc.TipoCampo tipoCampo) throws ExcecaoNaoLocal {
        return this.perifericosHandler.imprimeMenu(layoutMenu, mensagemCaptura, tipoCampo);
    }

    public int exibeMenuCancelamento() throws ExcecaoNaoLocal {
        return this.perifericosHandler.exibeMenuCancelamento();
    }

    public void limpaDisplay() throws ExcecaoNaoLocal {
        this.perifericosHandler.limpaDisplay();
    }

    public void liberarRecursos(boolean liberaBBComp) throws ExcecaoPerifericos {
        this.perifericosHandler.liberarRecursos(liberaBBComp);
    }

    public void liberarRecursosPinCartao() throws ExcecaoPerifericos {
        this.perifericosHandler.liberarRecursosPinCartao();
    }

    public boolean perifericoCarregado(String valor) {
        return this.configuracaoPerifericos.perifericoCarregado(valor);
    }

    public void eventoPOSTef(EventoDispositivoEntrada event) {
        this.perifericosHandler.eventoPOSTef(event);
    }

    public PerifericoEntradaDadosListener getEventoNaoEsperadoListener() {
        return this.eventoNaoEsperadoListener;
    }

    public void setEventoNaoEsperadoListener(PerifericoEntradaDadosListener leitorCartaoListener) {
        this.eventoNaoEsperadoListener = leitorCartaoListener;
    }

    public EventoDispositivoEntrada getEventoNaoEsperado() {
        return this.eventoNaoEsperado;
    }

    public void setEventoNaoEsperado(EventoDispositivoEntrada eventoAbort) {
        this.eventoNaoEsperado = eventoAbort;
    }

    public void setDisplayLocked(boolean displayLocked) {
        this.displayLocked = displayLocked;
    }

    public boolean perguntaSimNao(Process p, String mensagem) throws ExcecaoNaoLocal {
        LayoutMenu menu = new LayoutMenu(mensagem, true);
        menu.addItem(new ItemMenu("SIM", "1"));
        menu.addItem(new ItemMenu("NAO", "2"));
        int resultado = p.getPerifericos().imprimeMenu(menu);
        return resultado == 1;
    }

    public EventoTeclado getUserInput(Process dados, ConstantesApiAc.TipoCampo mask, String field) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(InternacionalizacaoUtil.getInstance().getMessage(field));
        return (EventoTeclado)dados.getPerifericos().capturaDado(displayModel, mask, true, 14, true);
    }

    public int showSingleChoiceMenu(Process parent, String title, List<String> options) throws ExcecaoNaoLocal {
        LayoutMenu menu = new LayoutMenu(title, true);
        int index = 1;
        for (String option : options) {
            menu.addItem(new ItemMenu(option, String.valueOf(index++)));
        }
        int selectedIndex = parent.getPerifericos().imprimeMenu(menu);
        if (selectedIndex == -1) {
            return -1;
        }
        return selectedIndex - 1;
    }

    public void solicitationMessage() throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
        this.imprimeDisplay(displayModel);
    }

    public void consultMessage() throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        displayModel.addLinha(new Linha(inter.getMessage("SOLICITACAO_CONSULTA1")));
        displayModel.addLinha(new Linha(inter.getMessage("SOLICITACAO_CONSULTA2")));
        displayModel.addLinha(new Linha(inter.getMessage("SOLICITACAO_CONSULTA3")));
        this.imprimeDisplay(displayModel);
    }

    public void waitMessage() throws ExcecaoNaoLocal {
        LayoutDisplay layoutDisplay = new LayoutDisplay();
        layoutDisplay.addLinha(new Linha("AGUARDE..."));
        this.imprimeDisplay(layoutDisplay);
    }
}

