/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes;

import com.csi.ctfclient.excecoes.ExcecaoMascaraInvalida;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.excecoes.ExcecaoValorInvalido;
import com.csi.ctfclient.gui.TelaPrincipal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.ControladorPerifericosHandler;
import com.csi.ctfclient.operacoes.VerificaTemporizacao;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.operacoes.model.controller.ControladorPersistencia;
import com.csi.ctfclient.tools.devices.ConfiguracaoPerifericos;
import com.csi.ctfclient.tools.devices.ControladorTranslator;
import com.csi.ctfclient.tools.devices.Display;
import com.csi.ctfclient.tools.devices.EntradaDeDados;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.LeitorDocumento;
import com.csi.ctfclient.tools.devices.ParametrosEdicaoTeclado;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.Scanner;
import com.csi.ctfclient.tools.devices.Teclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.devices.fusion.ControladorFusion;
import com.csi.ctfclient.tools.devices.generic.JPanelDisplay;
import com.csi.ctfclient.tools.util.ParametrosInternacionalizacao;
import java.math.BigDecimal;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ControladorPerifericosDefault
extends ControladorPerifericosHandler {
    public static final int WRITE_LEFT_TO_RIGHT = 0;
    public static final int WRITE_RIGTH_TO_LEFT = 1;
    private static final Logger logger = LogManager.getLogger(Periferico.class);
    private static final String MSG_DISPLAY = "OPERACAO CANCELADA?";
    private ControladorPerifericos controladorPerifericos;
    private ConfiguracaoPerifericos configuracaoPerifericos;
    private boolean displayLocked;
    private EntradaDeDados entradaDeDados;
    private ParametrosInternacionalizacao internacionalizacao;
    private TelaPrincipal telaPrincipal;
    private boolean integracaoTranslator;
    private LayoutDisplay ultimoDisplay = null;

    public ControladorPerifericosDefault(ControladorPerifericos controladorPerifericos, ConfiguracaoPerifericos per, boolean integracaoTranslator) throws ExcecaoNaoLocal {
        super(controladorPerifericos, per, integracaoTranslator);
        this.controladorPerifericos = controladorPerifericos;
        this.integracaoTranslator = integracaoTranslator;
        if (!integracaoTranslator) {
            this.telaPrincipal = new TelaPrincipal();
        }
        this.entradaDeDados = new EntradaDeDados();
        this.internacionalizacao = new ParametrosInternacionalizacao();
        this.configuracaoPerifericos = per;
    }

    @Override
    public void configTerminalInterno(boolean configTerminalInterno) {
        if (configTerminalInterno) {
            if (this.telaPrincipal == null) {
                this.telaPrincipal = new TelaPrincipal();
            }
            if (this.integracaoTranslator) {
                this.integracaoTranslator = false;
            }
        } else {
            if (this.telaPrincipal != null) {
                this.telaPrincipal.setVisible(false);
            }
            this.integracaoTranslator = true;
        }
    }

    public EntradaDeDados getEntradaDeDados() {
        return this.entradaDeDados;
    }

    @Override
    public ILeitorCartaoHandler getLeitorCartao() throws ExcecaoPerifericos {
        ILeitorCartaoHandler cartaoHandler;
        if (this.entradaDeDados.getLeitorCartao() == null && (cartaoHandler = this.configuracaoPerifericos.getPerifericoLeitorCartao()) != null) {
            cartaoHandler.addListener(new PerifericoEventHandler(this), false);
            this.entradaDeDados.setLeitorCartao(cartaoHandler);
            this.entradaDeDados.habilitaLeitorCartao();
        }
        return this.configuracaoPerifericos.getPerifericoLeitorCartao();
    }

    @Override
    public LeitorDocumento getLeitorDocumento() throws ExcecaoPerifericos {
        LeitorDocumento leitorDocumento;
        if (this.entradaDeDados.getLeitorDocumento() == null && (leitorDocumento = this.configuracaoPerifericos.getPerifericoLeitorDocumento()) != null) {
            leitorDocumento.setFrame(this.telaPrincipal);
            this.entradaDeDados.setLeitorDocumento(leitorDocumento);
            this.entradaDeDados.habilitaLeitorDocumento();
        }
        return this.configuracaoPerifericos.getPerifericoLeitorDocumento();
    }

    @Override
    public Scanner getScanner() throws ExcecaoPerifericos {
        Scanner scanner;
        if (this.entradaDeDados.getScanner() == null && (scanner = this.configuracaoPerifericos.getPerifericoScanner()) != null) {
            this.entradaDeDados.setScanner(scanner);
            this.entradaDeDados.habilitaScanner();
        }
        return this.configuracaoPerifericos.getPerifericoScanner();
    }

    @Override
    public PinEMV getPin() throws ExcecaoPerifericos {
        PinEMV pinEMV;
        if (this.entradaDeDados.getPin() == null && (pinEMV = this.configuracaoPerifericos.getPerifericoPin()) != null) {
            pinEMV.addListener(new PerifericoEventHandler(this), false);
            this.entradaDeDados.setPin(pinEMV);
            this.entradaDeDados.habilitaPin();
        }
        return this.configuracaoPerifericos.getPerifericoPin();
    }

    @Override
    protected Teclado getTeclado() throws ExcecaoPerifericos {
        Teclado teclado = this.configuracaoPerifericos.getPerifericoTeclado();
        if (this.entradaDeDados.getTeclado() == null && teclado != null) {
            try {
                ParametrosEdicaoTeclado par = new ParametrosEdicaoTeclado(false, false, true, "ZZZZZZZZZZZZZZ", 1, 0, ",", ".", true, "", 0, 0, null, ConstantesApiAc.TODAS_TECLAS, false);
                par.ativeSenha('*');
                teclado.defineParametros(par);
            }
            catch (ExcecaoMascaraInvalida e) {
                throw new ExcecaoPerifericos("CPD01", "Erro na obtencao do teclado", e.getMessage());
            }
            teclado.setFrame(this.telaPrincipal);
            teclado.adicionaDisplayEco(this.getDisplay());
            if (this.isDisplayExterno()) {
                teclado.adicionaDisplayEco(this.getDisplayOperador());
            }
            this.entradaDeDados.setTeclado(teclado);
            this.entradaDeDados.habilitaTeclado();
            teclado.habilita();
        }
        return teclado;
    }

    @Override
    protected Display getDisplay() throws ExcecaoPerifericos {
        this.getTelaPrincipal().setVisible(true);
        Display display = this.configuracaoPerifericos.getPerifericoDisplayCliente();
        this.telaPrincipal.setDisplay((JPanelDisplay)display);
        return display;
    }

    public Display getDisplayOperador() throws ExcecaoPerifericos {
        Display display = this.configuracaoPerifericos.getPerifericoDisplayOperador();
        if (display != null) {
            display.habilita();
        }
        return display;
    }

    public boolean isDisplayExterno() {
        return this.configuracaoPerifericos.isDisplayExterno();
    }

    private TelaPrincipal getTelaPrincipal() {
        return this.telaPrincipal;
    }

    @Override
    public LayoutDisplay getUltimoDisplay() {
        return this.ultimoDisplay;
    }

    @Override
    public int imprimeDisplay(LayoutDisplay layoutDisplay) throws ExcecaoNaoLocal {
        this.ultimoDisplay = layoutDisplay;
        if (this.integracaoTranslator) {
            return ControladorTranslator.getInstancia().exibeDisplay(layoutDisplay);
        }
        try {
            this.limpaDisplay();
            List<Linha> linhas = layoutDisplay.getLinhas();
            int x = layoutDisplay.getPrimeiraLinha();
            Display display = this.getDisplay();
            Display displayOperador = this.getDisplayOperador();
            for (Linha linha : linhas) {
                display.imprimeEm(x += linha.getPularLinha(), linha.getColuna(), linha.getTexto());
                if (this.isDisplayExterno() && linha.getTexto() != null && x < 2) {
                    displayOperador.imprimeEm(x, linha.getColuna(), linha.getTexto());
                }
                ++x;
            }
            if (layoutDisplay.getDelay() > 0L) {
                if (layoutDisplay.isCancelarDelay()) {
                    VerificaTemporizacao verificaTemporizacao = new VerificaTemporizacao(this.entradaDeDados, layoutDisplay.getDelay());
                    verificaTemporizacao.start();
                    this.leDados(new long[]{1L});
                    verificaTemporizacao.cancelaTemporizacao();
                } else {
                    try {
                        Thread.sleep(layoutDisplay.getDelay());
                    }
                    catch (InterruptedException e) {
                        logger.debug("Espera interrompida: " + e.getMessage());
                    }
                }
            }
            return x;
        }
        catch (ExcecaoPerifericos e) {
            throw new ExcecaoNaoLocal(e);
        }
    }

    @Override
    public void printPNG(String header, String footer1, String footer2, byte[] image) throws ExcecaoNaoLocal {
        try {
            Display display = this.getDisplay();
            display.limpa();
            display.printPNG(header, footer1, footer2, ControladorPersistencia.getInstance().getQrCodeImagePath());
        }
        catch (ExcecaoPerifericos e) {
            throw new ExcecaoNaoLocal(e);
        }
    }

    @Override
    public void imprimeComDelayNaoBlocante(LayoutDisplay layoutDisplay) throws ExcecaoNaoLocal {
        long delayDisplay = layoutDisplay.getDelay();
        if (delayDisplay > 0L) {
            layoutDisplay.setDelay(0L);
        }
        VerificaTemporizacao verificaTemporizacao = new VerificaTemporizacao(this.entradaDeDados, delayDisplay);
        verificaTemporizacao.start();
        this.leDados(new long[]{1L});
        verificaTemporizacao.cancelaTemporizacao();
    }

    @Override
    public synchronized EventoDispositivoEntrada confirmaDado(LayoutDisplay layoutDisplay) throws ExcecaoNaoLocal {
        if (this.integracaoTranslator) {
            return ControladorTranslator.getInstancia().confirmaDado(layoutDisplay);
        }
        String[] teclasFinalizadoras = new String[]{"ENTRA", "VOLTA"};
        if (this.isDisplayExterno()) {
            try {
                EventoTeclado evt;
                int linhaVisivel = 1;
                LayoutDisplay aux = layoutDisplay;
                while (true) {
                    String navegacao = "";
                    if (aux.getLinhas().size() > 2) {
                        if (linhaVisivel == 1) {
                            navegacao = " [->]";
                            teclasFinalizadoras = new String[]{"ENTRA", "VOLTA", "TECLA_DIREITA"};
                        } else if (linhaVisivel == aux.getLinhas().size() - 1) {
                            navegacao = " [<-]";
                            teclasFinalizadoras = new String[]{"ENTRA", "VOLTA", "TECLA_ESQUERDA"};
                        } else {
                            navegacao = " [<- / ->]";
                            teclasFinalizadoras = new String[]{"ENTRA", "VOLTA", "TECLA_ESQUERDA", "TECLA_DIREITA"};
                        }
                    }
                    layoutDisplay = new LayoutDisplay();
                    Linha linha = aux.getLinhas().get(0);
                    layoutDisplay.addLinha(new Linha(linha.getTexto() + navegacao));
                    if (aux.getLinhas().size() > 1) {
                        linha = aux.getLinhas().get(linhaVisivel);
                        layoutDisplay.addLinha(new Linha(linha.getTexto()));
                    }
                    if ((evt = (EventoTeclado)this.capturaDadoDisplayExterno(layoutDisplay, null, teclasFinalizadoras)).getTeclaFinalizadora().equals("TECLA_ESQUERDA")) {
                        if (linhaVisivel <= 1) continue;
                        --linhaVisivel;
                        continue;
                    }
                    if (!evt.getTeclaFinalizadora().equals("TECLA_DIREITA")) break;
                    if (linhaVisivel >= aux.getLinhas().size() - 1) continue;
                    ++linhaVisivel;
                }
                return evt;
            }
            catch (Exception e) {
                logger.error("Erro durante a confirma\u00e7\u00e3o de dado: " + e.getMessage());
                return null;
            }
        }
        return this.capturaDado(layoutDisplay, null, -1, 1, teclasFinalizadoras, 0, true, false, "", false, new long[]{1L}, false);
    }

    public synchronized EventoDispositivoEntrada capturaDadoDisplayExterno(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, String[] teclasFinalizadoras) throws ExcecaoNaoLocal {
        int i = layoutDisplay.getLinhas().size();
        if (i > 0) {
            --i;
        }
        Linha linha = layoutDisplay.getLinhas().get(i);
        return this.capturaDado(layoutDisplay, tipoCampo, -1, 1, teclasFinalizadoras, linha.getTexto().length(), false, true, "", false, new long[]{1L}, false);
    }

    public synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, String[] teclasFinalizadoras) throws ExcecaoNaoLocal {
        return this.capturaDado(layoutDisplay, tipoCampo, -1, 1, teclasFinalizadoras, 0, true, true, "", true, new long[]{1L}, false);
    }

    public synchronized EventoDispositivoEntrada capturaO(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, String[] teclasFinalizadoras) throws ExcecaoNaoLocal {
        return this.capturaDado(layoutDisplay, tipoCampo, -1, 1, teclasFinalizadoras, 0, true, true, "", true, new long[]{1L}, false);
    }

    @Override
    protected synchronized EventoDispositivoEntrada capturaDado(LayoutDisplay layoutDisplay, ConstantesApiAc.TipoCampo tipoCampo, int tamMaximoEdicao, int modoEdicao, String[] teclas, int colunaEdicao, boolean pularLinhaEdicao, boolean aceitaZerosEsquerda, String valorDefault, boolean autoSkip, long[] perifericos, boolean mascaraSenha) throws ExcecaoNaoLocal {
        try {
            if (this.integracaoTranslator) {
                ControladorTranslator.EventoNaoEsperadoHandler handler = new ControladorTranslator.EventoNaoEsperadoHandler(){

                    @Override
                    public EventoDispositivoEntrada getEvento() {
                        return ControladorPerifericosDefault.this.controladorPerifericos.getEventoNaoEsperado();
                    }
                };
                return ControladorTranslator.getInstancia().capturaDado(layoutDisplay, tipoCampo, aceitaZerosEsquerda, perifericos, this.entradaDeDados, handler);
            }
            int linhaEdicao = 0;
            if (layoutDisplay != null) {
                int linhasUtilizadas = this.imprimeDisplay(layoutDisplay);
                linhaEdicao = pularLinhaEdicao ? linhasUtilizadas : linhasUtilizadas - 1;
            }
            Teclado teclado = this.getTeclado();
            while (this.displayLocked) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ParametrosEdicaoTeclado par = null;
            try {
                boolean sentidoEsquerdaDireita = true;
                if (modoEdicao == 0) {
                    sentidoEsquerdaDireita = false;
                } else if (modoEdicao == 1) {
                    sentidoEsquerdaDireita = true;
                }
                String mascaraEdicao = "";
                if (tipoCampo != null) {
                    if (tamMaximoEdicao > 0) {
                        String novaMascaraEdicao = "";
                        String valorMascara = tipoCampo.getMascaraEdicao().substring(0, 1);
                        for (int i = 0; i < tamMaximoEdicao; ++i) {
                            novaMascaraEdicao = novaMascaraEdicao + valorMascara;
                        }
                        mascaraEdicao = novaMascaraEdicao;
                    } else {
                        mascaraEdicao = tipoCampo.getMascaraEdicao();
                    }
                }
                par = teclado.getParametros();
                par.setParametros(aceitaZerosEsquerda, false, sentidoEsquerdaDireita, mascaraEdicao, linhaEdicao, colunaEdicao, this.internacionalizacao.getSeparadorDecimal(), this.internacionalizacao.getSeparadorGrupo(), autoSkip, "", 0, 0, valorDefault, teclas, false);
                if (mascaraSenha) {
                    par.ativeSenha('*');
                } else {
                    par.ativeSenha('\u00aa');
                }
                teclado.defineParametros(par, true);
            }
            catch (ExcecaoMascaraInvalida e1) {
                logger.error("mascara n\u00e3o foi v\u00e1lida.", (Throwable)e1);
            }
            return this.leDados(perifericos);
        }
        catch (ExcecaoPerifericos e) {
            throw new ExcecaoNaoLocal(e);
        }
    }

    @Override
    public void eventoPOSTef(EventoDispositivoEntrada event) {
        this.entradaDeDados.eventoOcorrido(event);
    }

    @Override
    public synchronized EventoDispositivoEntrada capturaPOSTef(LayoutDisplay layoutDisplay) throws ExcecaoNaoLocal {
        this.imprimeDisplay(layoutDisplay);
        try {
            this.getTeclado();
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            // empty catch block
        }
        return this.leDadosPOSTef();
    }

    @Override
    public int imprimeMenu(LayoutMenu layoutMenu) throws ExcecaoNaoLocal {
        EventoTeclado evTeclado = this.imprimeMenu(layoutMenu, new String[0], null);
        if (evTeclado.getTeclaFinalizadora().equals("VOLTA")) {
            return -1;
        }
        return Integer.parseInt(evTeclado.getStringLida());
    }

    @Override
    public EventoTeclado imprimeMenu(LayoutMenu layoutMenu, String[] mensagemCaptura, ConstantesApiAc.TipoCampo tipoCampo) throws ExcecaoNaoLocal {
        if (this.integracaoTranslator) {
            if (tipoCampo != null) {
                int i;
                LayoutDisplay layoutDisplay = new LayoutDisplay();
                if (layoutMenu.getTitulo() != null) {
                    for (i = 0; i < layoutMenu.getTitulo().length; ++i) {
                        layoutDisplay.addLinha(new Linha(layoutMenu.getTitulo()[i]));
                    }
                }
                if (layoutMenu.getItens() != null) {
                    for (i = 0; i < layoutMenu.getItens().size(); ++i) {
                        Linha linha = layoutMenu.getItens().get(i);
                        layoutDisplay.addLinha(new Linha(linha.getTexto()));
                    }
                }
                if (mensagemCaptura != null) {
                    for (i = 0; i < mensagemCaptura.length; ++i) {
                        layoutDisplay.addLinha(new Linha(mensagemCaptura[i]));
                    }
                }
                return (EventoTeclado)ControladorTranslator.getInstancia().capturaDado(layoutDisplay, tipoCampo, false, new long[]{1L}, this.entradaDeDados, null);
            }
            return ControladorTranslator.getInstancia().exibeMenu(layoutMenu);
        }
        if (this.isDisplayExterno()) {
            try {
                String[] teclasFinalizadoras = new String[]{"ENTRA", "VOLTA"};
                int opcao = 0;
                int opcaoVisivel = 1;
                while (opcao == 0) {
                    String navegacao = "";
                    if (opcaoVisivel == 1) {
                        navegacao = " [->]";
                        teclasFinalizadoras = new String[]{"ENTRA", "VOLTA", "TECLA_DIREITA"};
                    } else if (opcaoVisivel == layoutMenu.getItens().size()) {
                        navegacao = " [<-]";
                        teclasFinalizadoras = new String[]{"ENTRA", "VOLTA", "TECLA_ESQUERDA"};
                    } else {
                        navegacao = " [<- / ->]";
                        teclasFinalizadoras = new String[]{"ENTRA", "VOLTA", "TECLA_ESQUERDA", "TECLA_DIREITA"};
                    }
                    LayoutDisplay layoutDisplay = new LayoutDisplay();
                    if (layoutMenu.getTitulo() != null) {
                        layoutDisplay.addLinha(new Linha(layoutMenu.getTitulo()[0] + navegacao));
                    }
                    ItemMenu itemMenu = layoutMenu.getItens().get(opcaoVisivel - 1);
                    layoutDisplay.addLinha(new Linha(itemMenu.getTexto()));
                    tipoCampo = new ConstantesApiAc.TipoCampo(ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS.getCodigo(), ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS.getDescricao(), "Z");
                    EventoTeclado evt = (EventoTeclado)this.capturaDadoDisplayExterno(layoutDisplay, tipoCampo, teclasFinalizadoras);
                    if (evt.getTeclaFinalizadora().equals("TECLA_ESQUERDA")) {
                        if (opcaoVisivel <= 1) continue;
                        --opcaoVisivel;
                        continue;
                    }
                    if (evt.getTeclaFinalizadora().equals("TECLA_DIREITA")) {
                        if (opcaoVisivel >= layoutMenu.getItens().size()) continue;
                        ++opcaoVisivel;
                        continue;
                    }
                    if (evt.getTeclaFinalizadora().equals("ENTRA")) {
                        opcao = opcaoVisivel;
                        EventoTeclado eventoTeclado = new EventoTeclado(opcaoVisivel + "", "ENTRA", 1);
                        return eventoTeclado;
                    }
                    return evt;
                }
            }
            catch (Exception teclasFinalizadoras) {
                // empty catch block
            }
            return null;
        }
        String[] teclasFinalizadoras = null;
        if (layoutMenu.isHabilitaItemFinalizador()) {
            teclasFinalizadoras = new String[]{"VOLTA"};
        } else if (tipoCampo != null) {
            teclasFinalizadoras = new String[]{"VOLTA", "ENTRA"};
        }
        return this.imprimeMenuFisico(layoutMenu, mensagemCaptura, tipoCampo, teclasFinalizadoras);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EventoTeclado imprimeMenuFisico(LayoutMenu layoutMenu, String[] mensagemCaptura, ConstantesApiAc.TipoCampo tipoCampo, String[] teclasFinalizadoras) throws ExcecaoNaoLocal {
        this.limpaDisplay();
        String[] teclasNavegacao = new String[]{"TECLA_ESQUERDA", "TECLA_DIREITA"};
        String mascaraTeclado = "Z";
        List<ItemMenu> itensMenu = null;
        int totalPaginas = 0;
        int paginaAtual = 1;
        int qtdItensPagina = 0;
        int qtdItens = layoutMenu.getItens().size();
        int linhaMensagemCaptura = 13;
        int maximoItens1Pagina = 10;
        int maximoItensPagina = 10;
        int linhaEdicao = 14;
        if (layoutMenu.isHabilitaItemFinalizador()) {
            maximoItens1Pagina = 9;
            maximoItensPagina = 12;
        } else {
            if (tipoCampo != null) {
                mascaraTeclado = tipoCampo.getMascaraEdicao();
            }
            if (mensagemCaptura != null && mensagemCaptura.length > 1) {
                maximoItens1Pagina = maximoItensPagina -= mensagemCaptura.length - 1;
                linhaMensagemCaptura -= mensagemCaptura.length - 1;
                if (qtdItens < maximoItens1Pagina) {
                    linhaMensagemCaptura = layoutMenu.getTitulo().length + qtdItens + 1;
                }
            }
        }
        if (qtdItens > maximoItens1Pagina) {
            double x = Double.parseDouble(String.valueOf(qtdItens - maximoItens1Pagina)) / Double.parseDouble(String.valueOf(maximoItensPagina));
            totalPaginas = 1 + new BigDecimal(Math.ceil(x)).intValue();
        } else {
            totalPaginas = 1;
        }
        block3: while (true) {
            int i;
            int i2;
            if (paginaAtual >= 2) {
                qtdItensPagina = maximoItensPagina;
                int idxInicial = 0;
                int idxFinal = 0;
                if (layoutMenu.isHabilitaItemFinalizador()) {
                    mascaraTeclado = "ZZ";
                    idxInicial = maximoItens1Pagina + qtdItensPagina * (paginaAtual - 2);
                } else {
                    idxInicial = maximoItensPagina + qtdItensPagina * (paginaAtual - 2);
                }
                idxFinal = idxInicial + qtdItensPagina > qtdItens ? idxInicial + (qtdItens - idxInicial) : idxInicial + qtdItensPagina;
                itensMenu = layoutMenu.getItens().subList(idxInicial, idxFinal);
                qtdItensPagina = itensMenu.size();
            } else {
                if (layoutMenu.isHabilitaItemFinalizador()) {
                    mascaraTeclado = "Z";
                }
                qtdItensPagina = qtdItens < maximoItens1Pagina ? qtdItens : maximoItens1Pagina;
                itensMenu = layoutMenu.getItens().subList(0, qtdItensPagina);
            }
            ItemMenu[] arrayMenuItens = new ItemMenu[qtdItensPagina];
            String[] teclas = null;
            teclas = layoutMenu.isHabilitaItemFinalizador() ? new String[qtdItensPagina + (teclasFinalizadoras != null ? teclasFinalizadoras.length : 0) + teclasNavegacao.length] : new String[(teclasFinalizadoras != null ? teclasFinalizadoras.length : 0) + teclasNavegacao.length];
            for (int i3 = 0; i3 < teclasNavegacao.length; ++i3) {
                teclas[i3] = teclasNavegacao[i3];
            }
            if (teclasFinalizadoras != null) {
                int x = teclasNavegacao.length;
                for (i2 = 0; i2 < teclasFinalizadoras.length; ++i2, ++x) {
                    teclas[x] = teclasFinalizadoras[i2];
                }
            }
            int idxFinalizadoras = teclasNavegacao.length + (teclasFinalizadoras != null ? teclasFinalizadoras.length : 0);
            for (i2 = 0; i2 < itensMenu.size(); ++i2, ++idxFinalizadoras) {
                ItemMenu item = itensMenu.get(i2);
                if (layoutMenu.isHabilitaItemFinalizador()) {
                    teclas[idxFinalizadoras] = item.getTeclaFinalizadora();
                }
                arrayMenuItens[i2] = item;
            }
            Teclado teclado = null;
            boolean autoSkip = layoutMenu.isHabilitaItemFinalizador();
            ParametrosEdicaoTeclado param = new ParametrosEdicaoTeclado(true, false, true, mascaraTeclado, linhaEdicao, 0, ",", ".", autoSkip, "", 0, 0, "", teclas, true);
            teclado = this.getTeclado();
            teclado.defineParametros(param, true);
            this.limpaDisplay();
            Display display = this.getDisplay();
            for (int i4 = 0; i4 < layoutMenu.getTitulo().length; ++i4) {
                display.imprimeEm(i4, 0, layoutMenu.getTitulo()[i4]);
            }
            int linha = layoutMenu.getTitulo().length;
            for (i = 0; i < arrayMenuItens.length; ++i, ++linha) {
                String opcao = "";
                ItemMenu item = arrayMenuItens[i];
                if (layoutMenu.isHabilitaItemFinalizador()) {
                    opcao = "[" + item.getTeclaFinalizadora() + "] - ";
                }
                opcao = opcao + item.getTexto();
                display.imprimeEm(linha, item.getColuna(), opcao);
            }
            if (totalPaginas > 1) {
                if (paginaAtual == 1) {
                    display.imprimeEm(14, 0, "                           MAIS ->");
                } else if (paginaAtual == totalPaginas) {
                    display.imprimeEm(14, 0, "<- VOLTAR                         ");
                } else {
                    display.imprimeEm(14, 0, "<- VOLTAR                  MAIS ->");
                }
            }
            if (mensagemCaptura != null) {
                int length = mensagemCaptura.length > 3 ? 3 : mensagemCaptura.length;
                for (int i5 = 0; i5 < length; ++i5) {
                    display.imprimeEm(linhaMensagemCaptura + i5, 0, mensagemCaptura[i5]);
                }
            }
            EventoTeclado ev = (EventoTeclado)this.leDados(new long[]{1L});
            this.limpaDisplay();
            i = 0;
            while (i < teclas.length) {
                if (ev.getTeclaFinalizadora().equals("VOLTA")) {
                    return ev;
                }
                if (ev.getTeclaFinalizadora().equals("TECLA_ESQUERDA")) {
                    if (paginaAtual - 1 < 1) continue block3;
                    --paginaAtual;
                    continue block3;
                }
                if (ev.getTeclaFinalizadora().equals("TECLA_DIREITA")) {
                    if (paginaAtual + 1 > totalPaginas) continue block3;
                    ++paginaAtual;
                    continue block3;
                }
                if (!layoutMenu.isHabilitaItemFinalizador()) return ev;
                if (teclas[i].equals(ev.getStringLida())) {
                    return ev;
                }
                ++i;
            }
            return this.imprimeMenuFisico(layoutMenu, mensagemCaptura, tipoCampo, teclasFinalizadoras);
            break;
        }
        catch (ExcecaoMascaraInvalida e) {
            logger.warn("Erro em ControladorPerifericosDefault.imprimeMenuFisico: " + e.getMessage());
            return this.imprimeMenuFisico(layoutMenu, mensagemCaptura, tipoCampo, teclasFinalizadoras);
        }
        catch (ExcecaoPerifericos e) {
            throw new ExcecaoNaoLocal(e);
        }
    }

    @Override
    public int exibeMenuCancelamento() throws ExcecaoNaoLocal {
        int opcao = 0;
        do {
            if (this.isDisplayExterno()) {
                LayoutDisplay layoutDisplay = new LayoutDisplay("OPERACAO CANCELADA? 1-SIM / 2-NAO");
                ConstantesApiAc.TipoCampo tipoCampo = new ConstantesApiAc.TipoCampo(ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS.getCodigo(), ConstantesApiAc.CAP_INFORMACOES_ADICIONAIS.getDescricao(), "Z");
                String[] teclasFinalizadoras = new String[]{"ENTRA", "VOLTA", "1", "2"};
                EventoTeclado evt = (EventoTeclado)this.capturaDado(layoutDisplay, tipoCampo, teclasFinalizadoras);
                int num = evt.getStringLida().length() - evt.getNumCaracteresDigitados();
                String dadoDigitado = evt.getStringLida().substring(num);
                try {
                    opcao = Integer.parseInt(dadoDigitado);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            LayoutMenu layoutMenu = new LayoutMenu(MSG_DISPLAY, true);
            layoutMenu.addItem(new ItemMenu("SIM", "1"));
            layoutMenu.addItem(new ItemMenu("NAO", "2"));
            EventoTeclado eventoTeclado = null;
            if (this.integracaoTranslator) {
                eventoTeclado = ControladorTranslator.getInstancia().exibeMenu(layoutMenu);
                if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                    opcao = -1;
                    continue;
                }
                opcao = Integer.parseInt(eventoTeclado.getStringLida());
                continue;
            }
            opcao = this.imprimeMenu(layoutMenu);
        } while (opcao != 1 && opcao != 2);
        return opcao;
    }

    protected EventoDispositivoEntrada leDados(long[] perifericos) throws ExcecaoNaoLocal {
        EventoDispositivoEntrada evento = null;
        try {
            evento = this.entradaDeDados.leValor(perifericos);
        }
        catch (ExcecaoValorInvalido e) {
            throw new ExcecaoNaoLocal(e);
        }
        return evento;
    }

    public EventoDispositivoEntrada leDadosPOSTef() throws ExcecaoNaoLocal {
        EventoDispositivoEntrada evento = null;
        try {
            long[] perifericos = new long[]{1L};
            evento = this.entradaDeDados.leValor(perifericos);
        }
        catch (ExcecaoValorInvalido e) {
            throw new ExcecaoNaoLocal(e);
        }
        return evento;
    }

    @Override
    public void limpaDisplay() throws ExcecaoNaoLocal {
        if (this.integracaoTranslator) {
            ControladorTranslator.getInstancia().limpaDisplay();
        } else {
            while (this.displayLocked) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.limpaDisplayIgnorandoLock();
        }
    }

    private void limpaDisplayIgnorandoLock() throws ExcecaoNaoLocal {
        try {
            Display displayOperador = this.getDisplay();
            displayOperador.limpa();
            displayOperador.posicionaCursor(0, 0);
            if (this.isDisplayExterno()) {
                Display display = this.getDisplayOperador();
                display.limpa();
                display.posicionaCursor(0, 0);
            }
        }
        catch (ExcecaoPerifericos e) {
            throw new ExcecaoNaoLocal(e);
        }
    }

    @Override
    public void liberarRecursos() throws ExcecaoPerifericos {
        this.liberarRecursos(true);
    }

    @Override
    public void liberarRecursos(boolean liberaBBComp) throws ExcecaoPerifericos {
        Display display;
        if (this.configuracaoPerifericos.perifericoCarregado("com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad")) {
            logger.debug("liberando driver pinpad");
            if (this.entradaDeDados.getPin() != null) {
                this.entradaDeDados.desabilitaPin();
                this.entradaDeDados.setPin(null);
            }
            BibliotecaPinpad pinEMV = (BibliotecaPinpad)this.configuracaoPerifericos.getPerifericoPin();
            pinEMV.liberaRecursos(liberaBBComp);
            if (liberaBBComp) {
                this.configuracaoPerifericos.liberaPeriferico("com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad");
            }
            logger.debug("driver pinpad liberado");
        }
        if (this.configuracaoPerifericos.perifericoCarregado("com.csi.ctfclient.tools.devices.LeitorCartaoHandler")) {
            logger.debug("liberando driver leitor cart\u00e3o");
            if (this.entradaDeDados.getLeitorCartao() != null) {
                this.entradaDeDados.desabilitaLeitorCartao();
                this.entradaDeDados.setLeitorCartao(null);
            }
            ILeitorCartaoHandler cartaohandler = this.configuracaoPerifericos.getPerifericoLeitorCartao();
            cartaohandler.liberaRecursos();
            this.configuracaoPerifericos.liberaPeriferico("com.csi.ctfclient.tools.devices.LeitorCartaoHandler");
            logger.debug("driver leitor cart\u00e3o liberado");
        }
        if (this.configuracaoPerifericos.perifericoCarregado("DRIVER_LEITOR_DOCUMENTO")) {
            logger.debug("liberando driver leitor documento");
            if (this.entradaDeDados.getLeitorDocumento() != null) {
                this.entradaDeDados.desabilitaLeitorDocumento();
                this.entradaDeDados.setLeitorDocumento(null);
            }
            LeitorDocumento leitorDocumento = this.configuracaoPerifericos.getPerifericoLeitorDocumento();
            leitorDocumento.liberaRecursos();
            this.configuracaoPerifericos.liberaPeriferico("DRIVER_LEITOR_DOCUMENTO");
            logger.debug("driver leitor documento liberado");
        }
        if (this.configuracaoPerifericos.perifericoCarregado("DRIVER_SCANNER")) {
            logger.debug("liberando driver scanner");
            if (this.entradaDeDados.getScanner() != null) {
                this.entradaDeDados.desabilitaScanner();
                this.entradaDeDados.setScanner(null);
            }
            Scanner scanner = this.configuracaoPerifericos.getPerifericoScanner();
            scanner.liberaRecursos();
            this.configuracaoPerifericos.liberaPeriferico("DRIVER_SCANNER");
            logger.debug("driver leitor scanner liberado");
        }
        if (this.configuracaoPerifericos.perifericoCarregado("DRIVER_TECLADO")) {
            logger.debug("liberando driver teclado");
            if (this.entradaDeDados.getTeclado() != null) {
                this.entradaDeDados.desabilitaTeclado();
                this.entradaDeDados.setTeclado(null);
            }
            Teclado teclado = this.configuracaoPerifericos.getPerifericoTeclado();
            teclado.removeDisplayEco(this.configuracaoPerifericos.getPerifericoDisplayCliente());
            teclado.desabilita();
            teclado.liberaRecursos();
            this.configuracaoPerifericos.liberaPeriferico("DRIVER_TECLADO");
            logger.debug("driver leitor teclado liberado");
        }
        if (this.configuracaoPerifericos.perifericoCarregado("DRIVER_DISPLAY_CLIENTE")) {
            logger.debug("liberando driver display cliente");
            display = this.configuracaoPerifericos.getPerifericoDisplayCliente();
            display.liberaRecursos();
            this.configuracaoPerifericos.liberaPeriferico("DRIVER_DISPLAY_CLIENTE");
            logger.debug("driver display cliente liberado");
        }
        if (this.configuracaoPerifericos.perifericoCarregado("DRIVER_DISPLAY_OPERADOR")) {
            logger.debug("liberando driver display operador");
            display = this.configuracaoPerifericos.getPerifericoDisplayOperador();
            display.limpa();
            display.liberaRecursos();
            this.configuracaoPerifericos.liberaPeriferico("DRIVER_DISPLAY_OPERADOR");
            logger.debug("driver display operador liberado");
        }
        if (!this.integracaoTranslator) {
            this.getTelaPrincipal().setVisible(false);
        }
        if (!ControladorFusion.getInstancia().isClosed()) {
            logger.debug("liberando controlador fusion");
            ControladorFusion.getInstancia().fecharSocket();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("CTFClient -> visible = false");
        }
    }

    @Override
    public void liberarRecursosPinCartao() throws ExcecaoPerifericos {
        if (this.configuracaoPerifericos.perifericoCarregado("com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad")) {
            if (this.entradaDeDados.getPin() != null) {
                this.entradaDeDados.desabilitaPin();
                this.entradaDeDados.setPin(null);
            }
            PinEMV pinEMV = this.configuracaoPerifericos.getPerifericoPin();
            pinEMV.liberaRecursos();
            this.configuracaoPerifericos.liberaPeriferico("com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad");
        }
        if (this.configuracaoPerifericos.perifericoCarregado("com.csi.ctfclient.tools.devices.LeitorCartaoHandler")) {
            if (this.entradaDeDados.getLeitorCartao() != null) {
                this.entradaDeDados.desabilitaLeitorCartao();
                this.entradaDeDados.setLeitorCartao(null);
            }
            ILeitorCartaoHandler cartaoHandler = this.configuracaoPerifericos.getPerifericoLeitorCartao();
            cartaoHandler.liberaRecursos();
            this.configuracaoPerifericos.liberaPeriferico("com.csi.ctfclient.tools.devices.LeitorCartaoHandler");
        }
    }

    @Override
    public boolean perifericoCarregado(String valor) {
        return this.configuracaoPerifericos.perifericoCarregado(valor);
    }
}

