/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.action;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.operacoes.Action;
import com.csi.ctfclient.operacoes.ActionForward;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessConstructorArguments;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicCapturaBairro;
import com.csi.ctfclient.operacoes.microoperacoes.MicCapturaBloco;
import com.csi.ctfclient.operacoes.microoperacoes.MicCapturaCep;
import com.csi.ctfclient.operacoes.microoperacoes.MicCapturaCnpj;
import com.csi.ctfclient.operacoes.microoperacoes.MicCapturaCodigoSeguranca;
import com.csi.ctfclient.operacoes.microoperacoes.MicCapturaComplemento;
import com.csi.ctfclient.operacoes.microoperacoes.MicCapturaCpf;
import com.csi.ctfclient.operacoes.microoperacoes.MicCapturaEndereco;
import com.csi.ctfclient.operacoes.microoperacoes.MicCapturaNumero;
import com.csi.ctfclient.operacoes.microoperacoes.MicCapturaRg;
import com.csi.ctfclient.operacoes.microoperacoes.MicCapturaTelefoneFixo;
import com.csi.ctfclient.operacoes.microoperacoes.MicCapturaTelefoneMovel;
import com.csi.ctfclient.operacoes.microoperacoes.MicEnvio1FConsultaAvs;
import com.csi.ctfclient.operacoes.microoperacoes.MicExibeRespostaAvs;
import com.csi.ctfclient.operacoes.microoperacoes.MicJoinCapturaTipoDocumento;
import com.csi.ctfclient.operacoes.microoperacoes.MicSolicitacaoConsultaAvs;
import com.csi.ctfclient.operacoes.microoperacoes.MicSubProcessLeituraCartao;
import com.csi.ctfclient.operacoes.microoperacoes.MicVencimentoCartao;
import com.csi.ctfclient.operacoes.microoperacoes.MicVerificaComunicacaoCTF;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import java.math.BigDecimal;

public class ProcessConsultaAvs
extends Process {
    public ProcessConsultaAvs(ProcessConstructorArguments args) {
        super(args);
        Contexto.getContexto().setTipoOperacao(OperationEnum.OP_CONSULTA_AVS.getDescription());
    }

    public ProcessConsultaAvs(ProcessConstructorArguments args, EntradaCTFClientCtrl entradaIntegracao) {
        super(args);
        Contexto.getContexto().setTipoOperacao(OperationEnum.OP_CONSULTA_AVS.getDescription());
        Contexto.getContexto().setEntradaIntegracao(entradaIntegracao);
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaIntegracao != null) {
            entradaApiTefC.setNumeroTransacao(entradaIntegracao.getNumeroTransacao());
            entradaApiTefC.setIdentificacaoTransacao(entradaIntegracao.getCodigoOrigemTransacao());
        }
        entradaApiTefC.setValorTransacao(new BigDecimal(1));
    }

    public ProcessConsultaAvs(ProcessConstructorArguments args, int numeroTransacao) {
        super(args);
        Contexto.getContexto().setTipoOperacao(OperationEnum.OP_CONSULTA_AVS.getDescription());
        Contexto.getContexto().getEntradaApiTefC().setNumeroTransacao(numeroTransacao);
        Contexto.getContexto().getEntradaApiTefC().setValorTransacao(new BigDecimal(1));
    }

    @Override
    public void initialize() {
        this.setKey("623");
        this.setDescription("Consulta AVS");
        Action subProcessLeituraCartao = new Action("subProcessLeituraCartao", MicSubProcessLeituraCartao.class);
        subProcessLeituraCartao.addActionForward(new ActionForward("SUCESS", "solicita1F"));
        subProcessLeituraCartao.addActionForward(new ActionForward("FILLED", "solicita1F"));
        subProcessLeituraCartao.addActionForward(new ActionForward("USERCANCEL", 5));
        subProcessLeituraCartao.addActionForward(new ActionForward("USERCANCEL_INTERNAL", 5));
        subProcessLeituraCartao.addActionForward(new ActionForward("ERRO", 1));
        this.addAction(subProcessLeituraCartao);
        Action solicita1F = new Action("solicita1F", MicEnvio1FConsultaAvs.class);
        solicita1F.addActionForward(new ActionForward("SUCESS", "verificaVencimento"));
        solicita1F.addActionForward(new ActionForward("ERRO", "verificaComunicao1F"));
        solicita1F.addActionForward(new ActionForward("SOLICITA_CARGA_TABELA", "subProcessLeituraCartao"));
        this.addAction(solicita1F);
        Action verificaComunicao1F = new Action("verificaComunicao1F", MicVerificaComunicacaoCTF.class);
        verificaComunicao1F.addActionForward(new ActionForward("SUCESS", "verificaVencimento"));
        verificaComunicao1F.addActionForward(new ActionForward("ERRO", "subProcessLeituraCartao"));
        verificaComunicao1F.addActionForward(new ActionForward("ERRO_RETURN_AC", 6));
        this.addAction(verificaComunicao1F);
        Action verificaVencimento = new Action("verificaVencimento", MicVencimentoCartao.class);
        verificaVencimento.addActionForward(new ActionForward("SUCESS", "capturaCodigoSeguranca"));
        verificaVencimento.addActionForward(new ActionForward("FILLED", "capturaCodigoSeguranca"));
        verificaVencimento.addActionForward(new ActionForward("UNECESSARY", "capturaCodigoSeguranca"));
        verificaVencimento.addActionForward(new ActionForward("USERCANCEL", 3));
        verificaVencimento.addActionForward(new ActionForward("ERRO_INVALID_DATA", "verificaVencimento"));
        verificaVencimento.addActionForward(new ActionForward("ERRO_INVALID_DATA_AC", 6));
        verificaVencimento.addActionForward(new ActionForward("ERRO_INVALID_DATA_21YEAR", "subProcessLeituraCartao"));
        verificaVencimento.addActionForward(new ActionForward("ERRO_INVALID_DATA_21YEAR_AC", 6));
        this.addAction(verificaVencimento);
        Action capturaCodigoSeguranca = new Action("capturaCodigoSeguranca", MicCapturaCodigoSeguranca.class);
        capturaCodigoSeguranca.addActionForward(new ActionForward("FILLED", "capturaEndereco"));
        capturaCodigoSeguranca.addActionForward(new ActionForward("SUCESS", "capturaEndereco"));
        capturaCodigoSeguranca.addActionForward(new ActionForward("INVALID_LENGTH", "capturaCodigoSeguranca"));
        capturaCodigoSeguranca.addActionForward(new ActionForward("INVALID_LENGTH_AC", 6));
        capturaCodigoSeguranca.addActionForward(new ActionForward("ERRO_IS_REQUIRED", "capturaCodigoSeguranca"));
        capturaCodigoSeguranca.addActionForward(new ActionForward("USERCANCEL", 3));
        capturaCodigoSeguranca.addActionForward(new ActionForward("USERCANCEL_MOTIVO", "capturaCodigoSeguranca"));
        this.addAction(capturaCodigoSeguranca);
        Action capturaEndereco = new Action("capturaEndereco", MicCapturaEndereco.class);
        capturaEndereco.addActionForward(new ActionForward("SUCESS", "capturaNumero"));
        capturaEndereco.addActionForward(new ActionForward("FILLED", "capturaNumero"));
        capturaEndereco.addActionForward(new ActionForward("USER_CANCEL", 3));
        this.addAction(capturaEndereco);
        Action capturaNumero = new Action("capturaNumero", MicCapturaNumero.class);
        capturaNumero.addActionForward(new ActionForward("SUCESS", "capturaComplemento"));
        capturaNumero.addActionForward(new ActionForward("FILLED", "capturaComplemento"));
        capturaNumero.addActionForward(new ActionForward("USER_CANCEL", 3));
        this.addAction(capturaNumero);
        Action capturaComplemento = new Action("capturaComplemento", MicCapturaComplemento.class);
        capturaComplemento.addActionForward(new ActionForward("SUCESS", "capturaBloco"));
        capturaComplemento.addActionForward(new ActionForward("FILLED", "capturaBloco"));
        capturaComplemento.addActionForward(new ActionForward("USER_CANCEL", 3));
        this.addAction(capturaComplemento);
        Action capturaBloco = new Action("capturaBloco", MicCapturaBloco.class);
        capturaBloco.addActionForward(new ActionForward("SUCESS", "capturaCep"));
        capturaBloco.addActionForward(new ActionForward("FILLED", "capturaCep"));
        capturaBloco.addActionForward(new ActionForward("USER_CANCEL", 3));
        this.addAction(capturaBloco);
        Action capturaCep = new Action("capturaCep", MicCapturaCep.class);
        capturaCep.addActionForward(new ActionForward("SUCESS", "capturaBairro"));
        capturaCep.addActionForward(new ActionForward("FILLED", "capturaBairro"));
        capturaCep.addActionForward(new ActionForward("USER_CANCEL", 3));
        this.addAction(capturaCep);
        Action capturaBairro = new Action("capturaBairro", MicCapturaBairro.class);
        capturaBairro.addActionForward(new ActionForward("SUCESS", "joinTipoDocumento"));
        capturaBairro.addActionForward(new ActionForward("FILLED", "joinTipoDocumento"));
        capturaBairro.addActionForward(new ActionForward("USER_CANCEL", 3));
        this.addAction(capturaBairro);
        Action joinTipoDocumento = new Action("joinTipoDocumento", MicJoinCapturaTipoDocumento.class);
        joinTipoDocumento.addActionForward(new ActionForward("SUCESS_CPF", "capturaCpf"));
        joinTipoDocumento.addActionForward(new ActionForward("SUCESS_CNPJ", "capturaCnpj"));
        joinTipoDocumento.addActionForward(new ActionForward("ERROR", 1));
        this.addAction(joinTipoDocumento);
        Action capturaCpf = new Action("capturaCpf", MicCapturaCpf.class);
        capturaCpf.addActionForward(new ActionForward("SUCCESS", "capturaRg"));
        capturaCpf.addActionForward(new ActionForward("FILLED", "capturaRg"));
        capturaCpf.addActionForward(new ActionForward("UNNECESSARY", "capturaRg"));
        capturaCpf.addActionForward(new ActionForward("USER_CANCEL", 3));
        capturaCpf.addActionForward(new ActionForward("INVALID_CPF", "capturaCpf"));
        capturaCpf.addActionForward(new ActionForward("INVALID_CPF_AC", 6));
        this.addAction(capturaCpf);
        Action capturaCnpj = new Action("capturaCnpj", MicCapturaCnpj.class);
        capturaCnpj.addActionForward(new ActionForward("SUCESS", "capturaRg"));
        capturaCnpj.addActionForward(new ActionForward("FILLED", "capturaRg"));
        capturaCnpj.addActionForward(new ActionForward("INVALID_CNPJ", "capturaCnpj"));
        capturaCnpj.addActionForward(new ActionForward("USER_CANCEL", 3));
        capturaCnpj.addActionForward(new ActionForward("INVALID_CNPJ_AC", 6));
        this.addAction(capturaCnpj);
        Action capturaRg = new Action("capturaRg", MicCapturaRg.class);
        capturaRg.addActionForward(new ActionForward("SUCCESS", "capturaTelefoneFixo"));
        capturaRg.addActionForward(new ActionForward("FILLED", "capturaTelefoneFixo"));
        capturaRg.addActionForward(new ActionForward("NOT_REQUIRED", "capturaTelefoneFixo"));
        capturaRg.addActionForward(new ActionForward("USER_CANCEL", 3));
        this.addAction(capturaRg);
        Action capturaTelefoneFixo = new Action("capturaTelefoneFixo", MicCapturaTelefoneFixo.class);
        capturaTelefoneFixo.addActionForward(new ActionForward("SUCCESS", "capturaTelefoneMovel"));
        capturaTelefoneFixo.addActionForward(new ActionForward("FILLED", "capturaTelefoneMovel"));
        capturaTelefoneFixo.addActionForward(new ActionForward("NOT_REQUIRED", "capturaTelefoneMovel"));
        capturaTelefoneFixo.addActionForward(new ActionForward("USER_CANCEL", 3));
        this.addAction(capturaTelefoneFixo);
        Action capturaTelefoneMovel = new Action("capturaTelefoneMovel", MicCapturaTelefoneMovel.class);
        capturaTelefoneMovel.addActionForward(new ActionForward("SUCCESS", "solicitacaoConsultaAvs"));
        capturaTelefoneMovel.addActionForward(new ActionForward("FILLED", "solicitacaoConsultaAvs"));
        capturaTelefoneMovel.addActionForward(new ActionForward("NOT_REQUIRED", "solicitacaoConsultaAvs"));
        capturaTelefoneMovel.addActionForward(new ActionForward("USER_CANCEL", 3));
        this.addAction(capturaTelefoneMovel);
        Action solicitacaoConsultaAvs = new Action("solicitacaoConsultaAvs", MicSolicitacaoConsultaAvs.class);
        solicitacaoConsultaAvs.addActionForward(new ActionForward("SUCESS", "verificaComunicaoSolicitacao"));
        solicitacaoConsultaAvs.addActionForward(new ActionForward("ERROR", "verificaComunicaoSolicitacao"));
        this.addAction(solicitacaoConsultaAvs);
        Action verificaComunicaoSolicitacao = new Action("verificaComunicaoSolicitacao", MicVerificaComunicacaoCTF.class);
        verificaComunicaoSolicitacao.addActionForward(new ActionForward("SUCESS", "micExibeRespostaAvs"));
        verificaComunicaoSolicitacao.addActionForward(new ActionForward("ERRO", 6));
        this.addAction(verificaComunicaoSolicitacao);
        Action micExibeRespostaAvs = new Action("exibeRespostaAvs", MicExibeRespostaAvs.class);
        verificaComunicaoSolicitacao.addActionForward(new ActionForward("SUCESS", 0));
        this.addAction(micExibeRespostaAvs);
        this.setStartKeyAction("subProcessLeituraCartao");
    }
}

