/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.action;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.operacoes.Action;
import com.csi.ctfclient.operacoes.ActionForward;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessConstructorArguments;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicCapturaDDD;
import com.csi.ctfclient.operacoes.microoperacoes.MicCapturaDigitoVerificadorTelefone;
import com.csi.ctfclient.operacoes.microoperacoes.MicCapturaNumeroParcela;
import com.csi.ctfclient.operacoes.microoperacoes.MicCapturaOperadoraTelefonia;
import com.csi.ctfclient.operacoes.microoperacoes.MicCapturaTelefone;
import com.csi.ctfclient.operacoes.microoperacoes.MicCapturaTelefonePin;
import com.csi.ctfclient.operacoes.microoperacoes.MicCapturaTipoFinanciamentoCreditoCelular;
import com.csi.ctfclient.operacoes.microoperacoes.MicCapturaTipoInformacaoPortadorTelefone;
import com.csi.ctfclient.operacoes.microoperacoes.MicEnvio1FCreditoCelular;
import com.csi.ctfclient.operacoes.microoperacoes.MicExecutaConsultaOperadoras;
import com.csi.ctfclient.operacoes.microoperacoes.MicExibeConfirmacaoTelefone;
import com.csi.ctfclient.operacoes.microoperacoes.MicJoinFormaCapturaTelefone;
import com.csi.ctfclient.operacoes.microoperacoes.MicLeituraValor;
import com.csi.ctfclient.operacoes.microoperacoes.MicSolicitacaoCreditoCelular;
import com.csi.ctfclient.operacoes.microoperacoes.MicVerificaComunicacaoCTF;
import com.csi.ctfclient.operacoes.microoperacoes.MicVerificaConsultaOperadoras;
import com.csi.ctfclient.operacoes.microoperacoes.MicVerificaExecucaoConsulta;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import java.math.BigDecimal;

public class ProcessCreditoCelular
extends Process {
    public ProcessCreditoCelular(ProcessConstructorArguments args, EntradaCTFClientCtrl entradaIntegracao, int numeroTransacao) {
        this(args, numeroTransacao, entradaIntegracao.getValorTransacao());
        Contexto.getContexto().setEntradaIntegracao(entradaIntegracao);
        Contexto.getContexto().getEntradaApiTefC().setNumeroCupom(entradaIntegracao.getNumeroCupom());
    }

    public ProcessCreditoCelular(ProcessConstructorArguments args, int numeroTransacao, BigDecimal valorTransacao) {
        super(args);
        Contexto.getContexto().setTipoOperacao(OperationEnum.OP_CREDITO_CELULAR_AVISTA.getDescription());
        Contexto.getContexto().setTipoOperadora("4");
        Contexto.getContexto().getEntradaApiTefC().setNumeroTransacao(numeroTransacao);
        Contexto.getContexto().getEntradaApiTefC().setValorTransacao(valorTransacao);
    }

    @Override
    public void initialize() {
        this.setKey("232");
        this.setDescription("Cr\u00e9dito celular");
        Action leituraValor = new Action("leituraValor", MicLeituraValor.class);
        leituraValor.addActionForward(new ActionForward("SUCESS", "verificaConsultaOperadoras"));
        leituraValor.addActionForward(new ActionForward("FILLED", "verificaConsultaOperadoras"));
        leituraValor.addActionForward(new ActionForward("INVALID_NUMBER", "leituraValor"));
        leituraValor.addActionForward(new ActionForward("ERROR_AC", 6));
        leituraValor.addActionForward(new ActionForward("USERCANCEL", 3));
        this.addAction(leituraValor);
        Action verificaConsultaOperadoras = new Action("verificaConsultaOperadoras", MicVerificaConsultaOperadoras.class);
        verificaConsultaOperadoras.addActionForward(new ActionForward("REQUIRED", "executaConsultaOperadoras"));
        verificaConsultaOperadoras.addActionForward(new ActionForward("NOT_REQUIRED", "capturaOperadoraTelefonia"));
        this.addAction(verificaConsultaOperadoras);
        Action executaConsultaOperadoras = new Action("executaConsultaOperadoras", MicExecutaConsultaOperadoras.class);
        executaConsultaOperadoras.addActionForward(new ActionForward("SUCCESS", "capturaOperadoraTelefonia"));
        executaConsultaOperadoras.addActionForward(new ActionForward("ERROR", "verificaComunicacaoConsultaOperadoras"));
        this.addAction(executaConsultaOperadoras);
        Action verificaComunicacaoConsultaOperadoras = new Action("verificaComunicacaoConsultaOperadoras", MicVerificaComunicacaoCTF.class);
        verificaComunicacaoConsultaOperadoras.addActionForward(new ActionForward("ERRO", 6));
        verificaComunicacaoConsultaOperadoras.addActionForward(new ActionForward("ERRO_RETURN_AC", 6));
        this.addAction(verificaComunicacaoConsultaOperadoras);
        Action capturaOperadoraTelefonia = new Action("capturaOperadoraTelefonia", MicCapturaOperadoraTelefonia.class);
        capturaOperadoraTelefonia.addActionForward(new ActionForward("SUCCESS", "solicita1F"));
        capturaOperadoraTelefonia.addActionForward(new ActionForward("FILLED", "solicita1F"));
        capturaOperadoraTelefonia.addActionForward(new ActionForward("USER_CANCEL", 3));
        this.addAction(capturaOperadoraTelefonia);
        Action solicita1F = new Action("solicita1F", MicEnvio1FCreditoCelular.class);
        solicita1F.addActionForward(new ActionForward("SUCESS", "verificaConsulta"));
        solicita1F.addActionForward(new ActionForward("UNECESSARY", "verificaConsulta"));
        solicita1F.addActionForward(new ActionForward("ERRO", "verificaComunicao1F"));
        this.addAction(solicita1F);
        Action verificaComunicao1F = new Action("verificaComunicao1F", MicVerificaComunicacaoCTF.class);
        verificaComunicao1F.addActionForward(new ActionForward("SUCESS", "verificaConsulta"));
        verificaComunicao1F.addActionForward(new ActionForward("ERRO", 1));
        verificaComunicao1F.addActionForward(new ActionForward("ERRO_RETURN_AC", 6));
        this.addAction(verificaComunicao1F);
        Action verificaConsulta = new Action("verificaConsulta", MicVerificaExecucaoConsulta.class);
        verificaConsulta.addActionForward(new ActionForward("IS_SEARCH", 0));
        verificaConsulta.addActionForward(new ActionForward("IS_NOT_SEARCH", "capturaTipoInformacaoPortadorTelefone"));
        this.addAction(verificaConsulta);
        Action capturaTipoInformacaoPortadorTelefone = new Action("capturaTipoInformacaoPortadorTelefone", MicCapturaTipoInformacaoPortadorTelefone.class);
        capturaTipoInformacaoPortadorTelefone.addActionForward(new ActionForward("SUCCESS_TELEFONE", "joinFormaCapturaTelefone"));
        capturaTipoInformacaoPortadorTelefone.addActionForward(new ActionForward("SUCCESS_CPF", 1));
        capturaTipoInformacaoPortadorTelefone.addActionForward(new ActionForward("USER_CANCEL", 3));
        this.addAction(capturaTipoInformacaoPortadorTelefone);
        Action joinFormaCapturaTelefone = new Action("joinFormaCapturaTelefone", MicJoinFormaCapturaTelefone.class);
        joinFormaCapturaTelefone.addActionForward(new ActionForward("SUCCESS_PINPAD", "capturaTelefonePin"));
        joinFormaCapturaTelefone.addActionForward(new ActionForward("SUCCESS_TECLADO", "capturaDDD"));
        joinFormaCapturaTelefone.addActionForward(new ActionForward("ERROR", 1));
        this.addAction(joinFormaCapturaTelefone);
        Action capturaDDD = new Action("capturaDDD", MicCapturaDDD.class);
        capturaDDD.addActionForward(new ActionForward("SUCESS", "capturaTelefone"));
        capturaDDD.addActionForward(new ActionForward("SUCESS_BLANK", "capturaDDD"));
        capturaDDD.addActionForward(new ActionForward("FILLED", "capturaTelefone"));
        capturaDDD.addActionForward(new ActionForward("USER_CANCEL", 3));
        this.addAction(capturaDDD);
        Action capturaTelefone = new Action("capturaTelefone", MicCapturaTelefone.class);
        capturaTelefone.addActionForward(new ActionForward("SUCESS", "calturaDigitoVerificadorTelefone"));
        capturaTelefone.addActionForward(new ActionForward("FILLED", "calturaDigitoVerificadorTelefone"));
        capturaTelefone.addActionForward(new ActionForward("USER_CANCEL", 3));
        this.addAction(capturaTelefone);
        Action capturaTelefonePin = new Action("capturaTelefonePin", MicCapturaTelefonePin.class);
        capturaTelefonePin.addActionForward(new ActionForward("SUCESS", "calturaDigitoVerificadorTelefone"));
        capturaTelefonePin.addActionForward(new ActionForward("FILLED", "calturaDigitoVerificadorTelefone"));
        capturaTelefonePin.addActionForward(new ActionForward("ERROR", 1));
        capturaTelefonePin.addActionForward(new ActionForward("USER_CANCEL", 3));
        capturaTelefonePin.addActionForward(new ActionForward("USER_CANCEL_INTERNAL", 5));
        capturaTelefonePin.addActionForward(new ActionForward("INVALID_CONFIRMATION", "capturaTelefonePin"));
        capturaTelefonePin.addActionForward(new ActionForward("INVALID_TELEPHONE", "capturaTelefonePin"));
        this.addAction(capturaTelefonePin);
        Action calturaDigitoVerificadorTelefone = new Action("calturaDigitoVerificadorTelefone", MicCapturaDigitoVerificadorTelefone.class);
        calturaDigitoVerificadorTelefone.addActionForward(new ActionForward("SUCESS", "exibeConfirmacaoTelefone"));
        calturaDigitoVerificadorTelefone.addActionForward(new ActionForward("FILLED", "exibeConfirmacaoTelefone"));
        calturaDigitoVerificadorTelefone.addActionForward(new ActionForward("UNNECESSARY", "exibeConfirmacaoTelefone"));
        this.addAction(calturaDigitoVerificadorTelefone);
        Action exibeConfirmacaoTelefone = new Action("exibeConfirmacaoTelefone", MicExibeConfirmacaoTelefone.class);
        exibeConfirmacaoTelefone.addActionForward(new ActionForward("SUCESS", "tipoFinanciamento"));
        exibeConfirmacaoTelefone.addActionForward(new ActionForward("UNNECESSARY", "tipoFinanciamento"));
        exibeConfirmacaoTelefone.addActionForward(new ActionForward("CONFIRM_AGAIN", "exibeConfirmacaoTelefone"));
        exibeConfirmacaoTelefone.addActionForward(new ActionForward("ERROR", 1));
        exibeConfirmacaoTelefone.addActionForward(new ActionForward("USER_CANCEL", "joinFormaCapturaTelefone"));
        exibeConfirmacaoTelefone.addActionForward(new ActionForward("USER_CANCEL_INTERNAL", "joinFormaCapturaTelefone"));
        exibeConfirmacaoTelefone.addActionForward(new ActionForward("USER_CANCEL_AC", 5));
        this.addAction(exibeConfirmacaoTelefone);
        Action tipoFinanciamento = new Action("tipoFinanciamento", MicCapturaTipoFinanciamentoCreditoCelular.class);
        tipoFinanciamento.addActionForward(new ActionForward("SUCESS_AVISTA", "solicitacaoCreditoCelular"));
        tipoFinanciamento.addActionForward(new ActionForward("SUCESS_APRAZOLOJISTA", "capturaNumeroParcela"));
        tipoFinanciamento.addActionForward(new ActionForward("SUCESS_APRAZOADMINISTRADO", "capturaNumeroParcela"));
        tipoFinanciamento.addActionForward(new ActionForward("FILLED", "verificaFinanciamento"));
        tipoFinanciamento.addActionForward(new ActionForward("ERROR", 6));
        tipoFinanciamento.addActionForward(new ActionForward("ERROR_AC", 6));
        tipoFinanciamento.addActionForward(new ActionForward("FINANCIAMENTO_INVALIDO_AC", 6));
        tipoFinanciamento.addActionForward(new ActionForward("USERCANCEL", 3));
        this.addAction(tipoFinanciamento);
        Action capturaNumeroParcela = new Action("capturaNumeroParcela", MicCapturaNumeroParcela.class);
        capturaNumeroParcela.addActionForward(new ActionForward("FILLED", "solicitacaoCreditoCelular"));
        capturaNumeroParcela.addActionForward(new ActionForward("SUCCESS", "solicitacaoCreditoCelular"));
        capturaNumeroParcela.addActionForward(new ActionForward("NOT_REQUIRED", "solicitacaoCreditoCelular"));
        capturaNumeroParcela.addActionForward(new ActionForward("PARCELA_INVALIDA", "capturaNumeroParcela"));
        capturaNumeroParcela.addActionForward(new ActionForward("PARCELA_INVALIDA_AC", 6));
        capturaNumeroParcela.addActionForward(new ActionForward("USER_CANCEL", 3));
        this.addAction(capturaNumeroParcela);
        Action solicitacaoCreditoCelular = new Action("solicitacaoCreditoCelular", MicSolicitacaoCreditoCelular.class);
        solicitacaoCreditoCelular.addActionForward(new ActionForward("SUCESS", "verificaComunicaoSolicitacao"));
        solicitacaoCreditoCelular.addActionForward(new ActionForward("ERROR", "verificaComunicaoSolicitacao"));
        this.addAction(solicitacaoCreditoCelular);
        Action verificaComunicaoSolicitacao = new Action("verificaComunicaoSolicitacao", MicVerificaComunicacaoCTF.class);
        verificaComunicaoSolicitacao.addActionForward(new ActionForward("SUCESS", 0));
        verificaComunicaoSolicitacao.addActionForward(new ActionForward("ERRO", 6));
        this.addAction(verificaComunicaoSolicitacao);
        this.setStartKeyAction("leituraValor");
    }
}

