/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.controller.ControladorMultiEC;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.LeitorDocumento;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.Scanner;
import com.csi.ctfclient.tools.devices.emv.DadosGetInfoRedeEMV;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import java.util.Objects;

public abstract class MicAbstractBase {
    protected AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    protected Process parent;

    public final String execute(Process dados) throws ExcecaoNaoLocal {
        this.parent = dados;
        return this.derivedExecute(dados);
    }

    public abstract String derivedExecute(Process var1) throws ExcecaoNaoLocal;

    protected AuttarLogger getLogger() {
        return this.logger;
    }

    protected void setIntegrationError(CodigoErroIntegracaoEnum errorCode, String message) {
        CodigoErroIntegracao error = new CodigoErroIntegracao(errorCode, message);
        Contexto.getContexto().setErroIntegracao(error);
    }

    protected void setPinpadData(int inputMode) throws ExcecaoPerifericos {
        PinEMV pin = this.tryGetPin();
        if (pin == null) {
            this.logger.debug("Pinpad n\u00e3o configurado, pulando envio de informa\u00e7\u00f5es para o CTF");
            return;
        }
        SaidaGetInfoEMV getInfoEMV = pin.getInfo();
        EntradaApiTefC ctfIn = Contexto.getContexto().getEntradaApiTefC();
        ctfIn.setNumeroSeriePin(getInfoEMV.getNumSeriePinpad());
        ctfIn.setFabricantePinpad(getInfoEMV.getFabricante());
        ctfIn.setModeloHardware(getInfoEMV.getModeloHardware());
        ctfIn.setVersaoEspecificacao(getInfoEMV.getVersaoEspecificacao());
        ctfIn.setVersaoFirmwarePinpad(getInfoEMV.getVersaoFirmware());
        ctfIn.setVersaoAplicacaoBasica(getInfoEMV.getVersaoAplBasica());
        ctfIn.setModoEntrada(inputMode);
        ctfIn.setTipoPin("16");
        this.setPinpadDataEMV(pin);
    }

    protected void setPinpadDataEMV(PinEMV pin) throws ExcecaoPerifericos {
        DadosGetInfoRedeEMV dadosGetInfoRedeEMV = pin.getInfoRedeEMV(4);
        EntradaApiTefC ctfIn = Contexto.getContexto().getEntradaApiTefC();
        if (dadosGetInfoRedeEMV != null) {
            ctfIn.setVersaoBibliotecaRedeEMV(dadosGetInfoRedeEMV.getVersaoAplicacao());
        }
    }

    protected PinEMV tryGetPin() {
        try {
            return this.parent.getPerifericos().getPin();
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.warn("Nao foi possivel carregar o pin: " + excecaoPerifericos.getMessage());
            return null;
        }
    }

    protected void tryShowMessagePinpad(String message) {
        PinEMV pin = this.tryGetPin();
        if (pin == null) {
            this.logger.warn("Nao foi possivel carregar o pin para exibir mensagem");
            return;
        }
        try {
            pin.setMsgDisplay(message);
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.warn("Nao foi possivel exibir mensagem na tela do pin: " + excecaoPerifericos.getMessage());
        }
    }

    protected ILeitorCartaoHandler tryGetCardReader() {
        try {
            return this.parent.getPerifericos().getLeitorCartao();
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.warn("Nao foi possivel carregar o leitor de cartoes: " + excecaoPerifericos.getMessage());
            return null;
        }
    }

    protected LeitorDocumento tryGetDocumentReader() {
        try {
            return this.parent.getPerifericos().getLeitorDocumento();
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.warn("Nao foi possivel carregar o leitor de documentos: " + excecaoPerifericos.getMessage());
            return null;
        }
    }

    protected LeitorDocumento tryEnableDocumentReader() {
        try {
            LeitorDocumento leitorDocumento = this.parent.getPerifericos().getLeitorDocumento();
            leitorDocumento.habilita();
            return leitorDocumento;
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.warn("Nao foi possivel habilitar o leitor de documentos: " + excecaoPerifericos.getMessage());
            return null;
        }
    }

    protected Scanner tryEnableScanner() {
        try {
            Scanner scanner = this.parent.getPerifericos().getScanner();
            scanner.habilita();
            return scanner;
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.warn("Nao foi possivel habilitar o scanner: " + excecaoPerifericos.getMessage());
            return null;
        }
    }

    protected void tryDisablePeripheral(Periferico peripheral) {
        try {
            if (peripheral != null) {
                peripheral.desabilita();
            }
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.warn("Nao foi possivel desabilitar o periferico: " + excecaoPerifericos.getMessage());
        }
    }

    protected void tryDisableCardReader(ILeitorCartaoHandler cardReader) {
        try {
            if (cardReader != null) {
                cardReader.desabilita();
            }
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.warn("Nao foi possivel desabilitar o leitor de cartoes: " + excecaoPerifericos.getMessage());
        }
    }

    protected IdentTerminal getIdentTerminal() throws ExcecaoNaoLocal {
        ConfCTFClient config = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        if (config.isMultiEC()) {
            return ControladorMultiEC.criarTerminalComumMultiEC(config.getCodigoGrupoMultiEC());
        }
        return this.getIdentTerminalIgnoreMultiEc();
    }

    protected IdentTerminal getIdentTerminalIgnoreMultiEc() throws ExcecaoNaoLocal {
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().getIdentTerminal() != null) {
            return Contexto.getContexto().getEntradaIntegracao().getIdentTerminal();
        }
        ConfCTFClient config = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        return new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
    }
}

