/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public abstract class MicAbstractSolicitacaoTEF
extends MicAbstractBase {
    public static final String ERROR = "ERROR";
    public static final String SUCCESS = "SUCCESS";

    protected abstract String getCodigoTransacao(Process var1);

    public String genericExecute(Process dados) throws ExcecaoNaoLocal {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        this.initEntradaApiTefC(entradaApiTefC, dados);
        this.montaDisplay(dados);
        SaidaApiTefC saidaApiTefC = this.solicitaTEF(entradaApiTefC, dados);
        Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
        return this.testaRetorno(saidaApiTefC);
    }

    protected void initEntradaApiTefC(EntradaApiTefC entradaApiTefC, Process dados) {
        String operacao = this.getCodigoTransacao(dados);
        entradaApiTefC.setOperacao(operacao);
        this.logger.debug("initEntradaApiTefC:operacao=" + operacao);
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (saidaApiTefC != null) {
            entradaApiTefC.setTimeoutCtf(saidaApiTefC.getTimeOutCTF());
            this.logger.debug("initEntradaApiTefC:timeout-ctf=" + saidaApiTefC.getTimeOutCTF());
        }
    }

    private SaidaApiTefC solicitaTEF(EntradaApiTefC entradaApiTefC, Process dados) {
        return dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entradaApiTefC);
    }

    private void montaDisplay(Process dados) {
        try {
            if (Contexto.getContexto().getSaidaApiTefC() == null) {
                dados.getPerifericos().imprimeDisplay(this.createLayoutDisplayAguarde());
            } else if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
                dados.getPerifericos().imprimeDisplay(this.createLayoutDisplaySolicitacao());
            }
        }
        catch (ExcecaoNaoLocal excecaoNaoLocal) {
            this.logger.warn("Nao foi possivel exibir display no periferico: " + excecaoNaoLocal.getMessage());
        }
    }

    protected LayoutDisplay createLayoutDisplayAguarde() {
        InternacionalizacaoUtil internacionalizacaoUtil = InternacionalizacaoUtil.getInstance();
        LayoutDisplay display = new LayoutDisplay();
        display.addLinha(new Linha(internacionalizacaoUtil.getMessage("SOLDESPREVAL_SOLICITACAO3")));
        return display;
    }

    protected LayoutDisplay createLayoutDisplaySolicitacao() {
        InternacionalizacaoUtil internacionalizacaoUtil = InternacionalizacaoUtil.getInstance();
        LayoutDisplay display = new LayoutDisplay();
        display.addLinha(new Linha(internacionalizacaoUtil.getMessage("ENVTRA_SOLICITACAO1")));
        display.addLinha(new Linha(internacionalizacaoUtil.getMessage("ENVTRA_SOLICITACAO2")));
        display.addLinha(new Linha(internacionalizacaoUtil.getMessage("ENVTRA_SOLICITACAO3")));
        return display;
    }

    protected String testaRetorno(SaidaApiTefC saidaApiTefC) {
        if (saidaApiTefC != null) {
            if (saidaApiTefC.getRetorno() != 0) {
                this.logger.info("Resposta autorizadora: " + saidaApiTefC.getCodigoRespostaAutorizadora());
                return ERROR;
            }
            VerifyContentUtil.preencheDadosSaida(saidaApiTefC);
            return SUCCESS;
        }
        return ERROR;
    }
}

