/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.UserCancelException;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;

public class MicAlterarValorPagamentoCorBan {
    public static final String SUCCESS = "SUCCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USER_CANCEL = "USER_CANCEL";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(Process dados) throws ExcecaoNaoLocal {
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (saida == null || !saida.isPermiteAlteracaoValorPagamentoCorban()) {
            return UNECESSARY;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        BigDecimal novoValor = null;
        try {
            novoValor = this.solicitaValorUsuario(perifericos, new BigDecimal(0));
        }
        catch (UserCancelException e) {
            return USER_CANCEL;
        }
        logger.info("Valor do pagamento capturado: '" + novoValor + "'");
        entrada.setValorTransacao(novoValor);
        return SUCCESS;
    }

    private BigDecimal solicitaValorUsuario(ControladorPerifericos perifericos, BigDecimal valorDefault) throws ExcecaoNaoLocal, UserCancelException {
        String valorDefaultString = "000";
        if (!valorDefault.equals(new BigDecimal(0))) {
            valorDefaultString = valorDefault.multiply(new BigDecimal(100)).toString();
        }
        valorDefaultString = valorDefaultString.substring(0, valorDefaultString.length() - 3);
        String digitos = "";
        BigDecimal valor = null;
        BigDecimal bigDecimalZero = new BigDecimal(0);
        while (valor == null || valor.compareTo(bigDecimalZero) == 0) {
            LayoutDisplay displayModel = new LayoutDisplay(this.inter.getMessage("CAPVALPAG_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_PAGAMENTO, false, valorDefaultString, new long[]{1L});
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                throw new UserCancelException();
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            digitos = eventoTeclado.getStringLida().substring(num);
            try {
                valor = new BigDecimal(digitos);
            }
            catch (NumberFormatException e) {
                valor = null;
            }
        }
        if (valor != null && valor.compareTo(bigDecimalZero) != 0) {
            valor = valor.movePointLeft(2);
        }
        return valor;
    }

    class invalidNumberException
    extends Exception {
        private static final long serialVersionUID = 2L;

        invalidNumberException() {
        }
    }

    class userCancelException
    extends Exception {
        private static final long serialVersionUID = 1L;

        userCancelException() {
        }
    }
}

