/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.autenticacao.AutenticacaoUtil;
import com.csi.ctfclient.autenticacao.DadosAutenticacao;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.controller.ControladorApitefC;
import com.csi.ctfclient.tools.communication.Host;
import com.csi.ctfclient.tools.communication.ServicoCTF;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.ByteUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.FileOutputStream;
import java.security.MessageDigest;
import java.util.LinkedHashSet;
import java.util.Objects;

public class MicAutenticacao
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String ERROR_AC = "ERROR_AC";
    private String login = null;
    private String password = null;
    private String cnpj = null;
    private String codigoAtivacaoMultiEC = null;
    private String codigoLoja = null;

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        return this.capturaDadosAutenticacao(dados, false);
    }

    private void limpaDadosAutenticacao() {
        this.login = null;
        this.password = null;
        this.cnpj = null;
        this.codigoAtivacaoMultiEC = null;
        this.codigoLoja = null;
    }

    private String capturaDadosAutenticacao(Process dados, boolean capturaLoja) throws ExcecaoNaoLocal {
        ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        boolean isHomologacao = confCTFClient.isHomologacao();
        if (!confCTFClient.isSuporteHttps()) {
            return SUCCESS;
        }
        try {
            AutenticacaoUtil autenticacaoUtil = AutenticacaoUtil.getInstance();
            if (autenticacaoUtil.isTokenAutorizacao()) {
                return SUCCESS;
            }
        }
        catch (Exception e) {
            this.logger.error("Erro ao tentar recuperar o token de autorizacao: " + e.getMessage());
            return ERROR;
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        boolean isMultiEC = false;
        if (confCTFClient.isMultiEC()) {
            isMultiEC = true;
        }
        while (this.login == null || this.password == null || !isMultiEC && this.cnpj == null || isMultiEC && this.codigoAtivacaoMultiEC == null || this.codigoLoja == null && capturaLoja) {
            LayoutDisplay layoutDisplay;
            EventoTeclado eventoTeclado = null;
            if (this.login == null) {
                layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_LOGIN"), 0, 1));
                eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_AUT_LOGIN, 0, true, 0, true);
                this.login = eventoTeclado.getStringLida().substring(0, eventoTeclado.getNumCaracteresDigitados());
            } else if (this.password == null) {
                layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_PASSWORD"), 0, 1));
                eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_AUT_PASSWORD, 0, true, true);
                this.password = eventoTeclado.getStringLida().substring(0, eventoTeclado.getNumCaracteresDigitados());
            } else if (this.cnpj == null || isMultiEC && this.codigoAtivacaoMultiEC == null) {
                if (isMultiEC) {
                    layoutDisplay = new LayoutDisplay();
                    layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                    layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_ATIVACAO_MULTIEC"), 0, 1));
                    eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_AUT_ATIVACAO_MULTIEC, 0, true, 0, true);
                    this.codigoAtivacaoMultiEC = eventoTeclado.getStringLida().substring(0, eventoTeclado.getNumCaracteresDigitados());
                } else {
                    layoutDisplay = new LayoutDisplay();
                    layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                    layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_CNPJ"), 0, 1));
                    eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_AUT_CNPJ, 0, true, 0, true);
                    this.cnpj = eventoTeclado.getStringLida().substring(0, eventoTeclado.getNumCaracteresDigitados());
                }
            } else if (capturaLoja) {
                layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_LOJA"), 0, 1));
                eventoTeclado = (EventoTeclado)perifericos.capturaDado(layoutDisplay, ConstantesApiAc.CAP_CODIGO_LOJA, 0, true, 0, true);
                this.codigoLoja = eventoTeclado.getStringLida().substring(0, eventoTeclado.getNumCaracteresDigitados());
            }
            if (!"VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) continue;
            return USER_CANCEL;
        }
        JsonObject parameters = new JsonObject();
        parameters.addProperty("login", this.login.toLowerCase());
        parameters.addProperty("senha", this.password.toLowerCase());
        if (isMultiEC) {
            parameters.addProperty("codigoAtivacao", this.codigoAtivacaoMultiEC);
            parameters.addProperty("codigoMultiEC", confCTFClient.getCodigoGrupoMultiEC() + "");
        } else {
            parameters.addProperty("cnpj", this.cnpj);
        }
        if (capturaLoja) {
            parameters.addProperty("codigoLoja", this.codigoLoja.toLowerCase());
        }
        if (this.isWin()) {
            parameters.addProperty("tipo", "5");
        } else {
            parameters.addProperty("tipo", "6");
        }
        parameters.addProperty("suporteHttps", "true");
        parameters.addProperty("tipoIdentificacao", "3");
        parameters.addProperty("identificacao", AutenticacaoUtil.getIdentificao());
        parameters.addProperty("fabricante", this.getOSName());
        parameters.addProperty("modelo", this.getOSVersion());
        LayoutDisplay displayModel = new LayoutDisplay("AGUARDE...");
        perifericos.imprimeDisplay(displayModel);
        return this.processaResposta(dados, this.cnpj, parameters, isHomologacao, isMultiEC);
    }

    private boolean isWin() {
        String osName = this.getOSName();
        return osName.contains("win");
    }

    private String getOSName() {
        return System.getProperty("os.name").toLowerCase();
    }

    private String getOSVersion() {
        return System.getProperty("os.version") + " - " + System.getProperty("os.arch");
    }

    /*
     * Exception decompiling
     */
    public String processaResposta(Process dados, String cnpj, JsonObject parameters, boolean homologacao, boolean multiEC) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String processaResposta(int httpCode, Process dados, String resposta, String cnpj) throws Exception {
        block34: {
            JsonObject jsonObject;
            InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
            ControladorPerifericos perifericos = dados.getPerifericos();
            ControladorConfCTFClient controladorConfCTFClient = ControladorConfCTFClient.getInstance();
            ConfCTFClient newConfCTFClient = new ConfCTFClient();
            AutenticacaoUtil autenticacaoUtil = AutenticacaoUtil.getInstance();
            autenticacaoUtil.clean();
            try {
                jsonObject = new JsonParser().parse(resposta).getAsJsonObject();
            }
            catch (JsonParseException e) {
                LayoutDisplay layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                layoutDisplay.addLinha(new Linha("ERRO NO PROCESSAMENTO", 0, 1));
                perifericos.confirmaDado(layoutDisplay);
                return "RERUN";
            }
            String certificado = null;
            String certificadoMD5 = null;
            String md5 = null;
            String token = null;
            String clientServicesHost = null;
            try {
                int retorno = 20;
                String mensagem = null;
                if (httpCode == 409 && jsonObject.has("code") && (retorno = jsonObject.get("code").getAsInt()) == 8) {
                    return this.capturaDadosAutenticacao(dados, true);
                }
                if (httpCode != 200) {
                    retorno = jsonObject.get("code").getAsInt();
                    if (jsonObject.has("message")) {
                        mensagem = jsonObject.get("message").getAsString();
                    }
                    this.limpaDadosAutenticacao();
                } else {
                    if (jsonObject.has("retorno")) {
                        retorno = jsonObject.get("retorno").getAsInt();
                    }
                    if (jsonObject.has("mensagem")) {
                        mensagem = jsonObject.get("mensagem").getAsString();
                    }
                }
                if (mensagem == null) {
                    mensagem = "AUTENTICA\u00c7\u00c3O FEITA COM SUCESSO";
                }
                if (jsonObject.has("token")) {
                    token = jsonObject.get("token").getAsString();
                }
                if (retorno == 0) {
                    JsonArray parametros;
                    newConfCTFClient.setCnpj(cnpj);
                    String terminal = null;
                    if (jsonObject.has("codigoterminal")) {
                        terminal = jsonObject.get("codigoterminal").getAsString();
                    } else if (jsonObject.has("codigoTerminal")) {
                        terminal = jsonObject.get("codigoTerminal").getAsString();
                    }
                    if (terminal != null) {
                        IdentApiTefC identApiTefC = Contexto.getContexto().getIdentApiTefC();
                        String companyCode = terminal.substring(0, 5);
                        String storeCode = terminal.substring(5, 9);
                        String terminalCode = terminal.substring(9);
                        newConfCTFClient.setEstabelecimento(companyCode);
                        identApiTefC.setNumeroEstabelecimento(companyCode);
                        newConfCTFClient.setLoja(storeCode);
                        identApiTefC.setNumeroLoja(storeCode);
                        newConfCTFClient.setTerminal(terminalCode);
                        identApiTefC.setNumeroPdv(terminal);
                    }
                    if ((parametros = jsonObject.get("parametros").isJsonArray() ? jsonObject.getAsJsonArray("parametros") : jsonObject.getAsJsonObject("parametros").getAsJsonArray("parametro")) == null || parametros.size() <= 0) break block34;
                    for (int i = 0; i < parametros.size(); ++i) {
                        JsonObject parametro = parametros.get(i).getAsJsonObject();
                        if (parametro.get("id").getAsString().equalsIgnoreCase("hostctf")) {
                            String[] hostsArray = parametro.get("valor").getAsString().split(";");
                            if (hostsArray.length <= 0) continue;
                            LinkedHashSet<ServicoCTF> ips = new LinkedHashSet<ServicoCTF>();
                            for (String s : hostsArray) {
                                ServicoCTF servico;
                                newConfCTFClient.setComunicacaoCTF(hostsArray);
                                if (!s.toLowerCase().contains("http")) continue;
                                String strHost = s;
                                Host hostCTF = new Host(strHost);
                                try {
                                    servico = new ServicoCTF(hostCTF, "443", "HTTPS");
                                }
                                catch (ExcecaoParametroInvalido e) {
                                    this.logger.error("valor de parametro invalido ==> ips = protocolo, usar TCP, UDP ou UDP2, HTTPS");
                                    return ERROR;
                                }
                                ips.add(servico);
                            }
                            newConfCTFClient.setIps(ips);
                            continue;
                        }
                        if (parametro.get("id").getAsString().equalsIgnoreCase("ambiente")) {
                            parametro.get("valor").getAsString();
                            continue;
                        }
                        if (parametro.get("id").getAsString().equalsIgnoreCase("certificado-md5")) {
                            md5 = parametro.get("valor").getAsString();
                            continue;
                        }
                        if (parametro.get("id").getAsString().equalsIgnoreCase("certificado")) {
                            try {
                                certificado = parametro.get("valor").getAsString();
                                byte[] buffer = certificado.getBytes();
                                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                                messageDigest.reset();
                                messageDigest.update(buffer);
                                byte[] resultByte = messageDigest.digest();
                                certificadoMD5 = ByteUtil.byteArrayToHex(resultByte);
                                continue;
                            }
                            catch (Exception e) {
                                this.logger.error("Erro durante a validacao do certificado: " + e.getMessage());
                                LayoutDisplay layoutDisplay = new LayoutDisplay();
                                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                                layoutDisplay.addLinha(new Linha("CERTIFICADO INVALIDO", 0, 1));
                                perifericos.confirmaDado(layoutDisplay);
                                return "RERUN";
                            }
                        }
                        if (!parametro.get("id").getAsString().equalsIgnoreCase("clienteservico-host")) continue;
                        clientServicesHost = parametro.get("valor").getAsString();
                    }
                    if (certificado != null && certificadoMD5 != null && certificadoMD5.equalsIgnoreCase(md5)) {
                        try {
                            String nomeCertificado = "ca-bundle.crt";
                            FileOutputStream fos = new FileOutputStream(nomeCertificado);
                            fos.write(certificado.getBytes());
                            fos.flush();
                            fos.close();
                        }
                        catch (Exception e) {
                            this.logger.error("Erro durante a escrita do certificado: " + e.getMessage());
                            LayoutDisplay layoutDisplay = new LayoutDisplay();
                            layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE"), 0, 1));
                            layoutDisplay.addLinha(new Linha("ERRO AO GRAVAR CERTIFICADO."));
                            perifericos.confirmaDado(layoutDisplay);
                            return "RERUN";
                        }
                    }
                    if (Objects.requireNonNull(controladorConfCTFClient).getConfig().isSuporteHttps()) {
                        DadosAutenticacao dadosAutenticacao = new DadosAutenticacao();
                        dadosAutenticacao.setToken(token);
                        dadosAutenticacao.setTerminal(terminal);
                        dadosAutenticacao.setClientServicesHost(clientServicesHost);
                        if (newConfCTFClient.getComunicacaoCTF() != null && newConfCTFClient.getComunicacaoCTF().length > 0) {
                            dadosAutenticacao.setCtfHosts(newConfCTFClient.getComunicacaoCTF());
                        }
                        dadosAutenticacao.setIdentificacao(AutenticacaoUtil.getIdentificao());
                        autenticacaoUtil.configDadosAutenticacao(dadosAutenticacao);
                        try {
                            controladorConfCTFClient.save(newConfCTFClient, true);
                        }
                        catch (ExcecaoApiAc e) {
                            autenticacaoUtil.clean();
                        }
                    }
                    LayoutDisplay layoutDisplay = new LayoutDisplay();
                    layoutDisplay.addLinha(new Linha(mensagem.toUpperCase()));
                    perifericos.confirmaDado(layoutDisplay);
                    dados.setApitef(ControladorApitefC.newInstancia());
                    return SUCCESS;
                }
                this.logger.error("Retorno de erro da autenticacao: " + retorno);
                LayoutDisplay layoutDisplay = new LayoutDisplay();
                layoutDisplay.addLinha(new Linha(inter.getMessage("CAPAUTENTICADOR_TITLE")));
                layoutDisplay.addLinha(new Linha(mensagem.toUpperCase(), 0, 1));
                perifericos.confirmaDado(layoutDisplay);
                return "RERUN";
            }
            catch (Exception e) {
                this.logger.error("Erro generico ao interpretar resposta da autenticacao: " + e.getMessage());
            }
        }
        return ERROR;
    }
}

