/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.microoperacoes.MicLeituraCartao;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoLeitorDocumento;
import com.csi.ctfclient.tools.devices.EventoScanner;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.LeitorDocumento;
import com.csi.ctfclient.tools.devices.Scanner;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.EventoLeitorCartao;
import com.csi.ctfclient.tools.devices.emv.LeitorCartao;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.util.Date;

public class MicCapturaCartaoPrepago
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String ERROR = "ERROR";
    public static final String ERROR_AC = "ERROR_AC";
    public static final String USER_CANCEL = "USER_CANCEL";
    private static final String MST_ERRO_READ_CARD1 = "ERRO DE LEITURA";
    private static final String MST_ERRO_READ_CARD2 = "TENTE NOVAMENTE";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        if (entrada.getCodigoBarrasCartaoPrepago() != null || Contexto.getContexto().getCartao() != null) {
            return FILLED;
        }
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null && entradaIntegracao.isCodigoBarrasCtrl() && entradaIntegracao.isModoEntradaCodigoBarrasCtrl()) {
            if (entradaIntegracao.getCodigoBarras().length() >= 30) {
                int modoEntrada = entradaIntegracao.getModoEntradaCodigoBarras();
                entrada.setCodigoBarrasCartaoPrepago(entradaIntegracao.getCodigoBarras().trim());
                Contexto.getContexto().setModoEntradaCodigoBarrasCartaoPrepago(modoEntrada);
                return SUCCESS;
            }
            this.logger.error("O c\u00f3digo de barras possui menos de 30 d\u00edgitos");
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_5399, "CODIGO DE BARRAS INVALIDO"));
            return ERROR_AC;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        String tituloDisplay = inter.getMessage("CAPCODBARCATPRE_TITLE");
        long[] entradaDados = new long[]{1L, 2L, 16L};
        boolean habilitaCartao = entradaIntegracao != null && entradaIntegracao.getOperacao() != OperationEnum.OP_VENDA_FASTPIN.getKey().intValue() && entradaIntegracao.getOperacao() != OperationEnum.OP_RETORNO_FASTPIN.getKey().intValue();
        Scanner scanner = this.tryEnableScanner();
        LeitorDocumento leitorDocumento = this.tryEnableDocumentReader();
        ILeitorCartaoHandler cartaoHandler = null;
        if (habilitaCartao) {
            try {
                if (perifericos.getLeitorCartao() != null) {
                    cartaoHandler = perifericos.getLeitorCartao();
                    LeitorCartao dadosLeitorCartao = cartaoHandler.getLeitorCartao();
                    dadosLeitorCartao.setTipoAplicacao(99);
                    CMOSPinPad cmosPinPad = CMOSPinPad.getInstance();
                    dadosLeitorCartao.setTimeStamp(cmosPinPad.getTimeStamp(0));
                    dadosLeitorCartao.setDataTransacao(new Date());
                    try {
                        PerifericoEventHandler.setActive(true);
                        cartaoHandler.habilitaTrilha(1);
                        cartaoHandler.habilitaTrilha(2);
                        cartaoHandler.habilita();
                        tituloDisplay = inter.getMessage("CAPCARTPRE_TITLE");
                        entradaDados = new long[]{1L, 2L, 16L, 8L};
                    }
                    catch (Exception e) {
                        perifericos.liberarRecursosPinCartao();
                    }
                }
            }
            catch (ExcecaoPerifericos e) {
                this.logger.info("Leitor de cartao n\u00e3o conectado");
            }
        }
        LayoutDisplay displayTitulo = new LayoutDisplay(tituloDisplay);
        ConstantesApiAc.TipoCampo mascaraEdicao = ConstantesApiAc.CAP_CODIGO_BARRAS_CARTAO_PREPAGO_BLACKHAWK;
        PerifericoEventHandler.setActive(true);
        EventoDispositivoEntrada evento = perifericos.capturaDado(displayTitulo, mascaraEdicao, true, "", entradaDados);
        if (evento instanceof EventoTeclado) {
            EventoTeclado eventoTeclado = (EventoTeclado)evento;
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                this.tryDisablePeripheral(scanner);
                this.tryDisablePeripheral(leitorDocumento);
                this.tryDisableCardReader(cartaoHandler);
                return USER_CANCEL;
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            String codigoBarras = eventoTeclado.getStringLida().substring(num);
            if (codigoBarras.length() == 0) {
                LayoutDisplay displayError = new LayoutDisplay(inter.getMessage("CAPCODBARCATPRE_ERRO_TAMANHO_MINIMO"));
                perifericos.confirmaDado(displayError);
                return ERROR;
            }
            entrada.setCodigoBarrasCartaoPrepago(codigoBarras);
            Contexto.getContexto().setModoEntradaCodigoBarrasCartaoPrepago(1);
        } else if (evento instanceof EventoScanner || evento instanceof EventoLeitorDocumento) {
            int meioCaptura;
            String codigoBarras;
            if (evento instanceof EventoScanner) {
                EventoScanner eventoScanner = (EventoScanner)evento;
                codigoBarras = eventoScanner.getRepresentacaoString();
                meioCaptura = 3;
            } else {
                EventoLeitorDocumento eventoLeitorDocumento = (EventoLeitorDocumento)evento;
                codigoBarras = eventoLeitorDocumento.getRepresentacaoString();
                meioCaptura = 3;
            }
            if (codigoBarras.length() == 0) {
                LayoutDisplay displayError = new LayoutDisplay(inter.getMessage("CAPCODBARCATPRE_ERRO_TAMANHO_MINIMO"));
                perifericos.confirmaDado(displayError);
                return ERROR;
            }
            entrada.setCodigoBarrasCartaoPrepago(codigoBarras);
            Contexto.getContexto().setModoEntradaCodigoBarrasCartaoPrepago(meioCaptura);
        } else {
            if (!(evento instanceof EventoLeitorCartao)) throw new IllegalArgumentException("Tipo de evento n\u00e3o esperado");
            EventoLeitorCartao eventoEMV = (EventoLeitorCartao)evento;
            if (eventoEMV.getErroCodigo() == 13) {
                return USER_CANCEL;
            }
            if (eventoEMV.getErroCodigo() != 0) {
                this.exibeMensagemDuasLinhas(perifericos, MST_ERRO_READ_CARD1, MST_ERRO_READ_CARD2);
                return ERROR;
            }
            if (eventoEMV.getTipoCartao() == 0) {
                Contexto.getContexto().setCartao(Cartao.MAGNETICO);
                entrada.setModoEntrada(2);
                if (eventoEMV.getNomePortadorCartao() != null && !eventoEMV.getNomePortadorCartao().equals("")) {
                    entrada.setNomeCliente(MicLeituraCartao.getNomePortador(eventoEMV));
                }
                entrada.setStatusChip(eventoEMV.getStatusUltLeitura());
                entrada.setTipoCartao(eventoEMV.getTipoCartao());
                entrada.setIssuerCountryCode(eventoEMV.getIssuerCountryCode());
                entrada.setWFlags(eventoEMV.getFlags());
                entrada.setDadosRedeAdquirente(eventoEMV.getDadosRestantes());
                entrada.setPAN(MicLeituraCartao.getNumero(eventoEMV));
                entrada.setPANCripto(eventoEMV.getPANCripto());
                if (eventoEMV.getTrilha1() != null) {
                    entrada.setTrilha1(eventoEMV.getTrilha1());
                }
                if (eventoEMV.getTrilha2() != null) {
                    entrada.setInfo(eventoEMV.getTrilha2());
                }
            } else {
                this.exibeMensagemDuasLinhas(perifericos, inter.getMessage("CAPCODBARCATPRE_ERRO_TARJA"), "");
                return ERROR;
            }
        }
        this.tryDisablePeripheral(scanner);
        this.tryDisablePeripheral(leitorDocumento);
        this.tryDisableCardReader(cartaoHandler);
        PerifericoEventHandler.setActive(false);
        return SUCCESS;
    }

    private void exibeMensagemDuasLinhas(ControladorPerifericos perifericos, String msg1, String msg2) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.setDelay(1500L);
        displayModel.addLinha(new Linha(msg1));
        displayModel.addLinha(new Linha(msg2));
        perifericos.imprimeDisplay(displayModel);
    }
}

