/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaCartaoPrepagoDigital {
    public static final String SUCCESS = "SUCCESS";
    public static final String SUCCESS_INTEGRACAO = "SUCCESS_INTEGRACAO";
    public static final String USER_CANCEL = "USER_CANCEL";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null && entradaIntegracao.isCodigoCartaoPrepagoDigitalCtrl()) {
            Contexto.getContexto().getEntradaApiTefC().setCartaoPrepagoDigital(entradaIntegracao.getCodigoCartaoPrepagoDigital());
            return SUCCESS_INTEGRACAO;
        }
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        ControladorPerifericos periferico = dados.getPerifericos();
        String valor = null;
        int caracteresDigitados = 0;
        while (caracteresDigitados < 13) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPCARPREDIG_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel, ConstantesApiAc.CAP_CARTAO_PREPAGO_DIGITAL);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            caracteresDigitados = eventoTeclado.getNumCaracteresDigitados();
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num).trim();
        }
        entrada.setCartaoPrepagoDigital(valor);
        return SUCCESS;
    }
}

