/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.DadosBaixaTecnicaManual;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaCodigoOcorrencia {
    public static final String SUCESS = "SUCESS";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String FILLED = "FILLED";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        DadosBaixaTecnicaManual dadosBaixaTecnicaManual = Contexto.getContexto().getBaixaTecnicaManual();
        if (dadosBaixaTecnicaManual.getCodigoOcorrencia() != null) {
            return FILLED;
        }
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPCODOCO_TITLE"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_CODIGO_OCORRENCIA, 0, true, 1, false);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USER_CANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String numCodigoOcorrencia = eventoTeclado.getStringLida().substring(num);
        dadosBaixaTecnicaManual.setCodigoOcorrencia(numCodigoOcorrencia);
        return SUCESS;
    }
}

