/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaCodigoPreAutorizacao {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_CODIGO = "INVALID_CODIGO";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dado) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel;
        logger = dado.getLoggerFactory().getLogger(CTFClientCore.class);
        if (!this.isCapturaPreAutorizacao(dado)) {
            return SUCESS;
        }
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaApiTefC.getCodigoAutorizacao() != null) {
            return FILLED;
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isInfoAdicionaisCtrl()) {
            entradaApiTefC.setCodigoAutorizacao(Contexto.getContexto().getEntradaIntegracao().getInfoAdicionais());
            return SUCESS;
        }
        if (conf.isIntegracaoWeb()) {
            logger.warn("Integra\u00e7\u00e3o Web e c\u00f3digo de pr\u00e9-autoriza\u00e7\u00e3o n\u00e3o preenchido");
            return SUCESS;
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dado.getPerifericos();
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel = new LayoutDisplay(inter.getMessage("CAPCODPREAUT_TITLE")), ConstantesApiAc.CAP_CODIGO_PRE_AUTORIZACAO, true, 7, true);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USER_CANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String codigoAutorizacao = eventoTeclado.getStringLida().substring(num);
        if (codigoAutorizacao.equals("")) {
            if (this.exibeMensagem(perifericos, inter.getMessage("CAPCODPREAUT_ERROR")).equals("ENTRA")) {
                return INVALID_CODIGO;
            }
            return USER_CANCEL;
        }
        entradaApiTefC.setCodigoAutorizacao(codigoAutorizacao);
        return SUCESS;
    }

    private String exibeMensagem(ControladorPerifericos perifericos, String msg) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }

    private boolean isCapturaPreAutorizacao(Process dados) {
        if (OperationEnum.OP_CONFIRMACAO_PRE_AUT.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
            return true;
        }
        if (Contexto.getContexto().getSaidaApiTefC() != null) {
            return Contexto.getContexto().getCartao() == Cartao.DIGITADO && Contexto.getContexto().getSaidaApiTefC().isCapturaPreAutorizacao();
        }
        return false;
    }
}

