/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaCodigoSeguranca {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String USERCANCEL_MOTIVO = "USERCANCEL_MOTIVO";
    public static final String INVALID_LENGTH = "INVALID_LENGTH";
    public static final String INVALID_LENGTH_AC = "INVALID_LENGTH_AC";
    public static final String ERRO_IS_REQUIRED = "ERRO_IS_REQUIRED";
    private static final String MSG_INVALID_COD_SEGURANCA = "COD. SEGURANCA INVALIDO";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (saida.isPedeCVV2()) {
            if (Contexto.getContexto().getEntradaApiTefC().getCvv2() != null) {
                return FILLED;
            }
            int tamanhoMinimo = 3;
            int tamanhoMaximo = 5;
            if (saida.getTamanhoMinimoCodigoSeguranca() > 0 && saida.getTamanhoMaximoCodigoSeguranca() > 0) {
                tamanhoMinimo = saida.getTamanhoMinimoCodigoSeguranca();
                tamanhoMaximo = saida.getTamanhoMaximoCodigoSeguranca();
            }
            if (Contexto.getContexto().getEntradaIntegracao() != null) {
                if (Contexto.getContexto().getEntradaIntegracao().isCodigoSeguracaCtrl()) {
                    String codSeguranca = Contexto.getContexto().getEntradaIntegracao().getCodigoSeguraca();
                    if (codSeguranca.length() < tamanhoMinimo || codSeguranca.length() > tamanhoMaximo) {
                        Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.COD_SEGURANCA_INVALIDO, MSG_INVALID_COD_SEGURANCA));
                        return INVALID_LENGTH_AC;
                    }
                    if (codSeguranca.trim().length() == 0) {
                        Contexto.getContexto().getEntradaApiTefC().setMotivoCVV2('9');
                        return SUCESS;
                    }
                    Contexto.getContexto().getEntradaApiTefC().setCvv2(codSeguranca);
                    return SUCESS;
                }
                if (Contexto.getContexto().getEntradaIntegracao().isMultiTerminal()) {
                    if (saida.isObrigatorioCVV2()) {
                        Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.COD_SEGURANCA_INVALIDO, MSG_INVALID_COD_SEGURANCA));
                        return INVALID_LENGTH_AC;
                    }
                    Contexto.getContexto().getEntradaApiTefC().setMotivoCVV2('2');
                    return SUCESS;
                }
            }
            ControladorPerifericos periferico = dados.getPerifericos();
            String valor = null;
            int caracteresDigitados = 0;
            while (valor == null || caracteresDigitados == 0 && saida.isObrigatorioCVV2() || caracteresDigitados < tamanhoMinimo && caracteresDigitados >= 1) {
                LayoutDisplay displayModel;
                EventoTeclado eventoTeclado;
                if (valor == null) {
                    valor = "";
                }
                if ((eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel = new LayoutDisplay(inter.getMessage("CODIGO_SEGURANCA")), ConstantesApiAc.CAP_CVV2)).getTeclaFinalizadora().equals("VOLTA")) {
                    return USERCANCEL;
                }
                caracteresDigitados = eventoTeclado.getNumCaracteresDigitados();
                int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
                valor = eventoTeclado.getStringLida().substring(num);
            }
            if (valor.length() >= tamanhoMinimo && valor.length() <= tamanhoMaximo) {
                Contexto.getContexto().getEntradaApiTefC().setCvv2(valor);
            } else if (valor == null || valor.equals("")) {
                LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("TITLE_MOTIVO"), true);
                layoutMenu.addItem(new ItemMenu(inter.getMessage("ITEM_MOTIVO1"), "0"));
                layoutMenu.addItem(new ItemMenu(inter.getMessage("ITEM_MOTIVO2"), "1"));
                int opcao = periferico.imprimeMenu(layoutMenu);
                if (opcao == -1) {
                    Contexto.getContexto().getEntradaApiTefC().setCvv2(null);
                    return USERCANCEL_MOTIVO;
                }
                switch (opcao) {
                    case 0: {
                        Contexto.getContexto().getEntradaApiTefC().setMotivoCVV2('2');
                        break;
                    }
                    case 1: {
                        Contexto.getContexto().getEntradaApiTefC().setMotivoCVV2('9');
                    }
                }
            } else {
                this.exibeMensagem(dados.getPerifericos(), inter.getMessage(INVALID_LENGTH));
                return INVALID_LENGTH;
            }
        }
        return SUCESS;
    }

    private void exibeMensagem(ControladorPerifericos perifericos, String msg) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        perifericos.confirmaDado(displayModel);
    }
}

