/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorModeloPinPad;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.DadoSolicitaPin;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emv.PinpadKeyboardEventType;
import com.csi.ctfclient.tools.devices.emv.SaidaCheckEventEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.devices.generic.Ansi98Crypto;
import com.csi.ctfclient.tools.devices.generic.Des;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaDadosPinpad
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String CAPTURA_NAO_CONFIRMADA = "CAPTURA_NAO_CONFIRMADA";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String MSG_CONFIRMA_PINPAD = "CONFIRMA?";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        PinEMV pinEMV;
        try {
            pinEMV = dados.getPerifericos().getPin();
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.error("Nao foi possivel carregar o pin: " + excecaoPerifericos.getMessage());
            return ERROR;
        }
        BibliotecaPinpad libPinpad = (BibliotecaPinpad)pinEMV;
        try {
            String capturaDado = this.capturaDadoPinpad(dados, pinEMV, 11, 11, "INFORME O CPF");
            String display = capturaDado.substring(0, 3) + "." + capturaDado.substring(3, 6) + "." + capturaDado.substring(6, 9) + "-" + capturaDado.substring(9);
            if (libPinpad.isPinpadAbecs() && this.confirmaDadoAbecs(pinEMV, display) || !libPinpad.isPinpadAbecs() && this.confirmaDado(dados, pinEMV, display)) {
                Contexto.getContexto().getSaidaApiTefC().setRetorno(0);
                Contexto.getContexto().setCapturaDadoPinpad(capturaDado);
                return SUCCESS;
            }
            Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.USUARIO_NAO_CONFIRMOU, "USUARIO NAO CONFIRMOU#O CPF"));
            dados.setActiveDialogUserCancel(false);
            return CAPTURA_NAO_CONFIRMADA;
        }
        catch (UserCancelException | UserCancelInternalException e) {
            Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
            return USER_CANCEL;
        }
        catch (ReadErrorException e) {
            Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
            return ERROR;
        }
    }

    private String capturaDadoPinpad(Process dados, PinEMV pin, int tamMin, int tamMax, String display) throws ReadErrorException, UserCancelException, UserCancelInternalException {
        Criptografia criptografia = null;
        DadoSolicitaPin[] dadoSolicitaPins = null;
        boolean flagWKAuttar = true;
        try {
            criptografia = ControladorModeloPinPad.getInstance().getCriptografia(pin);
            if (flagWKAuttar) {
                int modoCriptografia = 0;
                int indiceMkAuttar = 0;
                String wkAuttar = "10BDA8B87A9E8357";
                criptografia = new Criptografia(modoCriptografia, indiceMkAuttar, wkAuttar, true);
            }
        }
        catch (Exception e) {
            this.logger.warn("Erro ao tentar definir o tipo de criptografia na captura de dado do pinpad: " + e.getMessage());
        }
        pin.setCapturaSenha(true);
        int indMensagem = Contexto.getContexto().getEntradaIntegracao().getTipoCapturaDadosPinpad();
        dadoSolicitaPins = new DadoSolicitaPin[]{new DadoSolicitaPin(tamMin, tamMax, display, indMensagem)};
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(dados.getProcessConstructorArguments(), criptografia, dadoSolicitaPins, false, false);
        processLeituraPin.setActiveDialogUserCancel(false);
        processLeituraPin.setTituloAguardaPin(display);
        try {
            processManager.subProcess(dados.getIdProcess(), processLeituraPin);
        }
        catch (Exception e) {
            throw new ReadErrorException();
        }
        if (processLeituraPin.getState() == 3) {
            throw new UserCancelException();
        }
        if (processLeituraPin.getState() == 5) {
            throw new UserCancelInternalException();
        }
        if (processLeituraPin.getState() == 1) {
            throw new ReadErrorException();
        }
        BibliotecaPinpad libPinpad = (BibliotecaPinpad)pin;
        String capturaDado = libPinpad.isPinpadAbecs() && !libPinpad.isCapturaSenha() ? Contexto.getContexto().getPinInfo().getPinCriptografado() : this.decriptografaSenhaCTF(Contexto.getContexto().getPinInfo().getPinCriptografado(), criptografia);
        return capturaDado;
    }

    private String decriptografaSenhaCTF(String senhaCryptoPP, Criptografia criptografia) {
        String senhaDecriptografada = "";
        byte[] senhaPPBytes = Ansi98Crypto.chaveStrHex2Bin(senhaCryptoPP);
        byte[] chaveBytes = null;
        byte[] wkAuttarBytes = Ansi98Crypto.chaveStrHex2Bin(criptografia.getWorkingKey());
        chaveBytes = Ansi98Crypto.chaveStrHex2Bin("3132333435363738");
        senhaDecriptografada = Ansi98Crypto.chaveBin2StrHex(Des.decrypt(chaveBytes = Des.decrypt(chaveBytes, wkAuttarBytes), senhaPPBytes), 8);
        if (senhaDecriptografada != null) {
            int tamanho = Integer.decode("0x" + senhaDecriptografada.substring(0, 2));
            senhaDecriptografada = senhaDecriptografada.substring(2, 2 + tamanho);
        }
        return senhaDecriptografada;
    }

    private boolean confirmaDado(Process dados, PinEMV pin, String dado) {
        Criptografia criptografia = null;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        try {
            criptografia = ControladorModeloPinPad.getInstance().getCriptografia(pin);
        }
        catch (Exception e) {
            this.logger.warn("Erro ao tentar definir o tipo de criptografia na confirmacao de dado do pinpad: " + e.getMessage());
        }
        String mensagemPin = StringUtil.completaString(dado, 16, ' ', 4) + MSG_CONFIRMA_PINPAD;
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(dados.getProcessConstructorArguments(), criptografia, null, false, false);
        processLeituraPin.setActiveDialogUserCancel(false);
        processLeituraPin.setTituloAguardaPin(inter.getMessage("EXICONTEL_MSG_CONFIRMACAO"));
        processLeituraPin.setTipoLeituraPin(3);
        try {
            dados.getPerifericos().getPin().setMsgDisplay(mensagemPin);
            processManager.subProcess(dados.getIdProcess(), processLeituraPin);
            if (processLeituraPin.getState() == 3 || processLeituraPin.getState() == 5) {
                this.logger.info("confirmacao cancelada pelo usuario.");
                return false;
            }
            if (processLeituraPin.getState() == 1) {
                this.logger.error("erro na confirmacao do dado capturado.");
                return false;
            }
            if (processLeituraPin.getTeclaFuncaoPressionada() != 0) {
                this.logger.info("usuario nao confirmou o dado capturado.");
                return false;
            }
        }
        catch (Exception e) {
            this.logger.error("erro na confirmacao do dado capturado (BC): " + e.getMessage());
            return false;
        }
        return true;
    }

    private boolean confirmaDadoAbecs(PinEMV pin, String dado) {
        String mensagemPin = StringUtil.completaString(dado, 16, ' ', 4) + MSG_CONFIRMA_PINPAD;
        try {
            SaidaCheckEventEMV saida;
            pin.setMsgDisplay(mensagemPin);
            int status = pin.startCheckEvent();
            if (status != 0) {
                this.logger.error("Erro em 'startCheckEvent()': " + status + "!");
                return false;
            }
            do {
                if ((saida = pin.checkEvent()) == null) {
                    this.logger.error("Erro interno em 'checkEvent()'");
                    return false;
                }
                if (saida.getRetorno() == 0) {
                    if (saida.getKeyboardEvent() == PinpadKeyboardEventType.KEYBOARD_CANCEL) {
                        this.logger.info("Confirmacao cancelada pelo usuario");
                        return false;
                    }
                    if (saida.getKeyboardEvent() != PinpadKeyboardEventType.OK_ENTER) continue;
                    this.logger.info("Usuario confirmou o dado capturado");
                    return true;
                }
                if (saida.getRetorno() == 1) continue;
                this.logger.error("Erro em 'checkEvent()': " + status + "!");
                return false;
            } while (saida.getRetorno() == 1);
        }
        catch (Exception e) {
            this.logger.error("Erro na confirmacao do dado capturado (ABECS): " + e.getMessage());
            return false;
        }
        return true;
    }

    private class ReadErrorException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private ReadErrorException() {
        }
    }

    private class UserCancelInternalException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private UserCancelInternalException() {
        }
    }

    private class UserCancelException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private UserCancelException() {
        }
    }
}

