/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaEndereco {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_ENDERECO_AC = "INVALID_ENDERECO_AC";
    private static final String MSG_INVALID_ENDERECO = "ENDERECO INVALIDO";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaApiTefC.getEndereco() != null) {
            return FILLED;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            if (Contexto.getContexto().getEntradaIntegracao().isEnderecoCtrl()) {
                entradaApiTefC.setEndereco(Contexto.getContexto().getEntradaIntegracao().getEndereco());
                return SUCESS;
            }
            if (Contexto.getContexto().getEntradaIntegracao().isMultiTerminal()) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_5399, MSG_INVALID_ENDERECO));
                return INVALID_ENDERECO_AC;
            }
        }
        String valor = null;
        int caracteresDigitados = 0;
        ControladorPerifericos periferico = dados.getPerifericos();
        while (caracteresDigitados == 0) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPEND_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel, ConstantesApiAc.CAP_ENDERECO);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num).trim();
            caracteresDigitados = valor.length();
        }
        entradaApiTefC.setEndereco(valor);
        return SUCESS;
    }
}

