/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaNsuTransacao {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_NSU = "INVALID_NSU";
    public static final String INVALID_NSU_AC = "INVALID_NSU_AC";

    /*
     * Enabled aggressive block sorting
     */
    public String execute(Process dado) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (Contexto.getContexto().getEntradaApiTefC().getNsuCtfTransacaoOriginal() > 0) {
            return FILLED;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isNsuCTFCtrl()) {
            if (Contexto.getContexto().getEntradaIntegracao().getNsuCTF() > 0 && Contexto.getContexto().getEntradaIntegracao().getNsuCTF() <= 999999) {
                Contexto.getContexto().getEntradaApiTefC().setNsuCtfTransacaoOriginal(entradaIntegracao.getNsuCTF());
                return SUCESS;
            }
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.NSU_INVALIDO, inter.getMessage("CAPNSUTRA_INVALID_NSU")));
            return INVALID_NSU_AC;
        }
        ControladorPerifericos perifericos = dado.getPerifericos();
        String valor = null;
        int caracteresDigitados = 0;
        while (true) {
            LayoutDisplay displayModel;
            EventoTeclado eventoTeclado;
            if (valor != null && caracteresDigitados >= 6) {
                Contexto.getContexto().getEntradaApiTefC().setNsuCtfTransacaoOriginal(Integer.parseInt(valor));
                return SUCESS;
            }
            if (valor == null) {
                valor = "";
            }
            if ((eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel = new LayoutDisplay(inter.getMessage("CAPNSUTRA_TITLE")), ConstantesApiAc.CAP_NSU_CTF_CANCELAMENTO, true, 7, true, valor)).getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            caracteresDigitados = eventoTeclado.getNumCaracteresDigitados();
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num);
        }
    }
}

