/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaNumeroCiclos {
    public static final String FILLED = "FILLED";
    public static final String SUCCESS = "SUCESS";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String NUMERO_CICLOS_INVALIDO = "NUMERO_INVALIDO";
    public static final String NUMERO_CICLOS_INVALIDO_AC = "NUMERO_INVALIDO_AC";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (Contexto.getContexto().getPlano() != Plano.PRIVATELABEL_APRAZO && Contexto.getContexto().getPlano() != Plano.PRIVATELABEL_AVISTA && saidaApiTefC != null && (saidaApiTefC.getCapturaNumeroCiclos() != null ? !this.shouldCapture(Contexto.getContexto().getPlano(), saidaApiTefC.getCapturaNumeroCiclos()) : !saidaApiTefC.isCapturaCiclos())) {
            return SUCCESS;
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (entradaApiTefC.getNumeroCiclos() >= 0 && !conf.isIntegracaoWeb()) {
            return FILLED;
        }
        if (entradaIntegracao != null && entradaIntegracao.isCiclosPularCtrl()) {
            entradaApiTefC.setNumeroCiclos(entradaIntegracao.getCiclosPular());
            return SUCCESS;
        }
        if (conf.isIntegracaoWeb()) {
            return SUCCESS;
        }
        String cicles = this.getUserInput(dados, ConstantesApiAc.CAP_NUMERO_CICLO).trim();
        entradaApiTefC.setNumeroCiclos("".equals(cicles) ? 0 : Integer.parseInt(cicles));
        return SUCCESS;
    }

    private boolean shouldCapture(Plano operationType, String cicle) {
        if (null != operationType && null != cicle) {
            if (operationType.equals((Object)Plano.AVISTA)) {
                return cicle.matches("1|5|6|7|B|C|D");
            }
            if (operationType.equals((Object)Plano.LOJISTA)) {
                return cicle.matches("2|5|8|9|B|C|E");
            }
            if (operationType.equals((Object)Plano.ADMINISTRADORA)) {
                return cicle.matches("3|6|8|A|B|D|E");
            }
        }
        return false;
    }

    protected String getUserInput(Process dados, ConstantesApiAc.TipoCampo mask) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel = new LayoutDisplay(inter.getMessage("CAPNUMCIC_TITLE")), mask, true, 14, true);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USERCANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        return eventoTeclado.getStringLida().substring(num);
    }
}

