/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;

public class MicCapturaNumeroParcela {
    public static final String SUCESS = "SUCCESS";
    public static final String USERCANCEL = "USER_CANCEL";
    public static final String FILLED = "FILLED";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String PARCELA_INVALIDA = "PARCELA_INVALIDA";
    public static final String PARCELA_INVALIDA_AC = "PARCELA_INVALIDA_AC";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    private int maxParcelas;
    private int minParcelas;
    private BigDecimal valorMinParcelaSemJuros;
    private BigDecimal valorMinParcelaComJuros;

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        this.configuraAtributosPlano();
        logger.info("N\u00famero minimo de parcelas: " + this.minParcelas);
        logger.info("N\u00famero maximo de parcelas: " + this.maxParcelas);
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isNumeroParcelasCtrl()) {
            logger.info("Parcela informada AC: " + Contexto.getContexto().getEntradaIntegracao().getNumeroParcelas());
            if (Contexto.getContexto().getPlano() == Plano.LOJISTA) {
                if (entradaApiTefC.getValorTransacao() != null && this.isValorTransacaoMenorQueValorMinimoParcela(entradaApiTefC.getValorTransacao(), this.valorMinParcelaSemJuros, Contexto.getContexto().getEntradaIntegracao().getNumeroParcelas())) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.VALOR_MINIMO_PARCELA_INVALIDO, inter.getMessage("CAPNUMPAR_VALOR_MIN_PARCELA")));
                    return PARCELA_INVALIDA_AC;
                }
            } else if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA && entradaApiTefC.getValorTransacao() != null && this.isValorTransacaoMenorQueValorMinimoParcela(entradaApiTefC.getValorTransacao(), this.valorMinParcelaComJuros, Contexto.getContexto().getEntradaIntegracao().getNumeroParcelas())) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.VALOR_MINIMO_PARCELA_INVALIDO, inter.getMessage("CAPNUMPAR_VALOR_MIN_PARCELA")));
                return PARCELA_INVALIDA_AC;
            }
            if (this.verificaRotativo(saidaApiTefC.isRotativoHabilitado(), Contexto.getContexto().getEntradaIntegracao().getNumeroParcelas()) && this.isQtdMinimaParcelasInvalida(Contexto.getContexto().getEntradaIntegracao().getNumeroParcelas())) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.NUMERO_PARCELA_INVALIDO, inter.getMessage("CAPNUMPAR_NR_PARC_INVALIDO")));
                return PARCELA_INVALIDA_AC;
            }
            if (this.isQtdMaximaParcelasInvalida(Contexto.getContexto().getEntradaIntegracao().getNumeroParcelas())) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.EXCEDE_PARCELA, inter.getMessage("CAPNUMPAR_EXCEDE_PARCELA")));
                return PARCELA_INVALIDA_AC;
            }
            entradaApiTefC.setNumeroParcelas(Contexto.getContexto().getEntradaIntegracao().getNumeroParcelas());
            return SUCESS;
        }
        if (entradaApiTefC.getNumeroParcelas() >= 0) {
            return FILLED;
        }
        if (this.maxParcelas < 1) {
            return NOT_REQUIRED;
        }
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPNUMPAR_TITLE"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_NUMERO_PARCELAS, true, 14, true);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USERCANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String numParcelas = eventoTeclado.getStringLida().substring(num);
        int parcelas = 0;
        try {
            parcelas = Integer.parseInt(numParcelas);
            logger.info("N\u00famero parcelas digitada: " + parcelas);
        }
        catch (NumberFormatException e) {
            if (this.exibeMensagem(inter.getMessage("CAPNUMPAR_NR_PARC_INVALIDO"), perifericos).equals("ENTRA")) {
                return PARCELA_INVALIDA;
            }
            return USERCANCEL;
        }
        if (this.verificaRotativo(saidaApiTefC.isRotativoHabilitado(), parcelas) && this.isQtdMinimaParcelasInvalida(parcelas)) {
            if (this.exibeMensagem(inter.getMessage("CAPNUMPAR_NR_PARC_INVALIDO"), perifericos).equals("ENTRA")) {
                logger.info("n\u00famero de parcelas invalido, " + inter.getMessage("CAPNUMPAR_NR_PARC_INVALIDO"));
                return PARCELA_INVALIDA;
            }
            return USERCANCEL;
        }
        if (this.isQtdMaximaParcelasInvalida(parcelas)) {
            if (this.exibeMensagem(inter.getMessage("CAPNUMPAR_EXCEDE_PARCELA"), perifericos).equals("ENTRA")) {
                logger.info("excede parcelas, " + inter.getMessage("CAPNUMPAR_EXCEDE_PARCELA"));
                return PARCELA_INVALIDA;
            }
            return USERCANCEL;
        }
        if (Contexto.getContexto().getPlano() == Plano.LOJISTA) {
            if (entradaApiTefC.getValorTransacao() != null && !saidaApiTefC.isRotativoHabilitado() && this.isValorTransacaoMenorQueValorMinimoParcela(entradaApiTefC.getValorTransacao(), this.valorMinParcelaSemJuros, parcelas)) {
                if (this.exibeMensagem(inter.getMessage("CAPNUMPAR_VALOR_MIN_PARCELA"), perifericos).equals("ENTRA")) {
                    return PARCELA_INVALIDA;
                }
                return USERCANCEL;
            }
        } else if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA && entradaApiTefC.getValorTransacao() != null && !saidaApiTefC.isRotativoHabilitado() && this.isValorTransacaoMenorQueValorMinimoParcela(entradaApiTefC.getValorTransacao(), this.valorMinParcelaComJuros, parcelas)) {
            if (this.exibeMensagem(inter.getMessage("CAPNUMPAR_VALOR_MIN_PARCELA"), perifericos).equals("ENTRA")) {
                return PARCELA_INVALIDA;
            }
            return USERCANCEL;
        }
        Contexto.getContexto().getEntradaApiTefC().setNumeroParcelas(parcelas);
        return SUCESS;
    }

    protected void configuraAtributosPlano() throws IllegalStateException {
        if (Contexto.getContexto().getPlano() == null) {
            throw new IllegalStateException("Plano A prazo invalido");
        }
        if (Contexto.getContexto().getPlano() == Plano.CREDIARIO && Contexto.getContexto().getSaidaApiTefC().getMinParcelas() != null) {
            this.minParcelas = Contexto.getContexto().getSaidaApiTefC().getMinParcelas();
            this.maxParcelas = Contexto.getContexto().getSaidaApiTefC().getMaxParcelas();
            return;
        }
        switch (Contexto.getContexto().getPlano()) {
            case ADMINISTRADORA: 
            case ADMINISTRADORA_IATA: {
                this.valorMinParcelaComJuros = Contexto.getContexto().getSaidaApiTefC().getValorMinimoParcelaComJuros();
            }
            case CREDIARIO: 
            case CDC: 
            case PRIVATELABEL_APRAZO: {
                this.maxParcelas = Contexto.getContexto().getSaidaApiTefC().getQtdMaximaParcelaComJuros();
                this.minParcelas = Contexto.getContexto().getSaidaApiTefC().getQtdMinimaParcelaComJuros();
                break;
            }
            case LOJISTA: 
            case LOJISTA_IATA: {
                this.valorMinParcelaSemJuros = Contexto.getContexto().getSaidaApiTefC().getValorMinimoParcelaSemJuros();
            }
            case PARCELEMAIS: 
            case PARCELADO: 
            case IATA: {
                this.maxParcelas = Contexto.getContexto().getSaidaApiTefC().getQtdMaximaParcelaSemJuros();
                this.minParcelas = Contexto.getContexto().getSaidaApiTefC().getQtdMinimaParcelaSemJuros();
                break;
            }
            default: {
                throw new IllegalStateException("Plano A prazo invalido");
            }
        }
    }

    private String exibeMensagem(String msg, ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(new LayoutDisplay(msg));
        return eventoTeclado.getTeclaFinalizadora();
    }

    private boolean isQtdMinimaParcelasInvalida(int numeroParcela) {
        return numeroParcela < this.minParcelas || numeroParcela <= 1;
    }

    private boolean isQtdMaximaParcelasInvalida(int numeroParcela) {
        return numeroParcela > this.maxParcelas;
    }

    private boolean verificaRotativo(boolean rotativo, int parcelas) {
        return !rotativo || parcelas != 0 && parcelas != 1;
    }

    protected boolean isValorTransacaoMenorQueValorMinimoParcela(BigDecimal valorTransacao, BigDecimal valorToCompare, int qtdeParcelas) {
        if (valorToCompare == null) {
            return false;
        }
        BigDecimal valorParcela = valorTransacao.divide(new BigDecimal(qtdeParcelas), 6);
        return valorParcela.compareTo(valorToCompare) == -1;
    }
}

