/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaNumeroTerminalOriginal
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (!StringUtil.isEmpty(entrada.getNumeroTerminalOriginal())) {
            return FILLED;
        }
        if (!saida.isCapturaNumeroTerminalOriginal()) {
            return NOT_REQUIRED;
        }
        String valor = null;
        int caracteresDigitados = 0;
        ControladorPerifericos periferico = dados.getPerifericos();
        while (caracteresDigitados == 0) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("CAPNUMTERORI_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel, ConstantesApiAc.CAP_NUM_TERMINAL_ORIGINAL);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num).trim();
            caracteresDigitados = valor.length();
        }
        entrada.setNumeroTerminalOriginal(valor);
        this.logger.debug(String.format("Entrada valida de numero de terminal original = %s", valor));
        return SUCCESS;
    }
}

