/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.BombaFusion;
import com.csi.ctfclient.apitef.model.ProdutoConvenioCombustivel;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.UserCancelException;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.fusion.ControladorFusion;
import com.csi.ctfclient.tools.devices.fusion.DadosPistaFusion;
import com.csi.ctfclient.tools.devices.fusion.ProdutoBombaCombustivel;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MicCapturaProdutoServicoConvenioCombustivel {
    public static final String SUCCESS = "SUCCESS";
    public static final String SUCCESS_CAPTURA_SERVICOS_FINALIZADA = "SUCCESS_CAPTURA_SERVICOS_FINALIZADA";
    public static final String SUCCESS_BLANK = "SUCCESS_BLANK";
    public static final String ERROR = "ERROR";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USER_CANCEL = "USER_CANCEL";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
    private ProdutoConvenioCombustivel servicoAgrupadorConvenioCombustivel;

    public String execute(Process dados) throws ExcecaoNaoLocal {
        List<ProdutoConvenioCombustivel> listProdutosSelecionados;
        ControladorPerifericos perifericos = dados.getPerifericos();
        List<ProdutoConvenioCombustivel> listProdutosServicosDisponiveis = Contexto.getContexto().getListProdutosConvenioCombustivelDisponiveis();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (listProdutosServicosDisponiveis == null || listProdutosServicosDisponiveis.isEmpty()) {
            if (saida.isPermiteListaProdutosConvenioCombustivelVazia()) {
                return SUCCESS_BLANK;
            }
            logger.error("Lista de produtos vazia");
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.PRODUTOS_CONVENIO_COMBUSTIVEL_VAZIA, "LISTA DE PRODUTOS DE CONVENIO COMBUSTIVEL VAZIA"));
            return ERROR;
        }
        if (Contexto.getContexto().getEntradaApiTefC().getListProdutoConvenioCombustivel() != null && Contexto.getContexto().getEntradaApiTefC().getListProdutoConvenioCombustivel().size() > 0) {
            boolean existeServicoSelecionado = false;
            Iterator<ProdutoConvenioCombustivel> iteProdutoServico = Contexto.getContexto().getEntradaApiTefC().getListProdutoConvenioCombustivel().iterator();
            while (iteProdutoServico.hasNext()) {
                if (!iteProdutoServico.next().getTipo().equals("S")) continue;
                existeServicoSelecionado = true;
            }
            if (existeServicoSelecionado) {
                listProdutosServicosDisponiveis = this.removerProdutos(Contexto.getContexto().getListProdutosConvenioCombustivelDisponiveis());
            }
        }
        ProdutoConvenioCombustivel produtoSelecionado = null;
        try {
            boolean continuaCaptura = true;
            while (continuaCaptura) {
                produtoSelecionado = this.capturaProdutoLista(perifericos, listProdutosServicosDisponiveis);
                if (produtoSelecionado.isItemFinalizador()) {
                    continuaCaptura = false;
                    continue;
                }
                if (Contexto.getContexto().getSaidaApiTefC() == null || Contexto.getContexto().getSaidaApiTefC().isConfirmaProdutoConvenioCombustivel()) {
                    LayoutDisplay displayConfirmaProduto = new LayoutDisplay(2);
                    displayConfirmaProduto.addLinha(new Linha("SELECIONADO"));
                    displayConfirmaProduto.addLinha(new Linha(produtoSelecionado.getDescricao()));
                    displayConfirmaProduto.addLinha(new Linha(""));
                    displayConfirmaProduto.addLinha(new Linha("CONFIRMA?"));
                    EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayConfirmaProduto);
                    if (eventoTeclado.getTeclaFinalizadora().equals("ENTRA")) {
                        continuaCaptura = false;
                        continue;
                    }
                    continuaCaptura = true;
                    continue;
                }
                continuaCaptura = false;
            }
            if (this.servicoAgrupadorConvenioCombustivel != null) {
                Contexto.getContexto().setServicoAgrupadorConvenioCombustivel(this.servicoAgrupadorConvenioCombustivel);
            }
            if (produtoSelecionado.isItemFinalizador()) {
                if (Contexto.getContexto().getEntradaApiTefC().getListProdutoConvenioCombustivel() != null && Contexto.getContexto().getEntradaApiTefC().getListProdutoConvenioCombustivel().size() > 0) {
                    Contexto.getContexto().setOrdemCapturaInformacaoAdicional(Contexto.getContexto().getOrdemCapturaInformacaoAdicional() + 1);
                    return SUCCESS_CAPTURA_SERVICOS_FINALIZADA;
                }
                LayoutDisplay displayModel = new LayoutDisplay(this.inter.getMessage("CAPPROCONCOM_ERRO_PRODUTO"));
                displayModel.setDelay(1500L);
                perifericos.imprimeDisplay(displayModel);
                Contexto.getContexto().setServicoAgrupadorConvenioCombustivel(null);
                return "RERUN";
            }
        }
        catch (UserCancelException e) {
            return USER_CANCEL;
        }
        if (produtoSelecionado.getTipo().equals("S")) {
            Contexto.getContexto().setConvenioCombustivelPosAutorizado(true);
        }
        if (!Contexto.getContexto().isConvenioCombustivelPosAutorizado()) {
            LayoutDisplay displayModel = new LayoutDisplay(this.inter.getMessage("ENVIO1F_TITLE"));
            perifericos.imprimeDisplay(displayModel);
            if (Contexto.getContexto().getSaidaApiTefC() == null || Contexto.getContexto().getSaidaApiTefC().isConfirmaProdutoConvenioCombustivel()) {
                ControladorFusion fusion = ControladorFusion.getInstancia();
                DadosPistaFusion pistaFusion = null;
                try {
                    pistaFusion = fusion.infoPista();
                }
                catch (Exception e) {
                    logger.warn("Erro durante a obtencao dos dados do fusion: " + e.getMessage());
                }
                if (pistaFusion == null || pistaFusion.getResultado() != 0) {
                    if (pistaFusion != null) {
                        logger.error("Erro ao ler os produtos dispon\u00edveis para abastecimento, c\u00f3digo: " + pistaFusion.getResultado());
                    }
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_CONEXAO_FUSION, "ERRO CONEXAO FUSION"));
                    return ERROR;
                }
                String codigoFusion = ControladorFusion.converteCodigoProdutoFusion(produtoSelecionado.getCodigo());
                if (!this.isFusionContemProduto(pistaFusion.getBombas(), codigoFusion)) {
                    logger.info("C\u00f3digo do produto n\u00e3o cadastrado no controlador de bombas (Fusion): '" + produtoSelecionado.getCodigo() + "'/'" + codigoFusion + "' retornado pela carga, chaveando para P\u00d3S-AUTORIZADA");
                    Contexto.getContexto().setConvenioCombustivelPosAutorizado(true);
                }
            }
        }
        if ((listProdutosSelecionados = Contexto.getContexto().getEntradaApiTefC().getListProdutoConvenioCombustivel()) == null) {
            listProdutosSelecionados = new ArrayList<ProdutoConvenioCombustivel>();
        }
        listProdutosSelecionados.add(produtoSelecionado);
        int versaoProdutos = 0;
        if (Contexto.getContexto().getSaidaApiTefC() != null) {
            versaoProdutos = Contexto.getContexto().getSaidaApiTefC().getVersaoListaProdutosConvenioCombustivel();
        }
        Contexto.getContexto().getEntradaApiTefC().setListProdutoConvenioCombustivel(listProdutosSelecionados, versaoProdutos);
        return SUCCESS;
    }

    private ProdutoConvenioCombustivel capturaProdutoLista(ControladorPerifericos perifericos, List<ProdutoConvenioCombustivel> listProdutos) throws UserCancelException, ExcecaoNaoLocal {
        ProdutoConvenioCombustivel produto;
        LayoutMenu layoutMenu = new LayoutMenu(this.inter.getMessage("CAPPROCONCOM_TITLE"), true);
        ProdutoConvenioCombustivel[] arrayProdutos = new ProdutoConvenioCombustivel[listProdutos.size()];
        int iTecla = 0;
        Iterator<ProdutoConvenioCombustivel> iter = listProdutos.iterator();
        while (iter.hasNext()) {
            arrayProdutos[iTecla] = produto = iter.next();
            layoutMenu.addItem(new ItemMenu(produto.getDescricao(), String.valueOf(iTecla + 1), 1));
            ++iTecla;
        }
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            throw new UserCancelException();
        }
        produto = arrayProdutos[opcao - 1];
        if (produto.getProdutosDependentes() != null && produto.getProdutosDependentes().size() > 0) {
            if (produto.getTipo().equals("S")) {
                this.servicoAgrupadorConvenioCombustivel = produto;
            }
            return this.capturaProdutoLista(perifericos, produto.getProdutosDependentes());
        }
        return produto;
    }

    private boolean isFusionContemProduto(List<BombaFusion> listBombas, String idProduto) {
        for (BombaFusion bomba : listBombas) {
            for (ProdutoBombaCombustivel produto : bomba.getProdutos()) {
                if (!produto.getId().equals(idProduto)) continue;
                return true;
            }
        }
        return false;
    }

    private List<ProdutoConvenioCombustivel> removerProdutos(List<ProdutoConvenioCombustivel> listProdutoServicos) {
        ArrayList<ProdutoConvenioCombustivel> listServicos = new ArrayList<ProdutoConvenioCombustivel>();
        for (ProdutoConvenioCombustivel produtoServico : listProdutoServicos) {
            if (!produtoServico.getTipo().equals("S")) continue;
            listServicos.add(produtoServico);
        }
        return this.entrarProdutoAgrupador(listServicos);
    }

    private List<ProdutoConvenioCombustivel> entrarProdutoAgrupador(List<ProdutoConvenioCombustivel> listServicos) {
        boolean contemApenasAgrupadores = true;
        for (ProdutoConvenioCombustivel servico : listServicos) {
            if (servico.getProdutosDependentes() != null && servico.getProdutosDependentes().size() != 0) continue;
            contemApenasAgrupadores = false;
            break;
        }
        if (contemApenasAgrupadores && listServicos.size() == 1) {
            return listServicos.get(0).getProdutosDependentes();
        }
        return listServicos;
    }
}

