/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.model.ProdutoConvenioCombustivel;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.UserCancelException;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MicCapturaProdutoServicoFrota {
    public static final String SUCCESS = "SUCCESS";
    public static final String SUCCESS_CAPTURA_SERVICOS_FINALIZADA = "SUCCESS_CAPTURA_SERVICOS_FINALIZADA";
    public static final String ERROR = "ERROR";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USER_CANCEL = "USER_CANCEL";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
    private ProdutoConvenioCombustivel servicoAgrupadorConvenioCombustivel;

    public String execute(Process dados) throws ExcecaoNaoLocal {
        List<ProdutoConvenioCombustivel> listProdutosSelecionados;
        ControladorPerifericos perifericos = dados.getPerifericos();
        List<ProdutoConvenioCombustivel> listProdutosServicosDisponiveis = Contexto.getContexto().getListProdutosConvenioCombustivelDisponiveis();
        if (listProdutosServicosDisponiveis == null || listProdutosServicosDisponiveis.isEmpty()) {
            logger.error("Lista de produtos vazia");
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.PRODUTOS_CONVENIO_COMBUSTIVEL_VAZIA, "LISTA DE PRODUTOS DE CONVENIO COMBUSTIVEL VAZIA"));
            return ERROR;
        }
        ProdutoConvenioCombustivel produtoSelecionado = null;
        try {
            boolean continuaCaptura = true;
            while (continuaCaptura) {
                produtoSelecionado = this.capturaProdutoLista(perifericos, listProdutosServicosDisponiveis, false);
                if (produtoSelecionado == null) continue;
                if (produtoSelecionado.isItemFinalizador()) {
                    continuaCaptura = false;
                    continue;
                }
                if (Contexto.getContexto().getSaidaApiTefC() == null || Contexto.getContexto().getSaidaApiTefC().isConfirmaProdutoConvenioCombustivel()) {
                    LayoutDisplay displayConfirmaProduto = new LayoutDisplay(2);
                    displayConfirmaProduto.addLinha(new Linha("SELECIONADO"));
                    displayConfirmaProduto.addLinha(new Linha(produtoSelecionado.getDescricao()));
                    displayConfirmaProduto.addLinha(new Linha(""));
                    displayConfirmaProduto.addLinha(new Linha("CONFIRMA?"));
                    EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayConfirmaProduto);
                    if (eventoTeclado.getTeclaFinalizadora().equals("ENTRA")) {
                        continuaCaptura = false;
                        continue;
                    }
                    continuaCaptura = true;
                    continue;
                }
                continuaCaptura = false;
            }
            if (this.servicoAgrupadorConvenioCombustivel != null) {
                Contexto.getContexto().setServicoAgrupadorConvenioCombustivel(this.servicoAgrupadorConvenioCombustivel);
            }
            if (produtoSelecionado.isItemFinalizador()) {
                if (Contexto.getContexto().getEntradaApiTefC().getListProdutoConvenioCombustivel() != null && Contexto.getContexto().getEntradaApiTefC().getListProdutoConvenioCombustivel().size() > 0) {
                    Contexto.getContexto().setOrdemCapturaInformacaoAdicional(Contexto.getContexto().getOrdemCapturaInformacaoAdicional() + 1);
                    return SUCCESS_CAPTURA_SERVICOS_FINALIZADA;
                }
                LayoutDisplay displayModel = new LayoutDisplay(this.inter.getMessage("CAPPROCONCOM_ERRO_PRODUTO"));
                displayModel.setDelay(1500L);
                perifericos.imprimeDisplay(displayModel);
                Contexto.getContexto().setServicoAgrupadorConvenioCombustivel(null);
                return "RERUN";
            }
        }
        catch (UserCancelException e) {
            return USER_CANCEL;
        }
        int versaoProdutos = 0;
        if (Contexto.getContexto().getSaidaApiTefC() != null) {
            versaoProdutos = Contexto.getContexto().getSaidaApiTefC().getVersaoListaProdutosConvenioCombustivel();
        }
        if ((listProdutosSelecionados = Contexto.getContexto().getEntradaApiTefC().getListProdutoConvenioCombustivel()) == null) {
            listProdutosSelecionados = new ArrayList<ProdutoConvenioCombustivel>();
        }
        listProdutosSelecionados.add(produtoSelecionado);
        Contexto.getContexto().getEntradaApiTefC().setListProdutoConvenioCombustivel(listProdutosSelecionados, versaoProdutos);
        return SUCCESS;
    }

    private ProdutoConvenioCombustivel capturaProdutoLista(ControladorPerifericos perifericos, List<ProdutoConvenioCombustivel> listProdutos, boolean subMunu) throws UserCancelException, ExcecaoNaoLocal {
        ProdutoConvenioCombustivel produto;
        LayoutMenu layoutMenu = new LayoutMenu(this.inter.getMessage("CAPPROCONCOM_TITLE"), true);
        ProdutoConvenioCombustivel[] arrayProdutos = new ProdutoConvenioCombustivel[listProdutos.size()];
        int iTecla = 0;
        Iterator<ProdutoConvenioCombustivel> iter = listProdutos.iterator();
        while (iter.hasNext()) {
            arrayProdutos[iTecla] = produto = iter.next();
            layoutMenu.addItem(new ItemMenu(produto.getDescricao(), String.valueOf(iTecla + 1), 1));
            ++iTecla;
        }
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            if (subMunu) {
                return null;
            }
            throw new UserCancelException();
        }
        produto = arrayProdutos[opcao - 1];
        if (produto.getProdutosDependentes() != null && produto.getProdutosDependentes().size() > 0) {
            if (produto.getTipo().equals("S")) {
                this.servicoAgrupadorConvenioCombustivel = produto;
            }
            return this.capturaProdutoLista(perifericos, produto.getProdutosDependentes(), true);
        }
        return produto;
    }
}

