/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.model.ProdutoValeGas;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;

public class MicCapturaProdutoValeGas {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaApiTefC.getProdutoValeGas() != null) {
            return FILLED;
        }
        List<ProdutoValeGas> listProdutos = Contexto.getContexto().getSaidaApiTefC().getProdutosValeGas();
        if (listProdutos == null || listProdutos.isEmpty()) {
            logger.error("Erro ao capturar os produtos da operadora de vale g\u00e1s, lista de produtos nula ou vazia.");
            throw new IllegalArgumentException("Lista de produtos nula");
        }
        Iterator<ProdutoValeGas> ite = listProdutos.iterator();
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("CAPPROVALGAS_TITLE"), true);
        ProdutoValeGas[] arrayProdutoTecla = new ProdutoValeGas[listProdutos.size()];
        DecimalFormat df = new DecimalFormat("#,##0.00");
        int iTecla = 0;
        while (ite.hasNext()) {
            ProdutoValeGas produto;
            arrayProdutoTecla[iTecla] = produto = ite.next();
            String valorString = df.format(produto.getValor());
            String msgLinha = StringUtil.completaString(produto.getDescricao(), 12, ' ', 4) + " $" + StringUtil.completaString(valorString, 6, ' ', 3);
            layoutMenu.addItem(new ItemMenu(msgLinha, String.valueOf(iTecla + 1)));
            ++iTecla;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        ProdutoValeGas produtoValeGas = arrayProdutoTecla[opcao - 1];
        entradaApiTefC.setProdutoValeGas(produtoValeGas);
        entradaApiTefC.setValorTransacao(produtoValeGas.getValor());
        return SUCCESS;
    }
}

