/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaTipoDocumento {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String ERROR_AC = "ERROR_AC";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaApiTefC.getTipoDocumento() > 0) {
            return FILLED;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            if (Contexto.getContexto().getEntradaIntegracao().isTipoDocumentoCtrl()) {
                if (Contexto.getContexto().getEntradaIntegracao().getTipoDocumento() == 1 || Contexto.getContexto().getEntradaIntegracao().getTipoDocumento() == 2) {
                    entradaApiTefC.setTipoDocumento(Contexto.getContexto().getEntradaIntegracao().getTipoDocumento());
                    return SUCESS;
                }
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.TIPO_DOCUMENTO_INVALIDO, "TIPO DE DOCUMENTO INVALIDO"));
                return ERROR_AC;
            }
            if (Contexto.getContexto().getEntradaIntegracao().isMultiTerminal()) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.TIPO_DOCUMENTO_INVALIDO, "TIPO DE DOCUMENTO AUSENTE"));
                return ERROR_AC;
            }
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("CAPTIPDOC_TITLE"), true);
        layoutMenu.addItem(new ItemMenu(inter.getMessage("CAPTIPDOC_CPF"), "1"));
        layoutMenu.addItem(new ItemMenu(inter.getMessage("CAPTIPDOC_CNPJ"), "2"));
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        switch (opcao) {
            case 1: {
                entradaApiTefC.setTipoDocumento(2);
                break;
            }
            case 2: {
                entradaApiTefC.setTipoDocumento(1);
            }
        }
        return SUCESS;
    }
}

