/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.util.HashMap;

public class MicCapturaTipoFinanciamentoDebito {
    public static final String SUCESS = "SUCESS";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String FILLED = "FILLED";
    public static final String ERROR_AC = "ERROR_AC";
    private static final String MSG_OPERATION_NOT_ALLOWED = "OPERACAO NAO PERMITIDA";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        if (Contexto.getContexto().getPlano() != null) {
            return FILLED;
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        boolean parceleMaisHabilitado = false;
        Plano plano = null;
        if (entradaIntegracao != null && entradaIntegracao.getOperacao() != OperationEnum.OP_DEBITO_GENERICO.getKey().intValue() && entradaIntegracao.getOperacao() != OperationEnum.OP_CANCELAMENTO_GENERICO.getKey().intValue() && entradaIntegracao.getOperacao() != OperationEnum.OP_CANCELAMENTO_DIGITADO.getKey().intValue()) {
            int operacao = entradaIntegracao.getOperacao();
            if (operacao == OperationEnum.OP_DEBITO.getKey()) {
                plano = Plano.AVISTA;
            } else if (operacao == OperationEnum.OP_DEB_PRE_DATADO.getKey()) {
                if (saidaApiTefC.getMaximaDiaPre() > 0 || saidaApiTefC.getMaximoMesesAgendamento() > 0) {
                    plano = Plano.PREDATADO;
                }
            } else if (operacao == OperationEnum.OP_DEB_PARCELADO_SEM_PARC_AVISTA.getKey() || operacao == OperationEnum.OP_DEB_PARCELADO_COM_PARC_AVISTA.getKey()) {
                if (saidaApiTefC.getQtdMaximaParcelaSemJuros() > 0) {
                    plano = parceleMaisHabilitado ? Plano.PARCELEMAIS : Plano.PARCELADO;
                }
            } else if ((operacao == OperationEnum.OP_DEB_CDC_GENERICO.getKey() || operacao == OperationEnum.OP_DEB_CDC_COM_PARC_AVISTA.getKey() || operacao == OperationEnum.OP_DEB_CDC_SEM_PARC_AVISTA.getKey()) && saidaApiTefC.getQtdMaximaParcelaComJuros() > 0) {
                plano = Plano.CDC;
            }
            if (plano == null) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.OPERACAO_NAO_PERMITIDA, MSG_OPERATION_NOT_ALLOWED));
                return ERROR_AC;
            }
        } else {
            ControladorPerifericos perifericos = dados.getPerifericos();
            LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage("CAPTIPFINDEB_TITLE"), true);
            HashMap<String, Plano> mapaMenu = new HashMap<String, Plano>();
            int countOpcoesMenu = 1;
            mapaMenu.put(String.valueOf(countOpcoesMenu), Plano.AVISTA);
            layoutMenu.addItem(new ItemMenu("A VISTA", String.valueOf(countOpcoesMenu)));
            ++countOpcoesMenu;
            if (saidaApiTefC.getQtdMaximaParcelaComJuros() > 0) {
                mapaMenu.put(String.valueOf(countOpcoesMenu), Plano.CDC);
                layoutMenu.addItem(new ItemMenu("CDC", String.valueOf(countOpcoesMenu)));
                ++countOpcoesMenu;
            }
            if (saidaApiTefC.getMaximaDiaPre() > 0 || saidaApiTefC.getMaximoMesesAgendamento() > 0) {
                mapaMenu.put(String.valueOf(countOpcoesMenu), Plano.PREDATADO);
                layoutMenu.addItem(new ItemMenu("PRE-DATADO", String.valueOf(countOpcoesMenu)));
                ++countOpcoesMenu;
            }
            if (saidaApiTefC.getQtdMaximaParcelaSemJuros() > 0) {
                if (parceleMaisHabilitado) {
                    mapaMenu.put(String.valueOf(countOpcoesMenu), Plano.PARCELEMAIS);
                    layoutMenu.addItem(new ItemMenu("PARCELE MAIS", String.valueOf(countOpcoesMenu)));
                } else {
                    mapaMenu.put(String.valueOf(countOpcoesMenu), Plano.PARCELADO);
                    layoutMenu.addItem(new ItemMenu("PARCELADO", String.valueOf(countOpcoesMenu)));
                }
                ++countOpcoesMenu;
            }
            if (layoutMenu.getItens().size() == 1) {
                Contexto.getContexto().setPlano((Plano)((Object)mapaMenu.get(String.valueOf(1))));
                return SUCESS;
            }
            int opcao = perifericos.imprimeMenu(layoutMenu);
            if (opcao == -1) {
                return USERCANCEL;
            }
            Contexto.getContexto().setPlano((Plano)((Object)mapaMenu.get(String.valueOf(opcao))));
            return SUCESS;
        }
        Contexto.getContexto().setPlano(plano);
        return SUCESS;
    }
}

