/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;

public class MicCapturaUsuarioPdv {
    public static final String SUCCESS = "SUCCESS";
    public static final String USER_CANCEL = "USER_CANCEL";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        boolean multiTerminal;
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null && entradaIntegracao.isCodigoUsuarioPdvCtrl()) {
            entradaApiTefC.setCodigoUsuarioPdv(entradaIntegracao.getCodigoUsuarioPdv());
            return SUCCESS;
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        boolean bl = multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
        if (!multiTerminal && this.isCaptura(dados)) {
            LayoutDisplay displayModel;
            String valor = null;
            ControladorPerifericos periferico = dados.getPerifericos();
            EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel = new LayoutDisplay(inter.getMessage("CAPUSUPDV_TITLE")), ConstantesApiAc.CAP_USUARIO_PDV);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num).trim();
            entradaApiTefC.setCodigoUsuarioPdv(valor);
        }
        return SUCCESS;
    }

    private boolean isCaptura(Process dados) {
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        return entradaIntegracao != null && entradaIntegracao.getOperacao() == OperationEnum.OP_CONSULTA_ANALITICA_SPC.getKey().intValue();
    }
}

