/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.Parcela;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;
import java.util.Iterator;

public class MicCapturaValor1Parcela {
    public static final String FILLED = "FILLED";
    public static final String SUCESS = "SUCESS";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String VALUE_NOT_VALID = "VALUE_NOT_VALID";
    public static final String VALUE_NOT_VALID_AC = "VALUE_NOT_VALID_AC";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (!saidaApiTefC.isParcela()) {
            return UNECESSARY;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (entradaApiTefC.getValorParcela() != null) {
            return FILLED;
        }
        if (entradaIntegracao != null && entradaIntegracao.isParcelasCtrl()) {
            Iterator<Parcela> parcelas = entradaIntegracao.getParcelas().iterator();
            if (parcelas.hasNext()) {
                Parcela parcela = parcelas.next();
                if (!this.isValidaValorParcela(entradaApiTefC.getValorTransacao(), entradaApiTefC.getValorEntrada(), parcela.getValor(), entradaApiTefC.getNumeroParcelas())) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.CAPVAL1PAR_VALOR_INVALIDO, inter.getMessage("CAPVAL1PAR_VALOR_INVALIDO")));
                    return VALUE_NOT_VALID_AC;
                }
                entradaApiTefC.setValorParcela(parcela.getValor());
            }
        } else {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage("CAPVAL1PAR_ 1PARCELA")));
            displayModel.addLinha(new Linha(inter.getMessage("CAPVAL1PAR_VALOR")));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_1PARCELA, false, 8, false);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USERCANCEL;
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            String digitos = eventoTeclado.getStringLida().substring(num);
            if (digitos.equals("")) {
                digitos = "000";
            }
            BigDecimal valor = new BigDecimal(digitos);
            valor = valor.movePointLeft(2);
            if (!this.isValidaValorParcela(entradaApiTefC.getValorTransacao(), entradaApiTefC.getValorEntrada(), valor, entradaApiTefC.getNumeroParcelas())) {
                if (this.exibeMensagem(perifericos, inter.getMessage("CAPVAL1PAR_VALOR_INVALIDO")).equals("ENTRA")) {
                    return VALUE_NOT_VALID;
                }
                return USERCANCEL;
            }
            entradaApiTefC.setValorParcela(valor);
        }
        return SUCESS;
    }

    private String exibeMensagem(ControladorPerifericos perifericos, String messagem) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(messagem);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }

    public boolean isValidaValorParcela(BigDecimal valorTransacao, BigDecimal valorEntrada, BigDecimal valorParcela, int parcelas) {
        BigDecimal valorCalculado;
        if (valorEntrada == null) {
            valorEntrada = new BigDecimal(0);
        }
        return (valorCalculado = valorParcela.multiply(new BigDecimal(parcelas)).add(valorEntrada)).compareTo(valorTransacao) != 1;
    }
}

