/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class MicCapturaValorAcrescimo {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String INVALID_NUMBER = "INVALID_NUMBER";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USER_CANCEL = "USER_CANCEL";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(Process dados) throws ExcecaoNaoLocal {
        boolean capturaEncargos = true;
        BigDecimal valorAcrescimo = new BigDecimal(0);
        ControladorPerifericos perifericos = dados.getPerifericos();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (saidaApiTefC != null) {
            if (saidaApiTefC.getValorAcrescimo() != null) {
                valorAcrescimo = saidaApiTefC.getValorAcrescimo();
            }
            if (!saidaApiTefC.isCapturaAcrescimo()) {
                logger.info("Assumindo o acr\u00e9scimo retornado pela consulta");
                entradaApiTefC.setValorAcrescimo(valorAcrescimo);
                if (saidaApiTefC.getValorMultaCorban() != null) {
                    entradaApiTefC.setValorMultaCorban(saidaApiTefC.getValorMultaCorban());
                }
                if (saidaApiTefC.getValorJurosCorban() != null) {
                    entradaApiTefC.setValorJurosCorban(saidaApiTefC.getValorJurosCorban());
                }
                return UNECESSARY;
            }
            if (entradaApiTefC.getValorAcrescimo() != null) {
                return SUCCESS;
            }
        } else {
            ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
            if (!conf.isCapturaEncargosCCB()) {
                capturaEncargos = false;
            }
        }
        if (entradaApiTefC.getValorAcrescimo() != null) {
            return FILLED;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isValorAcrescimoCtrl()) {
            logger.info("Assumindo o acr\u00e9scimo informado pela AC");
            entradaApiTefC.setValorAcrescimo(Contexto.getContexto().getEntradaIntegracao().getValorAcrescimo());
            return SUCCESS;
        }
        if (capturaEncargos) {
            BigDecimal valorMulta = null;
            BigDecimal valorJuros = null;
            boolean capturarAcrescimo = true;
            if (saidaApiTefC.isCapturaValorMulta() || saidaApiTefC.isCapturaValorJuros()) {
                if (saidaApiTefC.isCapturaValorMulta()) {
                    try {
                        valorMulta = this.capturaValor(saidaApiTefC.getValorMultaCorban(), perifericos, this.inter.getMessage("CAPVALACR_MULTA"), ConstantesApiAc.CAP_VALOR_MULTA);
                    }
                    catch (UserCancelException e) {
                        return USER_CANCEL;
                    }
                    logger.info("Valor de multa capturado " + valorMulta);
                } else if (saidaApiTefC.getValorMultaCorban() != null) {
                    logger.info("Assumindo a multa retornada pela consulta: " + saidaApiTefC.getValorMultaCorban());
                    valorMulta = saidaApiTefC.getValorMultaCorban();
                }
                if (saidaApiTefC.isCapturaValorJuros()) {
                    try {
                        valorJuros = this.capturaValor(saidaApiTefC.getValorJurosCorban(), perifericos, this.inter.getMessage("CAPVALACR_JUROS"), ConstantesApiAc.CAP_VALOR_JUROS);
                    }
                    catch (UserCancelException e) {
                        return USER_CANCEL;
                    }
                    logger.info("Valor de juros capturado " + valorJuros);
                } else if (saidaApiTefC.getValorJurosCorban() != null) {
                    logger.info("Assumindo os juros retornado pela consulta: " + saidaApiTefC.getValorJurosCorban());
                    valorJuros = saidaApiTefC.getValorJurosCorban();
                }
                capturarAcrescimo = false;
            }
            return this.capturaValorAcrescimo(valorAcrescimo, perifericos, capturarAcrescimo, valorMulta, valorJuros);
        }
        logger.info("CTFClient configurado para n\u00e3o capturar engargos para CCB");
        return UNECESSARY;
    }

    private String capturaValorAcrescimo(BigDecimal valorDefault, ControladorPerifericos perifericos, boolean capturarAcrescimo, BigDecimal valorMulta, BigDecimal valorJuros) throws ExcecaoNaoLocal {
        BigDecimal valorAcrescimo;
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        if (capturarAcrescimo) {
            DecimalFormat decimalFormat = new DecimalFormat("#");
            String valor = decimalFormat.format(valorDefault.multiply(new BigDecimal(100)));
            LayoutDisplay displayModel = new LayoutDisplay(this.inter.getMessage("CAPVALACR_TITLE"));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_ACRESCIMO, valor, true);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USER_CANCEL;
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            String digitos = eventoTeclado.getStringLida().substring(num);
            if (digitos.equals("")) {
                digitos = "000";
            }
            valorAcrescimo = new BigDecimal(digitos);
            valorAcrescimo = valorAcrescimo.movePointLeft(2);
            entrada.setValorAcrescimo(valorAcrescimo);
        } else {
            valorAcrescimo = new BigDecimal(0);
            if (valorMulta != null) {
                entrada.setValorMultaCorban(valorMulta);
                valorAcrescimo = valorAcrescimo.add(valorMulta);
            }
            if (valorJuros != null) {
                entrada.setValorJurosCorban(valorJuros);
                valorAcrescimo = valorAcrescimo.add(valorJuros);
            }
            entrada.setValorAcrescimo(valorAcrescimo);
        }
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (saida != null && saida.getValorTransacao() != null && saida.isValorTotalJaCalculado() && !valorDefault.equals(valorAcrescimo)) {
            BigDecimal valorTransacao = saida.getValorTransacao();
            valorTransacao = valorTransacao.add(valorAcrescimo.subtract(valorDefault));
            logger.info("Novo valor da transa\u00e7\u00e3o: " + valorTransacao);
            saida.setValorTransacao(valorTransacao);
        }
        return SUCCESS;
    }

    private BigDecimal capturaValor(BigDecimal valorDefault, ControladorPerifericos perifericos, String displayCaptura, ConstantesApiAc.TipoCampo tipoCampo) throws ExcecaoNaoLocal, UserCancelException {
        DecimalFormat decimalFormat;
        String valorDefaultString;
        LayoutDisplay displayModel;
        EventoTeclado eventoTeclado;
        if (valorDefault == null) {
            valorDefault = new BigDecimal(0);
        }
        if ("VOLTA".equals((eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel = new LayoutDisplay(displayCaptura), tipoCampo, valorDefaultString = (decimalFormat = new DecimalFormat("#")).format(valorDefault.multiply(new BigDecimal(100))), true)).getTeclaFinalizadora())) {
            throw new UserCancelException();
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        if (digitos.equals("")) {
            digitos = "000";
        }
        BigDecimal valor = new BigDecimal(digitos);
        valor = valor.movePointLeft(2);
        return valor;
    }

    private class UserCancelException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private UserCancelException() {
        }
    }
}

