/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;

public class MicCapturaValorCancelamento {
    public static final String SUCESS = "SUCESS";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String VERIFICAR_FINANCIAMENTO = "VERIFICAR_FINANCIAMENTO";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String INVALID_NUMBER = "INVALID_NUMBER";
    public static final String OPERATION_NOT_ALLOWAD = "OPERATION_NOT_ALLOWAD";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        boolean cancelamentoParcial = saidaApiTefC.isCancelamentoParcial();
        if (!cancelamentoParcial) {
            if (entradaIntegracao != null && entradaIntegracao.isValorCancelamentoCtrl()) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.CANCELAMENTO_INVALIDO, "CANCELAMENTO INVALIDO"));
                return OPERATION_NOT_ALLOWAD;
            }
            entradaApiTefC.setValorCancelamento(entradaApiTefC.getValorTransacao());
            if (Contexto.getContexto().isTransacaoSemLog()) {
                return VERIFICAR_FINANCIAMENTO;
            }
            return UNECESSARY;
        }
        if (entradaIntegracao != null) {
            if (entradaIntegracao.isMultiTerminal()) {
                entradaApiTefC.setValorCancelamento(entradaIntegracao.getValorTransacao());
                return UNECESSARY;
            }
            if (entradaIntegracao.isValorCancelamentoCtrl()) {
                entradaApiTefC.setValorCancelamento(entradaIntegracao.getValorCancelamento());
                return UNECESSARY;
            }
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("CAPVALCAN_TITLE")));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_CANCELAMENTO, true, 12, true);
        if (eventoTeclado.getTeclaFinalizadora().equals("ENTRA")) {
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            String digitos = eventoTeclado.getStringLida().substring(num);
            if (digitos.equals("")) {
                return INVALID_NUMBER;
            }
            BigDecimal valor = new BigDecimal(digitos);
            if (valor.equals(new BigDecimal(0))) {
                return INVALID_NUMBER;
            }
            valor = valor.movePointLeft(2);
            entradaApiTefC.setValorCancelamento(valor);
        } else if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
            return USER_CANCEL;
        }
        return SUCESS;
    }
}

