/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.UserCancelException;
import com.csi.ctfclient.operacoes.microoperacoes.invalidNumberException;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class MicCapturaValorDocumento {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String ERROR_AC = "ERROR_AC";
    public static final String INVALID_NUMBER = "INVALID_NUMBER";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String CONFIRM_VALUE = "CONFIRM_VALUE";
    public static final String INVALID_CONFIRMATION = "INVALID_CONFIRMATION";
    public static final String INVALID_CONFIRMATION_AC = "INVALID_CONFIRMATION_AC";
    private InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();

    public String execute(Process dados) throws ExcecaoNaoLocal {
        BigDecimal valor;
        ControladorPerifericos perifericos = dados.getPerifericos();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaApiTefC.getValorDocumento() != null && !Contexto.getContexto().isConfirmaValorDocumento()) {
            return FILLED;
        }
        BigDecimal valorTransacaoIntegracao = null;
        if (entradaIntegracao != null) {
            if (entradaIntegracao.isValorTransacaoCtrl()) {
                if (entradaApiTefC.getValorDocumento() != null) {
                    if (entradaIntegracao.getValorTransacao().compareTo(entradaApiTefC.getValorDocumento()) == 0) {
                        return SUCESS;
                    }
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.CAPVALDOC_INVALID_CONFIRMATION, this.inter.getMessage("CAPVALDOC_INVALID_CONFIRMATION")));
                    return INVALID_CONFIRMATION_AC;
                }
                entradaApiTefC.setValorDocumento(entradaIntegracao.getValorTransacao());
            }
        } else {
            valorTransacaoIntegracao = entradaApiTefC.getValorTransacao();
        }
        if (entradaIntegracao != null && entradaIntegracao.isValorTransacaoCtrl()) {
            if (entradaIntegracao.getValorTransacao().equals(entradaApiTefC.getValorDocumento())) {
                return SUCESS;
            }
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.CAPVALDOC_INVALID_CONFIRMATION, this.inter.getMessage("CAPVALDOC_INVALID_CONFIRMATION")));
            return INVALID_CONFIRMATION_AC;
        }
        if (saidaApiTefC != null && saidaApiTefC.isExigeConfirmacaoValorDocumento()) {
            BigDecimal valor2 = null;
            if (valorTransacaoIntegracao != null && Contexto.getContexto().isConfirmaValorDocumento()) {
                valor2 = valorTransacaoIntegracao;
            } else {
                try {
                    valor2 = this.solicitaValorUsuario(perifericos);
                }
                catch (UserCancelException e) {
                    return USER_CANCEL;
                }
                catch (invalidNumberException e) {
                    return INVALID_NUMBER;
                }
            }
            if (!Contexto.getContexto().isConfirmaValorDocumento()) {
                entradaApiTefC.setValorDocumento(valor2);
                Contexto.getContexto().setConfirmaValorDocumento(true);
                return CONFIRM_VALUE;
            }
            if (valor2.equals(entradaApiTefC.getValorDocumento())) {
                return SUCESS;
            }
            if (valorTransacaoIntegracao != null) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.CAPVALDOC_INVALID_CONFIRMATION, this.inter.getMessage("CAPVALDOC_INVALID_CONFIRMATION")));
                return INVALID_CONFIRMATION_AC;
            }
            EventoTeclado eventoTeclado = (EventoTeclado)this.exibeMensagem(perifericos, this.inter.getMessage("CAPVALDOC_INVALID_CONFIRMATION"));
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USER_CANCEL;
            }
            if (!Contexto.getContexto().isValorDocumentoCapturado()) {
                entradaApiTefC.setValorDocumento(null);
                Contexto.getContexto().setConfirmaValorDocumento(false);
            }
            return INVALID_CONFIRMATION;
        }
        if (entradaApiTefC.getValorDocumento() != null) {
            if (valorTransacaoIntegracao != null && !valorTransacaoIntegracao.equals(entradaApiTefC.getValorDocumento())) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.CAPVALDOC_INVALID_CONFIRMATION, this.inter.getMessage("CAPVALDOC_INVALID_CONFIRMATION")));
                return INVALID_CONFIRMATION_AC;
            }
            DecimalFormat format = new DecimalFormat("#,##0.00");
            EventoTeclado eventoTeclado = (EventoTeclado)this.exibeMensagem(perifericos, this.inter.getMessage("CAPVALDOC_DOC_VALUE") + " " + format.format(entradaApiTefC.getValorDocumento()));
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USER_CANCEL;
            }
            entradaApiTefC.setValorTransacao(entradaApiTefC.getValorDocumento());
            return SUCESS;
        }
        if (valorTransacaoIntegracao != null) {
            valor = valorTransacaoIntegracao;
        } else {
            try {
                valor = this.solicitaValorUsuario(perifericos);
            }
            catch (UserCancelException e) {
                return USER_CANCEL;
            }
            catch (invalidNumberException e) {
                return INVALID_NUMBER;
            }
        }
        entradaApiTefC.setValorDocumento(valor);
        entradaApiTefC.setValorTransacao(valor);
        return SUCESS;
    }

    private BigDecimal solicitaValorUsuario(ControladorPerifericos perifericos) throws ExcecaoNaoLocal, UserCancelException, invalidNumberException {
        LayoutDisplay displayModel = new LayoutDisplay(this.inter.getMessage("CAPVALDOC_TITLE"));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_DOCUMENTO, false);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            throw new UserCancelException();
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        if (digitos.equals("")) {
            throw new invalidNumberException();
        }
        BigDecimal valor = new BigDecimal(digitos);
        if (valor.equals(new BigDecimal(0))) {
            throw new invalidNumberException();
        }
        valor = valor.movePointLeft(2);
        return valor;
    }

    private EventoDispositivoEntrada exibeMensagem(ControladorPerifericos perifericos, String mensagem) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(mensagem);
        return perifericos.confirmaDado(displayModel);
    }
}

