/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;

public class MicCapturaValorEntrada {
    public static final String FILLED = "FILLED";
    public static final String SUCESS = "SUCESS";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String VALUE_NOT_VALID = "VALUE_NOT_VALID";
    public static final String VALUE_NOT_VALID_AC = "VALUE_NOT_VALID_AC";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (!saidaApiTefC.isEntrada()) {
            return UNECESSARY;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (entradaApiTefC.getValorEntrada() != null) {
            return FILLED;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isValorEntradaCtrl()) {
            if (!this.isValidaValorEntrada(entradaApiTefC.getValorTransacao(), Contexto.getContexto().getEntradaIntegracao().getValorEntrada())) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.CAPVALENT_VALOR_INVALIDO1, inter.getMessage("CAPVALENT_VALOR_INVALIDO1") + " " + inter.getMessage("CAPVALENT_VALOR_INVALIDO2")));
                return VALUE_NOT_VALID_AC;
            }
            entradaApiTefC.setValorEntrada(Contexto.getContexto().getEntradaIntegracao().getValorEntrada());
        } else {
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha(inter.getMessage("CAPVALENT_ENTRADA")));
            displayModel.addLinha(new Linha(inter.getMessage("CAPVALENT_VALOR")));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_ENTRADA, false, 8, false);
            if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                return USERCANCEL;
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            String digitos = eventoTeclado.getStringLida().substring(num);
            if (digitos.equals("")) {
                digitos = "000";
            }
            BigDecimal valor = new BigDecimal(digitos);
            valor = valor.movePointLeft(2);
            if (!this.isValidaValorEntrada(entradaApiTefC.getValorTransacao(), valor)) {
                if (this.exibeMensagem(perifericos, inter.getMessage("CAPVALENT_VALOR_INVALIDO1"), inter.getMessage("CAPVALENT_VALOR_INVALIDO2")).equals("ENTRA")) {
                    return VALUE_NOT_VALID;
                }
                return USERCANCEL;
            }
            entradaApiTefC.setValorEntrada(valor);
        }
        return SUCESS;
    }

    private String exibeMensagem(ControladorPerifericos perifericos, String msg1, String msg2) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(msg1));
        displayModel.addLinha(new Linha(msg2));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }

    public boolean isValidaValorEntrada(BigDecimal valorTransacao, BigDecimal entrada) {
        return entrada.compareTo(valorTransacao) != 0 && entrada.compareTo(valorTransacao) != 1;
    }
}

